/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.taglib;

import com.aoindustries.encoding.Coercion;
import com.aoindustries.lang.NullArgumentException;
import com.aoindustries.taglib.AttributeUtils;
import com.aoindustries.taglib.ParamsAttribute;
import java.lang.reflect.Array;
import java.util.Enumeration;
import java.util.Iterator;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.tagext.JspTag;

public final class ParamUtils {
    public static final String PARAM_ATTRIBUTE_PREFIX = "param.";

    public static void addParam(String fromTagName, JspTag from, String name, Object value) throws JspTagException {
        ParamUtils.addParam(AttributeUtils.findAttributeParent(fromTagName, from, "params", ParamsAttribute.class), name, value);
    }

    public static void addParam(ParamsAttribute paramsAttribute, String name, Object value) throws JspTagException {
        NullArgumentException.checkNotNull((Object)name, (String)"name");
        if (value != null) {
            paramsAttribute.addParam(name, Coercion.toString((Object)value));
        }
    }

    public static void addIterableParams(ParamsAttribute paramsAttribute, String name, Iterable<?> values) throws JspTagException {
        NullArgumentException.checkNotNull((Object)name, (String)"name");
        if (values != null) {
            ParamUtils.addIteratorParams(paramsAttribute, name, values.iterator());
        }
    }

    public static void addIteratorParams(ParamsAttribute paramsAttribute, String name, Iterator<?> values) throws JspTagException {
        NullArgumentException.checkNotNull((Object)name, (String)"name");
        if (values != null) {
            while (values.hasNext()) {
                Object elem = values.next();
                if (elem == null) continue;
                ParamUtils.addParam(paramsAttribute, name, Coercion.toString(elem));
            }
        }
    }

    public static void addEnumerationParams(ParamsAttribute paramsAttribute, String name, Enumeration<?> values) throws JspTagException {
        NullArgumentException.checkNotNull((Object)name, (String)"name");
        if (values != null) {
            while (values.hasMoreElements()) {
                Object elem = values.nextElement();
                if (elem == null) continue;
                ParamUtils.addParam(paramsAttribute, name, Coercion.toString(elem));
            }
        }
    }

    public static void addArrayParams(ParamsAttribute paramsAttribute, String name, Object values) throws JspTagException {
        NullArgumentException.checkNotNull((Object)name, (String)"name");
        if (values != null) {
            int len = Array.getLength(values);
            for (int c = 0; c < len; ++c) {
                Object elem = Array.get(values, c);
                if (elem == null) continue;
                ParamUtils.addParam(paramsAttribute, name, Coercion.toString((Object)elem));
            }
        }
    }

    public static void setDynamicAttribute(ParamsAttribute paramsAttribute, String uri, String localName, Object value) throws JspTagException {
        assert (uri == null);
        assert (localName.startsWith(PARAM_ATTRIBUTE_PREFIX));
        if (value != null) {
            String paramName = localName.substring(PARAM_ATTRIBUTE_PREFIX.length());
            if (value instanceof Iterable) {
                ParamUtils.addIterableParams(paramsAttribute, paramName, (Iterable)value);
            } else if (value instanceof Iterator) {
                ParamUtils.addIteratorParams(paramsAttribute, paramName, (Iterator)value);
            } else if (value instanceof Enumeration) {
                ParamUtils.addEnumerationParams(paramsAttribute, paramName, (Enumeration)value);
            } else if (value.getClass().isArray()) {
                ParamUtils.addArrayParams(paramsAttribute, paramName, value);
            } else {
                ParamUtils.addParam(paramsAttribute, paramName, Coercion.toString((Object)value));
            }
        }
    }

    private ParamUtils() {
    }
}

