/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.taglib;

import com.aoindustries.encoding.Coercion;
import com.aoindustries.encoding.MediaException;
import com.aoindustries.encoding.MediaType;
import com.aoindustries.io.Writable;
import com.aoindustries.taglib.AutoEncodingNullTag;
import com.aoindustries.taglib.TypeAttribute;
import com.aoindustries.taglib.ValueAttribute;
import com.aoindustries.util.i18n.BundleLookupMarkup;
import com.aoindustries.util.i18n.BundleLookupThreadContext;
import java.io.IOException;
import java.io.Writer;
import javax.servlet.jsp.JspTagException;

public class OutTag
extends AutoEncodingNullTag
implements ValueAttribute,
TypeAttribute {
    private Object value;
    private Object def;
    private MediaType mediaType = MediaType.TEXT;
    private String toStringResult;
    private BundleLookupMarkup lookupMarkup;

    @Override
    public MediaType getOutputType() {
        return this.mediaType;
    }

    @Override
    public void setValue(Object value) {
        this.value = value;
    }

    public void setDefault(Object def) {
        this.def = def;
    }

    @Override
    public void setType(Object type) throws JspTagException {
        MediaType newMediaType;
        if (type instanceof MediaType) {
            newMediaType = (MediaType)type;
        } else {
            String typeStr = Coercion.toString((Object)type);
            newMediaType = MediaType.getMediaTypeByName((String)typeStr);
            if (newMediaType == null) {
                try {
                    newMediaType = MediaType.getMediaTypeForContentType((String)typeStr);
                }
                catch (MediaException e) {
                    throw new JspTagException((Throwable)e);
                }
            }
        }
        this.mediaType = newMediaType;
    }

    @Override
    protected void writePrefix(MediaType containerType, Writer out) throws IOException {
        Object effectiveValue;
        Object object = effectiveValue = this.value != null ? this.value : this.def;
        if (!(effectiveValue instanceof Writable) || ((Writable)effectiveValue).isFastToString()) {
            this.toStringResult = Coercion.toString((Object)effectiveValue);
            BundleLookupThreadContext threadContext = BundleLookupThreadContext.getThreadContext((boolean)false);
            this.lookupMarkup = threadContext != null ? threadContext.getLookupMarkup(this.toStringResult) : null;
            if (this.lookupMarkup != null) {
                this.lookupMarkup.appendPrefixTo(containerType.getMarkupType(), (Appendable)out);
            }
        }
    }

    @Override
    protected void doTag(Writer out) throws JspTagException, IOException {
        if (this.toStringResult != null) {
            out.write(this.toStringResult);
        } else if (this.value != null) {
            Coercion.write((Object)this.value, (Writer)out);
        } else if (this.def != null) {
            Coercion.write((Object)this.def, (Writer)out);
        }
    }

    @Override
    protected void writeSuffix(MediaType containerType, Writer out) throws IOException {
        if (this.lookupMarkup != null) {
            this.lookupMarkup.appendSuffixTo(containerType.getMarkupType(), (Appendable)out);
        }
    }
}

