/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.taglib;

import com.aoindustries.encoding.Coercion;
import com.aoindustries.encoding.MediaEncoder;
import com.aoindustries.encoding.MediaType;
import com.aoindustries.encoding.TextInXhtmlAttributeEncoder;
import com.aoindustries.encoding.TextInXhtmlEncoder;
import com.aoindustries.io.buffer.BufferResult;
import com.aoindustries.taglib.AutoEncodingBufferedTag;
import com.aoindustries.taglib.DisabledAttribute;
import com.aoindustries.taglib.MarkupUtils;
import com.aoindustries.taglib.SelectedAttribute;
import com.aoindustries.taglib.ValueAttribute;
import com.aoindustries.util.i18n.MarkupType;
import java.io.IOException;
import java.io.Writer;
import javax.servlet.jsp.JspTagException;

public class OptionTag
extends AutoEncodingBufferedTag
implements ValueAttribute,
SelectedAttribute,
DisabledAttribute {
    private boolean valueSet;
    private Object value;
    private boolean selected;
    private boolean disabled;

    @Override
    public MediaType getContentType() {
        return MediaType.TEXT;
    }

    @Override
    public MediaType getOutputType() {
        return MediaType.XHTML;
    }

    @Override
    public void setValue(Object value) {
        this.valueSet = true;
        this.value = value;
    }

    @Override
    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    @Override
    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    @Override
    protected void doTag(BufferResult capturedBody, Writer out) throws JspTagException, IOException {
        capturedBody = capturedBody.trim();
        if (!this.valueSet) {
            this.setValue(capturedBody);
        }
        out.write("<option value=\"");
        Coercion.write((Object)this.value, (MediaEncoder)TextInXhtmlAttributeEncoder.textInXhtmlAttributeEncoder, (Writer)out);
        out.write(34);
        if (this.selected) {
            out.write(" selected=\"selected\"");
        }
        if (this.disabled) {
            out.write(" disabled=\"disabled\"");
        }
        out.write(62);
        MarkupUtils.writeWithMarkup(capturedBody, MarkupType.TEXT, (MediaEncoder)TextInXhtmlEncoder.textInXhtmlEncoder, out);
        out.write("</option>");
    }
}

