/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.taglib;

import com.aoindustries.encoding.Coercion;
import com.aoindustries.encoding.MediaException;
import com.aoindustries.encoding.MediaType;
import com.aoindustries.servlet.jsp.LocalizedJspTagException;
import com.aoindustries.taglib.ApplicationResources;
import com.aoindustries.taglib.AutoEncodingNullTag;
import com.aoindustries.taglib.BundleTag;
import com.aoindustries.taglib.MessageArgsAttribute;
import com.aoindustries.taglib.TypeAttribute;
import com.aoindustries.util.i18n.ApplicationResourcesAccessor;
import com.aoindustries.util.i18n.BundleLookupMarkup;
import com.aoindustries.util.i18n.BundleLookupThreadContext;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.DynamicAttributes;

public class MessageTag
extends AutoEncodingNullTag
implements DynamicAttributes,
TypeAttribute,
MessageArgsAttribute {
    private String key;
    private MediaType mediaType = MediaType.TEXT;
    private BitSet messageArgsSet;
    private List<Object> messageArgs;
    private String lookupResult;
    private BundleLookupMarkup lookupMarkup;

    @Override
    public MediaType getOutputType() {
        return this.mediaType;
    }

    public void setKey(String key) {
        this.key = key;
    }

    @Override
    public void setType(Object type) throws JspTagException {
        MediaType newMediaType;
        if (type instanceof MediaType) {
            newMediaType = (MediaType)type;
        } else {
            String typeStr = Coercion.toString((Object)type);
            newMediaType = MediaType.getMediaTypeByName((String)typeStr);
            if (newMediaType == null) {
                try {
                    newMediaType = MediaType.getMediaTypeForContentType((String)typeStr);
                }
                catch (MediaException e) {
                    throw new JspTagException((Throwable)e);
                }
            }
        }
        this.mediaType = newMediaType;
    }

    @Override
    public void addMessageArg(Object value) {
        if (this.messageArgs == null) {
            this.messageArgsSet = new BitSet();
            this.messageArgs = new ArrayList<Object>();
        }
        int index = this.messageArgsSet.nextClearBit(0);
        this.messageArgsSet.set(index);
        if (index >= this.messageArgs.size()) {
            assert (index == this.messageArgs.size());
            this.messageArgs.add(value);
        } else {
            this.messageArgs.set(index, value);
        }
    }

    public void setArg0(Object value) throws JspTagException {
        this.insertMessageArg("arg0", 0, value);
    }

    public void setArg1(Object value) throws JspTagException {
        this.insertMessageArg("arg1", 1, value);
    }

    public void setArg2(Object value) throws JspTagException {
        this.insertMessageArg("arg2", 2, value);
    }

    public void setArg3(Object value) throws JspTagException {
        this.insertMessageArg("arg3", 3, value);
    }

    public void setDynamicAttribute(String uri, String localName, Object value) throws JspTagException {
        if (uri == null && localName.startsWith("arg")) {
            try {
                String numSubstring = localName.substring(3);
                int index = Integer.parseInt(numSubstring);
                if (!numSubstring.equals(Integer.toString(index))) {
                    throw new LocalizedJspTagException(ApplicationResources.accessor, "error.unexpectedDynamicAttribute", new Serializable[]{localName, "arg*"});
                }
                this.insertMessageArg(localName, index, value);
            }
            catch (NumberFormatException err) {
                throw new LocalizedJspTagException((Throwable)err, ApplicationResources.accessor, "error.unexpectedDynamicAttribute", new Serializable[]{localName, "arg*"});
            }
        } else {
            throw new LocalizedJspTagException(ApplicationResources.accessor, "error.unexpectedDynamicAttribute", new Serializable[]{localName, "arg*"});
        }
    }

    private void insertMessageArg(String localName, int index, Object value) throws JspTagException {
        if (this.messageArgs == null) {
            this.messageArgsSet = new BitSet();
            this.messageArgs = new ArrayList<Object>();
        }
        if (this.messageArgsSet.get(index)) {
            throw new LocalizedJspTagException(ApplicationResources.accessor, "MessageTag.duplicateArgument", new Serializable[]{localName});
        }
        this.messageArgsSet.set(index);
        if (index >= this.messageArgs.size()) {
            while (this.messageArgs.size() < index) {
                this.messageArgs.add(null);
            }
            assert (index == this.messageArgs.size());
            this.messageArgs.add(value);
        } else if (this.messageArgs.set(index, value) != null) {
            throw new AssertionError();
        }
    }

    @Override
    protected void writePrefix(MediaType containerType, Writer out) throws JspTagException, IOException {
        String combinedKey;
        PageContext pageContext = (PageContext)this.getJspContext();
        BundleTag bundleTag = BundleTag.getBundleTag(pageContext.getRequest());
        if (bundleTag == null) {
            throw new LocalizedJspTagException(ApplicationResources.accessor, "error.requiredParentTagNotFound", new Serializable[]{"bundle"});
        }
        ApplicationResourcesAccessor accessor = bundleTag.getAccessor();
        String prefix = bundleTag.getPrefix();
        String string = combinedKey = prefix == null || prefix.isEmpty() ? this.key : prefix.concat(this.key);
        if (this.messageArgs == null) {
            this.lookupResult = accessor.getMessage(combinedKey);
        } else {
            int firstClear = this.messageArgsSet.nextClearBit(0);
            if (firstClear < this.messageArgs.size()) {
                throw new LocalizedJspTagException(accessor, "MessageTag.argumentMissing", new Serializable[]{Integer.valueOf(firstClear)});
            }
            this.lookupResult = accessor.getMessage(combinedKey, this.messageArgs.toArray());
        }
        BundleLookupThreadContext threadContext = BundleLookupThreadContext.getThreadContext((boolean)false);
        if (threadContext != null) {
            this.lookupMarkup = threadContext.getLookupMarkup(this.lookupResult);
        }
        if (this.lookupMarkup != null) {
            this.lookupMarkup.appendPrefixTo(containerType.getMarkupType(), (Appendable)out);
        }
    }

    @Override
    protected void doTag(Writer out) throws JspTagException, IOException {
        out.write(this.lookupResult);
    }

    @Override
    protected void writeSuffix(MediaType containerType, Writer out) throws IOException {
        if (this.lookupMarkup != null) {
            this.lookupMarkup.appendSuffixTo(containerType.getMarkupType(), (Appendable)out);
        }
    }
}

