/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.taglib;

import com.aoindustries.encoding.Coercion;
import com.aoindustries.encoding.MediaEncoder;
import com.aoindustries.io.Encoder;
import com.aoindustries.io.Writable;
import com.aoindustries.util.i18n.BundleLookupMarkup;
import com.aoindustries.util.i18n.BundleLookupThreadContext;
import com.aoindustries.util.i18n.MarkupType;
import java.io.IOException;
import java.io.Writer;

public final class MarkupUtils {
    public static void writeWithMarkup(Object value, MarkupType markupType, Writer out) throws IOException {
        if (value != null) {
            if (value instanceof Writable && !((Writable)value).isFastToString()) {
                Coercion.write((Object)value, (Writer)out);
            } else {
                String str = Coercion.toString((Object)value);
                BundleLookupThreadContext threadContext = BundleLookupThreadContext.getThreadContext((boolean)false);
                BundleLookupMarkup lookupMarkup = threadContext != null ? threadContext.getLookupMarkup(str) : null;
                if (lookupMarkup != null) {
                    lookupMarkup.appendPrefixTo(markupType, (Appendable)out);
                }
                out.write(str);
                if (lookupMarkup != null) {
                    lookupMarkup.appendSuffixTo(markupType, (Appendable)out);
                }
            }
        }
    }

    public static void writeWithMarkup(Object value, MarkupType markupType, MediaEncoder encoder, Writer out) throws IOException {
        if (encoder == null) {
            MarkupUtils.writeWithMarkup(value, markupType, out);
        } else if (value != null) {
            if (value instanceof Writable && !((Writable)value).isFastToString()) {
                Coercion.write((Object)value, (MediaEncoder)encoder, (Writer)out);
            } else {
                String str = Coercion.toString((Object)value);
                BundleLookupThreadContext threadContext = BundleLookupThreadContext.getThreadContext((boolean)false);
                BundleLookupMarkup lookupMarkup = threadContext != null ? threadContext.getLookupMarkup(str) : null;
                if (lookupMarkup != null) {
                    lookupMarkup.appendPrefixTo(markupType, (Encoder)encoder, (Appendable)out);
                }
                encoder.write(str, out);
                if (lookupMarkup != null) {
                    lookupMarkup.appendSuffixTo(markupType, (Encoder)encoder, (Appendable)out);
                }
            }
        }
    }

    private MarkupUtils() {
    }
}

