/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.taglib;

import com.aoindustries.encoding.Coercion;
import com.aoindustries.encoding.JavaScriptInXhtmlAttributeEncoder;
import com.aoindustries.encoding.MediaEncoder;
import com.aoindustries.encoding.MediaType;
import com.aoindustries.encoding.TextInXhtmlAttributeEncoder;
import com.aoindustries.io.buffer.BufferResult;
import com.aoindustries.servlet.jsp.LocalizedJspTagException;
import com.aoindustries.taglib.ApplicationResources;
import com.aoindustries.taglib.AttributeRequiredException;
import com.aoindustries.taglib.AutoEncodingBufferedTag;
import com.aoindustries.taglib.CheckedAttribute;
import com.aoindustries.taglib.ClassAttribute;
import com.aoindustries.taglib.DisabledAttribute;
import com.aoindustries.taglib.IdAttribute;
import com.aoindustries.taglib.MarkupUtils;
import com.aoindustries.taglib.MaxlengthAttribute;
import com.aoindustries.taglib.NameAttribute;
import com.aoindustries.taglib.OnblurAttribute;
import com.aoindustries.taglib.OnchangeAttribute;
import com.aoindustries.taglib.OnclickAttribute;
import com.aoindustries.taglib.OnfocusAttribute;
import com.aoindustries.taglib.OnkeypressAttribute;
import com.aoindustries.taglib.ReadonlyAttribute;
import com.aoindustries.taglib.SizeAttribute;
import com.aoindustries.taglib.StyleAttribute;
import com.aoindustries.taglib.TabindexAttribute;
import com.aoindustries.taglib.TypeAttribute;
import com.aoindustries.taglib.ValueAttribute;
import com.aoindustries.util.i18n.MarkupType;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.servlet.jsp.JspTagException;

public class InputTag
extends AutoEncodingBufferedTag
implements IdAttribute,
TypeAttribute,
NameAttribute,
ValueAttribute,
OnclickAttribute,
OnchangeAttribute,
OnfocusAttribute,
OnblurAttribute,
OnkeypressAttribute,
SizeAttribute,
MaxlengthAttribute,
ReadonlyAttribute,
DisabledAttribute,
ClassAttribute,
StyleAttribute,
CheckedAttribute,
TabindexAttribute {
    private static final Set<String> validTypes = Collections.unmodifiableSet(new LinkedHashSet<String>(Arrays.asList("button", "checkbox", "color", "date", "datetime-local", "email", "file", "hidden", "image", "month", "number", "password", "radio", "range", "reset", "search", "submit", "tel", "text", "time", "url", "week")));
    private Object id;
    private Object type;
    private String typeString;
    private Object name;
    private Object value;
    private Object onclick;
    private Object onchange;
    private Object onfocus;
    private Object onblur;
    private Object onkeypress;
    private Object size;
    private Integer maxlength;
    private boolean readonly;
    private boolean disabled;
    private Object clazz;
    private Object style;
    private boolean checked;
    private int tabindex;
    private boolean autocomplete = true;

    public static boolean isValidType(String type) {
        return validTypes.contains(type);
    }

    @Override
    public MediaType getContentType() {
        return MediaType.TEXT;
    }

    @Override
    public MediaType getOutputType() {
        return MediaType.XHTML;
    }

    @Override
    public void setId(Object id) {
        this.id = id;
    }

    @Override
    public void setType(Object type) throws JspTagException {
        String typeStr = Coercion.toString((Object)type);
        if (!InputTag.isValidType(typeStr)) {
            throw new LocalizedJspTagException(ApplicationResources.accessor, "InputTag.type.invalid", new Serializable[]{typeStr});
        }
        this.type = type;
        this.typeString = typeStr;
    }

    @Override
    public void setName(Object name) {
        this.name = name;
    }

    @Override
    public void setValue(Object value) {
        this.value = value;
    }

    @Override
    public void setOnclick(Object onclick) {
        this.onclick = onclick;
    }

    @Override
    public void setOnchange(Object onchange) {
        this.onchange = onchange;
    }

    @Override
    public void setOnfocus(Object onfocus) {
        this.onfocus = onfocus;
    }

    @Override
    public void setOnblur(Object onblur) {
        this.onblur = onblur;
    }

    @Override
    public void setOnkeypress(Object onkeypress) {
        this.onkeypress = onkeypress;
    }

    @Override
    public void setSize(Object size) {
        this.size = size;
    }

    @Override
    public void setMaxlength(Integer maxlength) {
        this.maxlength = maxlength;
    }

    @Override
    public void setReadonly(boolean readonly) {
        this.readonly = readonly;
    }

    @Override
    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    @Override
    public Object getClazz() {
        return this.clazz;
    }

    @Override
    public void setClazz(Object clazz) {
        this.clazz = clazz;
    }

    @Override
    public void setStyle(Object style) {
        this.style = style;
    }

    @Override
    public void setChecked(boolean checked) {
        this.checked = checked;
    }

    @Override
    public void setTabindex(int tabindex) {
        this.tabindex = tabindex;
    }

    public void setAutocomplete(boolean autocomplete) {
        this.autocomplete = autocomplete;
    }

    @Override
    protected void doTag(BufferResult capturedBody, Writer out) throws JspTagException, IOException {
        if (this.type == null) {
            throw new AttributeRequiredException("type");
        }
        if (this.value == null) {
            this.setValue(capturedBody.trim());
        }
        out.write("<input");
        if (this.id != null) {
            out.write(" id=\"");
            Coercion.write((Object)this.id, (MediaEncoder)TextInXhtmlAttributeEncoder.textInXhtmlAttributeEncoder, (Writer)out);
            out.write(34);
        }
        out.write(" type=\"");
        TextInXhtmlAttributeEncoder.encodeTextInXhtmlAttribute((CharSequence)this.typeString, (Appendable)out);
        out.write(34);
        if (this.name != null) {
            out.write(" name=\"");
            Coercion.write((Object)this.name, (MediaEncoder)TextInXhtmlAttributeEncoder.textInXhtmlAttributeEncoder, (Writer)out);
            out.write(34);
        }
        out.write(" value=\"");
        if ("button".equals(this.type) || "submit".equals(this.type)) {
            MarkupUtils.writeWithMarkup(this.value, MarkupType.TEXT, (MediaEncoder)TextInXhtmlAttributeEncoder.textInXhtmlAttributeEncoder, out);
        } else {
            Coercion.write((Object)this.value, (MediaEncoder)TextInXhtmlAttributeEncoder.textInXhtmlAttributeEncoder, (Writer)out);
        }
        out.write(34);
        if (this.onclick != null) {
            out.write(" onclick=\"");
            Coercion.write((Object)this.onclick, (MediaEncoder)JavaScriptInXhtmlAttributeEncoder.javaScriptInXhtmlAttributeEncoder, (Writer)out);
            out.write(34);
        }
        if (this.onchange != null) {
            out.write(" onchange=\"");
            Coercion.write((Object)this.onchange, (MediaEncoder)JavaScriptInXhtmlAttributeEncoder.javaScriptInXhtmlAttributeEncoder, (Writer)out);
            out.write(34);
        }
        if (this.onfocus != null) {
            out.write(" onfocus=\"");
            Coercion.write((Object)this.onfocus, (MediaEncoder)JavaScriptInXhtmlAttributeEncoder.javaScriptInXhtmlAttributeEncoder, (Writer)out);
            out.write(34);
        }
        if (this.onblur != null) {
            out.write(" onblur=\"");
            Coercion.write((Object)this.onblur, (MediaEncoder)JavaScriptInXhtmlAttributeEncoder.javaScriptInXhtmlAttributeEncoder, (Writer)out);
            out.write(34);
        }
        if (this.onkeypress != null) {
            out.write(" onkeypress=\"");
            Coercion.write((Object)this.onkeypress, (MediaEncoder)JavaScriptInXhtmlAttributeEncoder.javaScriptInXhtmlAttributeEncoder, (Writer)out);
            out.write(34);
        }
        if (this.size != null) {
            out.write(" size=\"");
            Coercion.write((Object)this.size, (MediaEncoder)TextInXhtmlAttributeEncoder.textInXhtmlAttributeEncoder, (Writer)out);
            out.write(34);
        }
        if (this.maxlength != null) {
            out.write(" maxlength=\"");
            out.write(this.maxlength.toString());
            out.write(34);
        }
        if (this.readonly) {
            out.write(" readonly=\"readonly\"");
        }
        if (this.disabled) {
            out.write(" disabled=\"disabled\"");
        }
        if (this.clazz != null) {
            out.write(" class=\"");
            Coercion.write((Object)this.clazz, (MediaEncoder)TextInXhtmlAttributeEncoder.textInXhtmlAttributeEncoder, (Writer)out);
            out.write(34);
        }
        if (this.style != null) {
            out.write(" style=\"");
            Coercion.write((Object)this.style, (MediaEncoder)TextInXhtmlAttributeEncoder.textInXhtmlAttributeEncoder, (Writer)out);
            out.write(34);
        }
        if (this.checked) {
            out.write(" checked=\"checked\"");
        }
        if (this.tabindex >= 1) {
            out.write(" tabindex=\"");
            out.write(Integer.toString(this.tabindex));
            out.write(34);
        }
        if (!this.autocomplete) {
            out.write(" autocomplete=\"off\"");
        }
        out.write(" />");
    }
}

