/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.taglib;

import com.aoindustries.encoding.MediaType;
import com.aoindustries.encoding.TextInXhtmlAttributeEncoder;
import com.aoindustries.taglib.AutoEncodingFilteredTag;
import com.aoindustries.util.StringUtility;
import java.io.IOException;
import java.io.Writer;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.PageContext;

public class HtmlTag
extends AutoEncodingFilteredTag {
    public static final String CONTENT_TYPE_XHTML = "application/xhtml+xml";
    public static final String CONTENT_TYPE_HTML = "text/html";
    private DocType doctype = DocType.strict;
    private boolean forceHtml = false;
    private String clazz;
    private String oldIeClass;

    public static boolean useXhtmlContentType(HttpServletRequest request) {
        Enumeration acceptValues = request.getHeaders("Accept");
        boolean hasAcceptHeader = false;
        boolean hasAcceptApplicationXhtmlXml = false;
        boolean hasAcceptHtmlHtml = false;
        boolean hasAcceptStarStar = false;
        if (acceptValues != null) {
            while (acceptValues.hasMoreElements()) {
                hasAcceptHeader = true;
                for (String value : StringUtility.splitString((String)((String)acceptValues.nextElement()), (char)',')) {
                    List params = StringUtility.splitString((String)(value = value.trim()), (char)';');
                    int paramsSize = params.size();
                    if (paramsSize <= 0) continue;
                    String acceptType = ((String)params.get(0)).trim();
                    if (acceptType.equals("*/*")) {
                        hasAcceptStarStar = true;
                        continue;
                    }
                    if (!acceptType.equalsIgnoreCase(CONTENT_TYPE_XHTML) && !acceptType.equalsIgnoreCase(CONTENT_TYPE_HTML)) continue;
                    boolean hasNegativeQ = false;
                    for (int paramNum = 1; paramNum < paramsSize; ++paramNum) {
                        String paramSet = ((String)params.get(paramNum)).trim();
                        if (!paramSet.startsWith("q=") && !paramSet.startsWith("Q=")) continue;
                        try {
                            float q = Float.parseFloat(paramSet.substring(2).trim());
                            if (!(q < 0.0f)) continue;
                            hasNegativeQ = true;
                            break;
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    if (hasNegativeQ) continue;
                    if (acceptType.equalsIgnoreCase(CONTENT_TYPE_XHTML)) {
                        hasAcceptApplicationXhtmlXml = true;
                        continue;
                    }
                    if (acceptType.equalsIgnoreCase(CONTENT_TYPE_HTML)) {
                        hasAcceptHtmlHtml = true;
                        continue;
                    }
                    throw new AssertionError((Object)("Unexpected value for acceptType: " + acceptType));
                }
            }
        }
        if (hasAcceptApplicationXhtmlXml) {
            return true;
        }
        if (hasAcceptHtmlHtml) {
            return false;
        }
        if (hasAcceptStarStar) {
            return false;
        }
        return !hasAcceptHeader;
    }

    @Override
    public MediaType getContentType() {
        return MediaType.XHTML;
    }

    public void setDoctype(String doctype) {
        this.doctype = doctype == null ? null : DocType.valueOf(doctype);
    }

    public void setForceHtml(boolean forceHtml) {
        this.forceHtml = forceHtml;
    }

    public void setClazz(String clazz) {
        this.clazz = clazz;
    }

    public void setOldIeClass(String oldIeClass) {
        this.oldIeClass = oldIeClass;
    }

    public static void writeDocTypeLine(DocType docType, Writer out) throws IOException {
        out.write(docType.getDocTypeLine());
    }

    public static void beginHtmlTag(ServletResponse response, Writer out, boolean isXml, String clazz) throws IOException {
        String language;
        Locale locale;
        out.write("<html");
        if (isXml) {
            out.write(" xmlns=\"http://www.w3.org/1999/xhtml\"");
        }
        if (clazz != null) {
            out.write(" class=\"");
            TextInXhtmlAttributeEncoder.encodeTextInXhtmlAttribute((CharSequence)clazz, (Appendable)out);
            out.write(34);
        }
        if ((locale = response.getLocale()) != null && (language = locale.getLanguage()).length() > 0) {
            String country = locale.getCountry();
            out.write(" lang=\"");
            out.write(language);
            if (country.length() > 0) {
                out.write(45);
                out.write(country);
            }
            out.write(34);
            if (isXml) {
                out.write(" xml:lang=\"");
                out.write(language);
                if (country.length() > 0) {
                    out.write(45);
                    out.write(country);
                }
                out.write(34);
            }
        }
        out.write(62);
    }

    public static void endHtmlTag(Writer out) throws IOException {
        out.write("</html>");
    }

    @Override
    protected void doTag(Writer out) throws JspException, IOException {
        int semiPos;
        PageContext pageContext = (PageContext)this.getJspContext();
        ServletResponse response = pageContext.getResponse();
        response.resetBuffer();
        boolean isXml = !this.forceHtml && HtmlTag.useXhtmlContentType((HttpServletRequest)pageContext.getRequest());
        String contentType = isXml ? CONTENT_TYPE_XHTML : CONTENT_TYPE_HTML;
        response.setContentType(contentType);
        response.setCharacterEncoding("UTF-8");
        String actualContentType = response.getContentType();
        if (actualContentType != null && (semiPos = actualContentType.indexOf(59)) != -1) {
            actualContentType = actualContentType.substring(0, semiPos);
        }
        if (!contentType.equals(actualContentType)) {
            throw new JspTagException("Unable to set content type, response already committed? contentType=" + contentType + ", actualContentType=" + actualContentType);
        }
        HtmlTag.writeDocTypeLine(this.doctype, out);
        if (this.oldIeClass != null) {
            out.write("<!--[if lte IE 8]>");
            HtmlTag.beginHtmlTag(response, out, isXml, this.clazz == null ? this.oldIeClass : this.clazz + " " + this.oldIeClass);
            out.write("<![endif]-->\n<!--[if gt IE 8]><!-->");
            HtmlTag.beginHtmlTag(response, out, isXml, this.clazz);
            out.write("<!--<![endif]-->");
        } else {
            HtmlTag.beginHtmlTag(response, out, isXml, this.clazz);
        }
        super.doTag(out);
        HtmlTag.endHtmlTag(out);
    }

    public static enum DocType {
        html5{

            @Override
            public String getDocTypeLine() {
                return "<!DOCTYPE html>\n";
            }
        }
        ,
        strict{

            @Override
            public String getDocTypeLine() {
                return "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">\n";
            }
        }
        ,
        transitional{

            @Override
            public String getDocTypeLine() {
                return "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">\n";
            }
        }
        ,
        frameset{

            @Override
            public String getDocTypeLine() {
                return "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Frameset//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-frameset.dtd\">\n";
            }
        }
        ,
        none{

            @Override
            public String getDocTypeLine() {
                return "";
            }
        };


        public abstract String getDocTypeLine();
    }
}

