/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.taglib;

import com.aoindustries.encoding.Coercion;
import com.aoindustries.encoding.JavaScriptInXhtmlAttributeEncoder;
import com.aoindustries.encoding.MediaEncoder;
import com.aoindustries.encoding.MediaType;
import com.aoindustries.encoding.TextInXhtmlAttributeEncoder;
import com.aoindustries.io.buffer.BufferResult;
import com.aoindustries.net.HttpParametersMap;
import com.aoindustries.net.MutableHttpParameters;
import com.aoindustries.net.UrlUtils;
import com.aoindustries.servlet.http.Dispatcher;
import com.aoindustries.servlet.http.ServletUtil;
import com.aoindustries.servlet.jsp.LocalizedJspTagException;
import com.aoindustries.taglib.ActionAttribute;
import com.aoindustries.taglib.ApplicationResources;
import com.aoindustries.taglib.AutoEncodingBufferedTag;
import com.aoindustries.taglib.ClassAttribute;
import com.aoindustries.taglib.EnctypeAttribute;
import com.aoindustries.taglib.IdAttribute;
import com.aoindustries.taglib.MarkupUtils;
import com.aoindustries.taglib.MethodAttribute;
import com.aoindustries.taglib.OnsubmitAttribute;
import com.aoindustries.taglib.ParamUtils;
import com.aoindustries.taglib.ParamsAttribute;
import com.aoindustries.taglib.StyleAttribute;
import com.aoindustries.taglib.TargetAttribute;
import com.aoindustries.util.StringUtility;
import com.aoindustries.util.WrappedException;
import com.aoindustries.util.i18n.MarkupType;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.net.URLDecoder;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.DynamicAttributes;

public class FormTag
extends AutoEncodingBufferedTag
implements DynamicAttributes,
MethodAttribute,
IdAttribute,
ActionAttribute,
ParamsAttribute,
TargetAttribute,
EnctypeAttribute,
ClassAttribute,
StyleAttribute,
OnsubmitAttribute {
    private String method = "get";
    private Object id;
    private String action;
    private MutableHttpParameters params;
    private Object target;
    private Object enctype;
    private Object clazz;
    private Object style;
    private Object onsubmit;

    public static boolean isValidMethod(String method) {
        return "get".equals(method) || "post".equals(method);
    }

    @Override
    public MediaType getContentType() {
        return MediaType.XHTML;
    }

    @Override
    public MediaType getOutputType() {
        return MediaType.XHTML;
    }

    @Override
    public void setMethod(String method) throws JspTagException {
        if (!FormTag.isValidMethod(method)) {
            throw new LocalizedJspTagException(ApplicationResources.accessor, "FormTag.method.invalid", new Serializable[]{method});
        }
        this.method = method;
    }

    @Override
    public void setId(Object id) {
        this.id = id;
    }

    @Override
    public void setAction(String action) {
        this.action = action;
    }

    @Override
    public void addParam(String name, String value) {
        if (this.params == null) {
            this.params = new HttpParametersMap();
        }
        this.params.addParameter(name, value);
    }

    @Override
    public void setTarget(Object target) {
        this.target = target;
    }

    @Override
    public void setEnctype(Object enctype) {
        this.enctype = enctype;
    }

    @Override
    public Object getClazz() {
        return this.clazz;
    }

    @Override
    public void setClazz(Object clazz) {
        try {
            this.clazz = Coercion.nullIfEmpty((Object)clazz);
        }
        catch (IOException e) {
            throw new WrappedException((Throwable)e);
        }
    }

    @Override
    public void setStyle(Object style) {
        this.style = style;
    }

    @Override
    public void setOnsubmit(Object onsubmit) {
        this.onsubmit = onsubmit;
    }

    public void setDynamicAttribute(String uri, String localName, Object value) throws JspTagException {
        if (uri != null || !localName.startsWith("param.")) {
            throw new LocalizedJspTagException(ApplicationResources.accessor, "error.unexpectedDynamicAttribute", new Serializable[]{localName, "param.*"});
        }
        ParamUtils.setDynamicAttribute(this, uri, localName, value);
    }

    @Override
    protected void doTag(BufferResult capturedBody, Writer out) throws JspTagException, IOException {
        int questionPos;
        PageContext pageContext = (PageContext)this.getJspContext();
        HttpServletResponse response = (HttpServletResponse)pageContext.getResponse();
        String responseEncoding = response.getCharacterEncoding();
        out.write("<form method=\"");
        out.write(this.method);
        out.write(34);
        if (this.id != null) {
            out.write(" id=\"");
            Coercion.write((Object)this.id, (MediaEncoder)TextInXhtmlAttributeEncoder.textInXhtmlAttributeEncoder, (Writer)out);
            out.write(34);
        }
        if (this.action != null) {
            String contextPath;
            HttpServletRequest request = (HttpServletRequest)pageContext.getRequest();
            out.write(" action=\"");
            this.action = ServletUtil.getAbsolutePath((String)Dispatcher.getCurrentPagePath((HttpServletRequest)request), (String)this.action);
            if (this.action.startsWith("/") && (contextPath = request.getContextPath()).length() > 0) {
                this.action = contextPath + this.action;
            }
            this.action = UrlUtils.encodeUrlPath((String)this.action, (String)responseEncoding);
            this.action = response.encodeURL(this.action);
            questionPos = this.action.indexOf(63);
            TextInXhtmlAttributeEncoder.encodeTextInXhtmlAttribute((CharSequence)this.action, (int)0, (int)(questionPos == -1 ? this.action.length() : questionPos), (Appendable)out);
            out.write(34);
        } else {
            questionPos = -1;
        }
        if (this.target != null) {
            out.write(" target=\"");
            Coercion.write((Object)this.target, (MediaEncoder)TextInXhtmlAttributeEncoder.textInXhtmlAttributeEncoder, (Writer)out);
            out.write(34);
        }
        if (this.enctype != null) {
            out.write(" enctype=\"");
            Coercion.write((Object)this.enctype, (MediaEncoder)TextInXhtmlAttributeEncoder.textInXhtmlAttributeEncoder, (Writer)out);
            out.write(34);
        }
        if (this.clazz != null) {
            out.write(" class=\"");
            Coercion.write((Object)this.clazz, (MediaEncoder)TextInXhtmlAttributeEncoder.textInXhtmlAttributeEncoder, (Writer)out);
            out.write(34);
        }
        if (this.style != null) {
            out.write(" style=\"");
            Coercion.write((Object)this.style, (MediaEncoder)TextInXhtmlAttributeEncoder.textInXhtmlAttributeEncoder, (Writer)out);
            out.write(34);
        }
        if (this.onsubmit != null) {
            out.write(" onsubmit=\"");
            Coercion.write((Object)this.onsubmit, (MediaEncoder)JavaScriptInXhtmlAttributeEncoder.javaScriptInXhtmlAttributeEncoder, (Writer)out);
            out.write(34);
        }
        out.write(62);
        boolean didDiv = false;
        if (questionPos != -1) {
            assert (this.action != null);
            List nameVals = StringUtility.splitString((String)this.action, (int)(questionPos + 1), (int)this.action.length(), (char)'&');
            if (!nameVals.isEmpty()) {
                if (!didDiv) {
                    out.write("<div>\n");
                    didDiv = true;
                }
                for (String nameVal : nameVals) {
                    String value;
                    String name;
                    int equalPos = nameVal.indexOf(61);
                    if (equalPos == -1) {
                        name = URLDecoder.decode(nameVal, responseEncoding);
                        value = "";
                    } else {
                        name = URLDecoder.decode(nameVal.substring(0, equalPos), responseEncoding);
                        value = URLDecoder.decode(nameVal.substring(equalPos + 1), responseEncoding);
                    }
                    out.write("<input type=\"hidden\" name=\"");
                    TextInXhtmlAttributeEncoder.encodeTextInXhtmlAttribute((CharSequence)name, (Appendable)out);
                    out.write("\" value=\"");
                    TextInXhtmlAttributeEncoder.encodeTextInXhtmlAttribute((CharSequence)value, (Appendable)out);
                    out.write("\" />\n");
                }
            }
        }
        if (this.params != null) {
            Iterator paramNames = this.params.getParameterNames();
            while (paramNames.hasNext()) {
                String paramName = (String)paramNames.next();
                List paramValues = this.params.getParameterValues(paramName);
                if (paramValues == null || paramValues.isEmpty()) continue;
                if (!didDiv) {
                    out.write("<div>\n");
                    didDiv = true;
                }
                for (String paramValue : paramValues) {
                    out.write("<input type=\"hidden\" name=\"");
                    TextInXhtmlAttributeEncoder.encodeTextInXhtmlAttribute((CharSequence)paramName, (Appendable)out);
                    out.write("\" value=\"");
                    TextInXhtmlAttributeEncoder.encodeTextInXhtmlAttribute((CharSequence)paramValue, (Appendable)out);
                    out.write("\" />\n");
                }
            }
        }
        if (didDiv) {
            out.write("</div>");
        }
        MarkupUtils.writeWithMarkup(capturedBody, MarkupType.XHTML, out);
        out.write("</form>");
    }
}

