/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.taglib;

import com.aoindustries.io.NullWriter;
import com.aoindustries.net.HttpParametersMap;
import com.aoindustries.servlet.http.Dispatcher;
import com.aoindustries.servlet.http.ServletUtil;
import com.aoindustries.servlet.jsp.LocalizedJspTagException;
import com.aoindustries.taglib.ApplicationResources;
import com.aoindustries.taglib.AttributeRequiredException;
import com.aoindustries.taglib.PageAttribute;
import com.aoindustries.taglib.ParamUtils;
import com.aoindustries.taglib.ParamsAttribute;
import com.aoindustries.util.WildcardPatternMatcher;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.SkipPageException;
import javax.servlet.jsp.tagext.DynamicAttributes;
import javax.servlet.jsp.tagext.JspFragment;
import javax.servlet.jsp.tagext.SimpleTagSupport;

public abstract class DispatchTag
extends SimpleTagSupport
implements DynamicAttributes,
PageAttribute,
ParamsAttribute {
    protected static final String REQUEST_FORWARDED_ATTRIBUTE_NAME = DispatchTag.class.getName() + ".requestForwarded";
    protected String page;
    protected HttpParametersMap params;

    public static boolean isForwarded(ServletRequest req) {
        return req.getAttribute(REQUEST_FORWARDED_ATTRIBUTE_NAME) != null;
    }

    protected static void setForwarded(ServletRequest req, boolean requestForwarded) {
        req.setAttribute(REQUEST_FORWARDED_ATTRIBUTE_NAME, (Object)(requestForwarded ? Boolean.TRUE : null));
    }

    public static HttpServletRequest getParameterAlteredRequest(HttpServletRequest request, HttpParametersMap params, Map<String, String[]> oldMap, WildcardPatternMatcher clearParamsMatcher) {
        String name;
        Map newMap = params == null ? Collections.emptyMap() : params.getParameterMap();
        if (oldMap == null) {
            oldMap = request.getParameterMap();
        }
        LinkedHashMap<String, Object> newParameters = new LinkedHashMap<String, Object>((newMap.size() + oldMap.size()) * 4 / 3 + 1);
        for (Map.Entry entry : newMap.entrySet()) {
            String[] merged;
            String[] oldValues;
            name = (String)entry.getKey();
            List newValues = (List)entry.getValue();
            String[] stringArray = oldValues = clearParamsMatcher.isMatch(name) ? null : (String[])oldMap.get(name);
            if (oldValues == null) {
                merged = newValues.toArray(new String[newValues.size()]);
            } else {
                merged = new String[newValues.size() + oldValues.length];
                String[] result = newValues.toArray(merged);
                assert (merged == result);
                System.arraycopy(oldValues, 0, merged, newValues.size(), oldValues.length);
            }
            newParameters.put(name, merged);
        }
        for (Map.Entry entry : oldMap.entrySet()) {
            name = (String)entry.getKey();
            if (newMap.containsKey(name) || clearParamsMatcher.isMatch(name)) continue;
            newParameters.put(name, entry.getValue());
        }
        final Map parameters = Collections.unmodifiableMap(newParameters);
        return new HttpServletRequestWrapper(request){

            public String getParameter(String name) {
                String[] values = (String[])parameters.get(name);
                return values == null || values.length == 0 ? null : values[0];
            }

            public Map<String, String[]> getParameterMap() {
                return parameters;
            }

            public Enumeration<String> getParameterNames() {
                return Collections.enumeration(parameters.keySet());
            }

            public String[] getParameterValues(String name) {
                return (String[])parameters.get(name);
            }
        };
    }

    @Override
    public void setPage(String page) {
        this.page = page;
    }

    protected abstract WildcardPatternMatcher getClearParamsMatcher();

    @Override
    public void addParam(String name, String value) {
        if (this.params == null) {
            this.params = new HttpParametersMap();
        }
        this.params.addParameter(name, value);
    }

    protected abstract String getDynamicAttributeExceptionKey();

    protected abstract Serializable[] getDynamicAttributeExceptionArgs(String var1);

    public void setDynamicAttribute(String uri, String localName, Object value) throws JspTagException {
        if (uri != null || !localName.startsWith("param.")) {
            throw new LocalizedJspTagException(ApplicationResources.accessor, this.getDynamicAttributeExceptionKey(), this.getDynamicAttributeExceptionArgs(localName));
        }
        ParamUtils.setDynamicAttribute(this, uri, localName, value);
    }

    protected abstract Map<String, ?> getArgs();

    protected void doTag(String servletPath) throws IOException, JspTagException, SkipPageException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void doTag() throws JspException, IOException {
        PageContext pageContext = (PageContext)this.getJspContext();
        HttpServletRequest request = (HttpServletRequest)pageContext.getRequest();
        String oldOriginal = Dispatcher.getOriginalPage((ServletRequest)request);
        try {
            JspFragment body;
            if (oldOriginal == null) {
                Dispatcher.setOriginalPage((ServletRequest)request, (String)request.getServletPath());
            }
            if ((body = this.getJspBody()) != null) {
                body.invoke((Writer)NullWriter.getInstance());
            }
            String oldDispatchPage = Dispatcher.getDispatchedPage((ServletRequest)request);
            try {
                RequestDispatcher dispatcher;
                String contextRelativePath;
                String servletPath;
                String string = servletPath = oldDispatchPage == null ? request.getServletPath() : oldDispatchPage;
                if (this.page == null) {
                    contextRelativePath = null;
                    dispatcher = null;
                } else {
                    contextRelativePath = ServletUtil.getAbsolutePath((String)servletPath, (String)this.page);
                    dispatcher = pageContext.getServletContext().getRequestDispatcher(contextRelativePath);
                    if (dispatcher == null) {
                        throw new LocalizedJspTagException(ApplicationResources.accessor, "DispatchTag.dispatcherNotFound", new Serializable[]{contextRelativePath});
                    }
                }
                this.doTag(servletPath);
                if (this.page == null) {
                    throw new AttributeRequiredException("page");
                }
                assert (contextRelativePath != null) : "Will have been set above when page non-null";
                assert (dispatcher != null) : "Will have been set above when page non-null";
                Dispatcher.setDispatchedPage((ServletRequest)request, (String)contextRelativePath);
                Object oldArgs = request.getAttribute("arg");
                try {
                    JspWriter out = pageContext.getOut();
                    HttpServletResponse response = (HttpServletResponse)pageContext.getResponse();
                    request.setAttribute("arg", this.getArgs());
                    WildcardPatternMatcher clearParamsMatcher = this.getClearParamsMatcher();
                    Map oldMap = null;
                    if (this.params == null) {
                        if (clearParamsMatcher.isEmpty()) {
                            this.dispatch(dispatcher, out, request, response);
                            return;
                        }
                        if (oldMap == null) {
                            oldMap = request.getParameterMap();
                        }
                        if (oldMap.isEmpty()) {
                            this.dispatch(dispatcher, out, request, response);
                            return;
                        }
                    }
                    this.dispatch(dispatcher, out, DispatchTag.getParameterAlteredRequest(request, this.params, oldMap, clearParamsMatcher), response);
                    return;
                }
                finally {
                    request.setAttribute("arg", oldArgs);
                }
            }
            finally {
                Dispatcher.setDispatchedPage((ServletRequest)request, (String)oldDispatchPage);
            }
        }
        finally {
            if (oldOriginal == null) {
                Dispatcher.setOriginalPage((ServletRequest)request, null);
            }
        }
    }

    abstract void dispatch(RequestDispatcher var1, JspWriter var2, HttpServletRequest var3, HttpServletResponse var4) throws JspException, IOException;
}

