/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.taglib;

import com.aoindustries.encoding.EncodingContext;
import com.aoindustries.encoding.MediaEncoder;
import com.aoindustries.encoding.MediaException;
import com.aoindustries.encoding.MediaType;
import com.aoindustries.encoding.MediaValidator;
import com.aoindustries.encoding.MediaWriter;
import com.aoindustries.encoding.ValidMediaInput;
import com.aoindustries.encoding.servlet.HttpServletResponseEncodingContext;
import com.aoindustries.taglib.ThreadEncodingContext;
import java.io.IOException;
import java.io.Writer;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.JspFragment;
import javax.servlet.jsp.tagext.SimpleTagSupport;

public abstract class AutoEncodingFilteredTag
extends SimpleTagSupport {
    public abstract MediaType getContentType();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doTag() throws JspException, IOException {
        block19: {
            try {
                MediaType containerContentType;
                PageContext pageContext = (PageContext)this.getJspContext();
                ServletRequest request = pageContext.getRequest();
                HttpServletResponse response = (HttpServletResponse)pageContext.getResponse();
                JspWriter out = pageContext.getOut();
                ThreadEncodingContext parentEncodingContext = ThreadEncodingContext.getCurrentContext(request);
                if (parentEncodingContext != null) {
                    containerContentType = parentEncodingContext.contentType;
                } else {
                    String responseContentType = response.getContentType();
                    if (responseContentType == null) {
                        responseContentType = MediaType.XHTML.getContentType();
                    }
                    containerContentType = MediaType.getMediaTypeForContentType((String)responseContentType);
                }
                MediaType myContentType = this.getContentType();
                MediaEncoder mediaEncoder = MediaEncoder.getInstance((EncodingContext)new HttpServletResponseEncodingContext(response), (MediaType)myContentType, (MediaType)containerContentType);
                if (mediaEncoder != null) {
                    this.setMediaEncoderOptions(mediaEncoder);
                    MediaWriter mediaWriter = new MediaWriter(mediaEncoder, (Writer)out);
                    mediaWriter.writePrefix();
                    try {
                        ThreadEncodingContext.setCurrentContext(request, new ThreadEncodingContext(myContentType, (ValidMediaInput)mediaWriter));
                        try {
                            this.doTag((Writer)mediaWriter);
                            break block19;
                        }
                        finally {
                            ThreadEncodingContext.setCurrentContext(request, parentEncodingContext);
                        }
                    }
                    finally {
                        mediaWriter.writeSuffix();
                    }
                }
                if (parentEncodingContext != null && parentEncodingContext.validMediaInput.isValidatingMediaInputType(myContentType)) {
                    ThreadEncodingContext.setCurrentContext(request, new ThreadEncodingContext(myContentType, parentEncodingContext.validMediaInput));
                    try {
                        this.doTag((Writer)out);
                        break block19;
                    }
                    finally {
                        ThreadEncodingContext.setCurrentContext(request, parentEncodingContext);
                    }
                }
                MediaValidator validator = MediaValidator.getMediaValidator((MediaType)myContentType, (Writer)out);
                ThreadEncodingContext.setCurrentContext(request, new ThreadEncodingContext(myContentType, (ValidMediaInput)validator));
                try {
                    this.doTag((Writer)validator);
                }
                finally {
                    ThreadEncodingContext.setCurrentContext(request, parentEncodingContext);
                }
            }
            catch (MediaException err) {
                throw new JspTagException((Throwable)err);
            }
        }
    }

    protected void setMediaEncoderOptions(MediaEncoder mediaEncoder) {
    }

    protected void doTag(Writer out) throws JspException, IOException {
        JspFragment body = this.getJspBody();
        if (body != null) {
            body.invoke(out instanceof JspWriter ? null : out);
        }
    }
}

