/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.taglib;

import com.aoindustries.encoding.EncodingContext;
import com.aoindustries.encoding.MediaEncoder;
import com.aoindustries.encoding.MediaException;
import com.aoindustries.encoding.MediaType;
import com.aoindustries.encoding.MediaValidator;
import com.aoindustries.encoding.MediaWriter;
import com.aoindustries.encoding.ValidMediaInput;
import com.aoindustries.encoding.servlet.HttpServletResponseEncodingContext;
import com.aoindustries.io.TempFileList;
import com.aoindustries.io.buffer.AutoTempFileWriter;
import com.aoindustries.io.buffer.BufferResult;
import com.aoindustries.io.buffer.BufferWriter;
import com.aoindustries.io.buffer.CharArrayBufferWriter;
import com.aoindustries.servlet.filter.TempFileContext;
import com.aoindustries.taglib.FailOnWriteWriter;
import com.aoindustries.taglib.ThreadEncodingContext;
import java.io.IOException;
import java.io.Writer;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.JspFragment;
import javax.servlet.jsp.tagext.SimpleTagSupport;

public abstract class AutoEncodingBufferedTag
extends SimpleTagSupport {
    private static final boolean ENABLE_BUFFER_LOGGING = false;
    private static final Writer log = null;

    public static BufferWriter newBufferWriter() {
        return new CharArrayBufferWriter();
    }

    public abstract MediaType getContentType();

    public abstract MediaType getOutputType();

    public int getInitialBufferSize() {
        return 32;
    }

    public long getTempFileThreshold() {
        return 0x400000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doTag() throws JspException, IOException {
        block28: {
            try {
                MediaType containerContentType;
                BufferWriter bufferWriter;
                ThreadEncodingContext parentEncodingContext;
                ServletRequest request;
                PageContext pageContext;
                block27: {
                    pageContext = (PageContext)this.getJspContext();
                    request = pageContext.getRequest();
                    parentEncodingContext = ThreadEncodingContext.getCurrentContext(request);
                    bufferWriter = AutoEncodingBufferedTag.newBufferWriter();
                    try {
                        JspFragment body;
                        final long tempFileThreshold = this.getTempFileThreshold();
                        if (tempFileThreshold != Long.MAX_VALUE) {
                            bufferWriter = (BufferWriter)TempFileContext.wrapTempFileList((Object)bufferWriter, (ServletRequest)request, (TempFileContext.Wrapper)new TempFileContext.Wrapper<BufferWriter>(){

                                public BufferWriter call(BufferWriter original, TempFileList tempFileList) {
                                    return new AutoTempFileWriter(original, tempFileList, tempFileThreshold);
                                }
                            });
                        }
                        if ((body = this.getJspBody()) == null) break block27;
                        MediaType myContentType = this.getContentType();
                        MediaValidator captureValidator = MediaValidator.getMediaValidator((MediaType)myContentType, (Writer)bufferWriter);
                        ThreadEncodingContext.setCurrentContext(request, new ThreadEncodingContext(myContentType, (ValidMediaInput)captureValidator));
                        try {
                            this.invoke(body, captureValidator);
                            captureValidator.flush();
                        }
                        finally {
                            ThreadEncodingContext.setCurrentContext(request, parentEncodingContext);
                        }
                    }
                    finally {
                        bufferWriter.close();
                    }
                }
                BufferResult capturedBody = bufferWriter.getResult();
                bufferWriter = null;
                MediaType myOutputType = this.getOutputType();
                if (myOutputType == null) {
                    this.doTag(capturedBody, FailOnWriteWriter.getInstance());
                    break block28;
                }
                HttpServletResponse response = (HttpServletResponse)pageContext.getResponse();
                JspWriter out = pageContext.getOut();
                if (parentEncodingContext != null) {
                    containerContentType = parentEncodingContext.contentType;
                } else {
                    String responseContentType = response.getContentType();
                    if (responseContentType == null) {
                        responseContentType = MediaType.XHTML.getContentType();
                    }
                    containerContentType = MediaType.getMediaTypeForContentType((String)responseContentType);
                }
                MediaEncoder mediaEncoder = MediaEncoder.getInstance((EncodingContext)new HttpServletResponseEncodingContext(response), (MediaType)myOutputType, (MediaType)containerContentType);
                if (mediaEncoder != null) {
                    this.setMediaEncoderOptions(mediaEncoder);
                    MediaWriter mediaWriter = new MediaWriter(mediaEncoder, (Writer)out);
                    mediaWriter.writePrefix();
                    try {
                        ThreadEncodingContext.setCurrentContext(request, new ThreadEncodingContext(myOutputType, (ValidMediaInput)mediaWriter));
                        try {
                            this.doTag(capturedBody, (Writer)mediaWriter);
                            break block28;
                        }
                        finally {
                            ThreadEncodingContext.setCurrentContext(request, parentEncodingContext);
                        }
                    }
                    finally {
                        mediaWriter.writeSuffix();
                    }
                }
                if (parentEncodingContext != null && parentEncodingContext.validMediaInput.isValidatingMediaInputType(myOutputType)) {
                    ThreadEncodingContext.setCurrentContext(request, new ThreadEncodingContext(myOutputType, parentEncodingContext.validMediaInput));
                    try {
                        this.doTag(capturedBody, (Writer)out);
                        break block28;
                    }
                    finally {
                        ThreadEncodingContext.setCurrentContext(request, parentEncodingContext);
                    }
                }
                MediaValidator validator = MediaValidator.getMediaValidator((MediaType)myOutputType, (Writer)out);
                ThreadEncodingContext.setCurrentContext(request, new ThreadEncodingContext(myOutputType, (ValidMediaInput)validator));
                try {
                    this.doTag(capturedBody, (Writer)validator);
                }
                finally {
                    ThreadEncodingContext.setCurrentContext(request, parentEncodingContext);
                }
            }
            catch (MediaException err) {
                throw new JspTagException((Throwable)err);
            }
        }
    }

    protected void setMediaEncoderOptions(MediaEncoder mediaEncoder) {
    }

    protected void invoke(JspFragment body, MediaValidator captureValidator) throws JspException, IOException {
        body.invoke((Writer)captureValidator);
    }

    protected abstract void doTag(BufferResult var1, Writer var2) throws JspException, IOException;
}

