/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.taglib;

import com.aoindustries.lang.LocalizedIllegalArgumentException;
import com.aoindustries.taglib.ApplicationResources;
import com.aoindustries.taglib.ArgsAttribute;
import com.aoindustries.taglib.DispatchTag;
import com.aoindustries.util.WildcardPatternMatcher;
import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.jsp.JspTagException;

abstract class ArgDispatchTag
extends DispatchTag
implements ArgsAttribute {
    private static final String ARG_ATTRIBUTE_PREFIX = "arg.";
    private WildcardPatternMatcher clearParamsMatcher = WildcardPatternMatcher.matchNone();
    private Map<String, Object> args;

    ArgDispatchTag() {
    }

    public void setClearParams(String clearParams) {
        this.clearParamsMatcher = WildcardPatternMatcher.compile((String)clearParams);
    }

    @Override
    protected WildcardPatternMatcher getClearParamsMatcher() {
        return this.clearParamsMatcher;
    }

    @Override
    protected Map<String, ?> getArgs() {
        if (this.args == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.args);
    }

    @Override
    public void addArg(String name, Object value) throws IllegalArgumentException {
        if (this.args == null) {
            this.args = new LinkedHashMap<String, Object>();
        } else if (this.args.containsKey(name)) {
            throw new LocalizedIllegalArgumentException(ApplicationResources.accessor, "DispatchTag.addArg.duplicateArgument", new Serializable[]{name});
        }
        this.args.put(name, value);
    }

    @Override
    protected String getDynamicAttributeExceptionKey() {
        return "error.unexpectedDynamicAttribute2";
    }

    @Override
    protected Serializable[] getDynamicAttributeExceptionArgs(String localName) {
        return new Serializable[]{localName, "arg.*", "param.*"};
    }

    @Override
    public void setDynamicAttribute(String uri, String localName, Object value) throws JspTagException {
        if (uri == null && localName.startsWith(ARG_ATTRIBUTE_PREFIX)) {
            this.addArg(localName.substring(ARG_ATTRIBUTE_PREFIX.length()), value);
        } else {
            super.setDynamicAttribute(uri, localName, value);
        }
    }
}

