/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.res2;

import com.android.annotations.NonNull;
import com.android.ide.common.res2.DataFile;
import com.android.ide.common.res2.NodeUtils;
import com.android.ide.common.res2.ResourceItem;
import java.io.File;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

class ResourceFile
extends DataFile<ResourceItem> {
    static final String ATTR_QUALIFIER = "qualifiers";
    private final String mQualifiers;

    ResourceFile(@NonNull File file, @NonNull ResourceItem item, @NonNull String qualifiers) {
        super(file, DataFile.FileType.SINGLE);
        this.mQualifiers = qualifiers;
        this.init(item);
    }

    ResourceFile(@NonNull File file, @NonNull List<ResourceItem> items, @NonNull String qualifiers) {
        super(file, DataFile.FileType.MULTI);
        this.mQualifiers = qualifiers;
        this.init(items);
    }

    @NonNull
    String getQualifiers() {
        return this.mQualifiers;
    }

    @Override
    void addExtraAttributes(Document document, Node node, String namespaceUri) {
        NodeUtils.addAttribute(document, node, namespaceUri, ATTR_QUALIFIER, this.getQualifiers());
    }

    @Override
    public String toString() {
        return "ResourceFile{mFile='" + this.getFile() + '\'' + ", mQualifiers='" + this.mQualifiers + '\'' + '}';
    }
}

