/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.rendering.api;

import java.util.Collections;
import java.util.List;

public class ViewInfo {
    private final Object mCookie;
    private final String mName;
    private final int mLeft;
    private final int mRight;
    private final int mTop;
    private final int mBottom;
    private List<ViewInfo> mChildren = Collections.emptyList();
    private final Object mViewObject;
    private final Object mLayoutParamsObject;
    private int mBaseLine = Integer.MIN_VALUE;
    private int mLeftMargin = Integer.MIN_VALUE;
    private int mTopMargin = Integer.MIN_VALUE;
    private int mRightMargin = Integer.MIN_VALUE;
    private int mBottomMargin = Integer.MIN_VALUE;

    public ViewInfo(String name, Object cookie, int left, int top, int right, int bottom) {
        this(name, cookie, left, top, right, bottom, null, null);
    }

    public ViewInfo(String name, Object cookie, int left, int top, int right, int bottom, Object viewObject, Object layoutParamsObject) {
        this.mName = name;
        this.mCookie = cookie;
        this.mLeft = left;
        this.mRight = right;
        this.mTop = top;
        this.mBottom = bottom;
        this.mViewObject = viewObject;
        this.mLayoutParamsObject = layoutParamsObject;
    }

    public void setChildren(List<ViewInfo> children) {
        this.mChildren = children != null ? Collections.unmodifiableList(children) : Collections.emptyList();
    }

    public void setExtendedInfo(int baseLine, int leftMargin, int topMargin, int rightMargin, int bottomMargin) {
        this.mBaseLine = baseLine;
        this.mLeftMargin = leftMargin;
        this.mTopMargin = topMargin;
        this.mRightMargin = rightMargin;
        this.mBottomMargin = bottomMargin;
    }

    public List<ViewInfo> getChildren() {
        return this.mChildren;
    }

    public Object getCookie() {
        return this.mCookie;
    }

    public String getClassName() {
        return this.mName;
    }

    public int getLeft() {
        return this.mLeft;
    }

    public int getTop() {
        return this.mTop;
    }

    public int getRight() {
        return this.mRight;
    }

    public int getBottom() {
        return this.mBottom;
    }

    public Object getViewObject() {
        return this.mViewObject;
    }

    public Object getLayoutParamsObject() {
        return this.mLayoutParamsObject;
    }

    public int getBaseLine() {
        return this.mBaseLine;
    }

    public int getLeftMargin() {
        return this.mLeftMargin;
    }

    public int getTopMargin() {
        return this.mTopMargin;
    }

    public int getRightMargin() {
        return this.mRightMargin;
    }

    public int getBottomMargin() {
        return this.mBottomMargin;
    }
}

