/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.identitymanagement.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.identitymanagement.model.StatusType;
import java.io.Serializable;

public class UpdateAccessKeyRequest
extends AmazonWebServiceRequest
implements Serializable {
    private String userName;
    private String accessKeyId;
    private String status;

    public UpdateAccessKeyRequest() {
    }

    public UpdateAccessKeyRequest(String accessKeyId, String status) {
        this.setAccessKeyId(accessKeyId);
        this.setStatus(status);
    }

    public UpdateAccessKeyRequest(String accessKeyId, StatusType status) {
        this.accessKeyId = accessKeyId;
        this.status = status.toString();
    }

    public UpdateAccessKeyRequest(String userName, String accessKeyId, String status) {
        this.setUserName(userName);
        this.setAccessKeyId(accessKeyId);
        this.setStatus(status);
    }

    public UpdateAccessKeyRequest(String userName, String accessKeyId, StatusType status) {
        this.userName = userName;
        this.accessKeyId = accessKeyId;
        this.status = status.toString();
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public UpdateAccessKeyRequest withUserName(String userName) {
        this.userName = userName;
        return this;
    }

    public String getAccessKeyId() {
        return this.accessKeyId;
    }

    public void setAccessKeyId(String accessKeyId) {
        this.accessKeyId = accessKeyId;
    }

    public UpdateAccessKeyRequest withAccessKeyId(String accessKeyId) {
        this.accessKeyId = accessKeyId;
        return this;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public UpdateAccessKeyRequest withStatus(String status) {
        this.status = status;
        return this;
    }

    public void setStatus(StatusType status) {
        this.status = status.toString();
    }

    public UpdateAccessKeyRequest withStatus(StatusType status) {
        this.status = status.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getUserName() != null) {
            sb.append("UserName: " + this.getUserName() + ",");
        }
        if (this.getAccessKeyId() != null) {
            sb.append("AccessKeyId: " + this.getAccessKeyId() + ",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: " + this.getStatus());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getUserName() == null ? 0 : this.getUserName().hashCode());
        hashCode = 31 * hashCode + (this.getAccessKeyId() == null ? 0 : this.getAccessKeyId().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAccessKeyRequest)) {
            return false;
        }
        UpdateAccessKeyRequest other = (UpdateAccessKeyRequest)obj;
        if (other.getUserName() == null ^ this.getUserName() == null) {
            return false;
        }
        if (other.getUserName() != null && !other.getUserName().equals(this.getUserName())) {
            return false;
        }
        if (other.getAccessKeyId() == null ^ this.getAccessKeyId() == null) {
            return false;
        }
        if (other.getAccessKeyId() != null && !other.getAccessKeyId().equals(this.getAccessKeyId())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        return other.getStatus() == null || other.getStatus().equals(this.getStatus());
    }
}

