/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticache.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.elasticache.model.AutomaticFailoverStatus;
import com.amazonaws.services.elasticache.model.NodeGroup;
import com.amazonaws.services.elasticache.model.ReplicationGroupPendingModifiedValues;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ReplicationGroup
implements Serializable {
    private String replicationGroupId;
    private String description;
    private String status;
    private ReplicationGroupPendingModifiedValues pendingModifiedValues;
    private ListWithAutoConstructFlag<String> memberClusters;
    private ListWithAutoConstructFlag<NodeGroup> nodeGroups;
    private String snapshottingClusterId;
    private String automaticFailover;

    public String getReplicationGroupId() {
        return this.replicationGroupId;
    }

    public void setReplicationGroupId(String replicationGroupId) {
        this.replicationGroupId = replicationGroupId;
    }

    public ReplicationGroup withReplicationGroupId(String replicationGroupId) {
        this.replicationGroupId = replicationGroupId;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ReplicationGroup withDescription(String description) {
        this.description = description;
        return this;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public ReplicationGroup withStatus(String status) {
        this.status = status;
        return this;
    }

    public ReplicationGroupPendingModifiedValues getPendingModifiedValues() {
        return this.pendingModifiedValues;
    }

    public void setPendingModifiedValues(ReplicationGroupPendingModifiedValues pendingModifiedValues) {
        this.pendingModifiedValues = pendingModifiedValues;
    }

    public ReplicationGroup withPendingModifiedValues(ReplicationGroupPendingModifiedValues pendingModifiedValues) {
        this.pendingModifiedValues = pendingModifiedValues;
        return this;
    }

    public List<String> getMemberClusters() {
        if (this.memberClusters == null) {
            this.memberClusters = new ListWithAutoConstructFlag();
            this.memberClusters.setAutoConstruct(true);
        }
        return this.memberClusters;
    }

    public void setMemberClusters(Collection<String> memberClusters) {
        if (memberClusters == null) {
            this.memberClusters = null;
            return;
        }
        ListWithAutoConstructFlag memberClustersCopy = new ListWithAutoConstructFlag(memberClusters.size());
        memberClustersCopy.addAll(memberClusters);
        this.memberClusters = memberClustersCopy;
    }

    public ReplicationGroup withMemberClusters(String ... memberClusters) {
        if (this.getMemberClusters() == null) {
            this.setMemberClusters(new ArrayList<String>(memberClusters.length));
        }
        for (String value : memberClusters) {
            this.getMemberClusters().add(value);
        }
        return this;
    }

    public ReplicationGroup withMemberClusters(Collection<String> memberClusters) {
        if (memberClusters == null) {
            this.memberClusters = null;
        } else {
            ListWithAutoConstructFlag memberClustersCopy = new ListWithAutoConstructFlag(memberClusters.size());
            memberClustersCopy.addAll(memberClusters);
            this.memberClusters = memberClustersCopy;
        }
        return this;
    }

    public List<NodeGroup> getNodeGroups() {
        if (this.nodeGroups == null) {
            this.nodeGroups = new ListWithAutoConstructFlag();
            this.nodeGroups.setAutoConstruct(true);
        }
        return this.nodeGroups;
    }

    public void setNodeGroups(Collection<NodeGroup> nodeGroups) {
        if (nodeGroups == null) {
            this.nodeGroups = null;
            return;
        }
        ListWithAutoConstructFlag nodeGroupsCopy = new ListWithAutoConstructFlag(nodeGroups.size());
        nodeGroupsCopy.addAll(nodeGroups);
        this.nodeGroups = nodeGroupsCopy;
    }

    public ReplicationGroup withNodeGroups(NodeGroup ... nodeGroups) {
        if (this.getNodeGroups() == null) {
            this.setNodeGroups(new ArrayList<NodeGroup>(nodeGroups.length));
        }
        for (NodeGroup value : nodeGroups) {
            this.getNodeGroups().add(value);
        }
        return this;
    }

    public ReplicationGroup withNodeGroups(Collection<NodeGroup> nodeGroups) {
        if (nodeGroups == null) {
            this.nodeGroups = null;
        } else {
            ListWithAutoConstructFlag nodeGroupsCopy = new ListWithAutoConstructFlag(nodeGroups.size());
            nodeGroupsCopy.addAll(nodeGroups);
            this.nodeGroups = nodeGroupsCopy;
        }
        return this;
    }

    public String getSnapshottingClusterId() {
        return this.snapshottingClusterId;
    }

    public void setSnapshottingClusterId(String snapshottingClusterId) {
        this.snapshottingClusterId = snapshottingClusterId;
    }

    public ReplicationGroup withSnapshottingClusterId(String snapshottingClusterId) {
        this.snapshottingClusterId = snapshottingClusterId;
        return this;
    }

    public String getAutomaticFailover() {
        return this.automaticFailover;
    }

    public void setAutomaticFailover(String automaticFailover) {
        this.automaticFailover = automaticFailover;
    }

    public ReplicationGroup withAutomaticFailover(String automaticFailover) {
        this.automaticFailover = automaticFailover;
        return this;
    }

    public void setAutomaticFailover(AutomaticFailoverStatus automaticFailover) {
        this.automaticFailover = automaticFailover.toString();
    }

    public ReplicationGroup withAutomaticFailover(AutomaticFailoverStatus automaticFailover) {
        this.automaticFailover = automaticFailover.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getReplicationGroupId() != null) {
            sb.append("ReplicationGroupId: " + this.getReplicationGroupId() + ",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: " + this.getDescription() + ",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: " + this.getStatus() + ",");
        }
        if (this.getPendingModifiedValues() != null) {
            sb.append("PendingModifiedValues: " + this.getPendingModifiedValues() + ",");
        }
        if (this.getMemberClusters() != null) {
            sb.append("MemberClusters: " + this.getMemberClusters() + ",");
        }
        if (this.getNodeGroups() != null) {
            sb.append("NodeGroups: " + this.getNodeGroups() + ",");
        }
        if (this.getSnapshottingClusterId() != null) {
            sb.append("SnapshottingClusterId: " + this.getSnapshottingClusterId() + ",");
        }
        if (this.getAutomaticFailover() != null) {
            sb.append("AutomaticFailover: " + this.getAutomaticFailover());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getReplicationGroupId() == null ? 0 : this.getReplicationGroupId().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getPendingModifiedValues() == null ? 0 : this.getPendingModifiedValues().hashCode());
        hashCode = 31 * hashCode + (this.getMemberClusters() == null ? 0 : this.getMemberClusters().hashCode());
        hashCode = 31 * hashCode + (this.getNodeGroups() == null ? 0 : this.getNodeGroups().hashCode());
        hashCode = 31 * hashCode + (this.getSnapshottingClusterId() == null ? 0 : this.getSnapshottingClusterId().hashCode());
        hashCode = 31 * hashCode + (this.getAutomaticFailover() == null ? 0 : this.getAutomaticFailover().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplicationGroup)) {
            return false;
        }
        ReplicationGroup other = (ReplicationGroup)obj;
        if (other.getReplicationGroupId() == null ^ this.getReplicationGroupId() == null) {
            return false;
        }
        if (other.getReplicationGroupId() != null && !other.getReplicationGroupId().equals(this.getReplicationGroupId())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getPendingModifiedValues() == null ^ this.getPendingModifiedValues() == null) {
            return false;
        }
        if (other.getPendingModifiedValues() != null && !other.getPendingModifiedValues().equals(this.getPendingModifiedValues())) {
            return false;
        }
        if (other.getMemberClusters() == null ^ this.getMemberClusters() == null) {
            return false;
        }
        if (other.getMemberClusters() != null && !other.getMemberClusters().equals(this.getMemberClusters())) {
            return false;
        }
        if (other.getNodeGroups() == null ^ this.getNodeGroups() == null) {
            return false;
        }
        if (other.getNodeGroups() != null && !other.getNodeGroups().equals(this.getNodeGroups())) {
            return false;
        }
        if (other.getSnapshottingClusterId() == null ^ this.getSnapshottingClusterId() == null) {
            return false;
        }
        if (other.getSnapshottingClusterId() != null && !other.getSnapshottingClusterId().equals(this.getSnapshottingClusterId())) {
            return false;
        }
        if (other.getAutomaticFailover() == null ^ this.getAutomaticFailover() == null) {
            return false;
        }
        return other.getAutomaticFailover() == null || other.getAutomaticFailover().equals(this.getAutomaticFailover());
    }
}

