/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.integrationtests;

import com.aliyun.oss.OSSException;
import com.aliyun.oss.integrationtests.TestBase;
import com.aliyun.oss.integrationtests.TestUtils;
import com.aliyun.oss.model.AbortMultipartUploadRequest;
import com.aliyun.oss.model.Bucket;
import com.aliyun.oss.model.CompleteMultipartUploadRequest;
import com.aliyun.oss.model.CompleteMultipartUploadResult;
import com.aliyun.oss.model.ListMultipartUploadsRequest;
import com.aliyun.oss.model.ListPartsRequest;
import com.aliyun.oss.model.MultipartUpload;
import com.aliyun.oss.model.MultipartUploadListing;
import com.aliyun.oss.model.OSSObject;
import com.aliyun.oss.model.PartETag;
import com.aliyun.oss.model.PartListing;
import com.aliyun.oss.model.PartSummary;
import com.aliyun.oss.model.UploadPartRequest;
import com.aliyun.oss.model.UploadPartResult;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Assert;
import org.junit.Test;

public class UploadPartTest
extends TestBase {
    private static final int LIST_PART_MAX_RETURNS = 1000;
    private static final int LIST_UPLOAD_MAX_RETURNS = 1000;

    @Test
    public void testNormalUploadSinglePart() {
        String key = "normal-upload-single-part-object";
        int partSize = 131072;
        try {
            String uploadId = TestUtils.claimUploadId(secondClient, bucketName, "normal-upload-single-part-object");
            InputStream instream = TestUtils.genFixedLengthInputStream(131072L);
            UploadPartRequest uploadPartRequest = new UploadPartRequest();
            uploadPartRequest.setBucketName(bucketName);
            uploadPartRequest.setKey("normal-upload-single-part-object");
            uploadPartRequest.setInputStream(instream);
            uploadPartRequest.setPartNumber(2);
            uploadPartRequest.setPartSize(131072L);
            uploadPartRequest.setUploadId(uploadId);
            secondClient.uploadPart(uploadPartRequest);
            ListMultipartUploadsRequest listMultipartUploadsRequest = new ListMultipartUploadsRequest(bucketName);
            MultipartUploadListing multipartUploadListing = secondClient.listMultipartUploads(listMultipartUploadsRequest);
            Assert.assertEquals((String)bucketName, (String)multipartUploadListing.getBucketName());
            Assert.assertEquals((int)1000, (int)multipartUploadListing.getMaxUploads());
            Assert.assertFalse((boolean)multipartUploadListing.isTruncated());
            Assert.assertEquals((String)"normal-upload-single-part-object", (String)multipartUploadListing.getNextKeyMarker());
            Assert.assertEquals((String)uploadId, (String)multipartUploadListing.getNextUploadIdMarker());
            Assert.assertNull((Object)multipartUploadListing.getDelimiter());
            Assert.assertNull((Object)multipartUploadListing.getPrefix());
            Assert.assertNull((Object)multipartUploadListing.getKeyMarker());
            Assert.assertNull((Object)multipartUploadListing.getUploadIdMarker());
            List<MultipartUpload> multipartUploads = multipartUploadListing.getMultipartUploads();
            Assert.assertEquals((int)1, (int)multipartUploads.size());
            Assert.assertEquals((String)"normal-upload-single-part-object", (String)multipartUploads.get(0).getKey());
            Assert.assertEquals((String)uploadId, (String)multipartUploads.get(0).getUploadId());
            AbortMultipartUploadRequest abortMultipartUploadRequest = new AbortMultipartUploadRequest(bucketName, "normal-upload-single-part-object", uploadId);
            secondClient.abortMultipartUpload(abortMultipartUploadRequest);
            listMultipartUploadsRequest = new ListMultipartUploadsRequest(bucketName);
            multipartUploadListing = secondClient.listMultipartUploads(listMultipartUploadsRequest);
            Assert.assertEquals((int)0, (int)multipartUploadListing.getMultipartUploads().size());
            Assert.assertEquals((String)bucketName, (String)multipartUploadListing.getBucketName());
            Assert.assertEquals((int)1000, (int)multipartUploadListing.getMaxUploads());
            Assert.assertFalse((boolean)multipartUploadListing.isTruncated());
            Assert.assertNull((Object)multipartUploadListing.getNextKeyMarker());
            Assert.assertNull((Object)multipartUploadListing.getNextUploadIdMarker());
            Assert.assertNull((Object)multipartUploadListing.getDelimiter());
            Assert.assertNull((Object)multipartUploadListing.getPrefix());
            Assert.assertNull((Object)multipartUploadListing.getKeyMarker());
            Assert.assertNull((Object)multipartUploadListing.getUploadIdMarker());
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testNormalUploadMultiparts() {
        String key = "normal-upload-multiparts-object";
        int partSize = 131072;
        int partCount = 10;
        try {
            String uploadId = TestUtils.claimUploadId(secondClient, bucketName, "normal-upload-multiparts-object");
            ArrayList<PartETag> partETags = new ArrayList<PartETag>();
            int i = 0;
            while (i < 10) {
                InputStream instream = TestUtils.genFixedLengthInputStream(131072L);
                UploadPartRequest uploadPartRequest = new UploadPartRequest();
                uploadPartRequest.setBucketName(bucketName);
                uploadPartRequest.setKey("normal-upload-multiparts-object");
                uploadPartRequest.setInputStream(instream);
                uploadPartRequest.setPartNumber(i + 1);
                uploadPartRequest.setPartSize(131072L);
                uploadPartRequest.setUploadId(uploadId);
                UploadPartResult uploadPartResult = secondClient.uploadPart(uploadPartRequest);
                partETags.add(uploadPartResult.getPartETag());
                ++i;
            }
            ListPartsRequest listPartsRequest = new ListPartsRequest(bucketName, "normal-upload-multiparts-object", uploadId);
            PartListing partListing = secondClient.listParts(listPartsRequest);
            Assert.assertEquals((int)10, (int)partListing.getParts().size());
            int i2 = 0;
            while (i2 < 10) {
                PartSummary ps = partListing.getParts().get(i2);
                PartETag eTag = (PartETag)partETags.get(i2);
                Assert.assertEquals((int)eTag.getPartNumber(), (int)ps.getPartNumber());
                Assert.assertEquals((String)eTag.getETag(), (String)ps.getETag());
                ++i2;
            }
            Assert.assertEquals((String)bucketName, (String)partListing.getBucketName());
            Assert.assertEquals((String)"normal-upload-multiparts-object", (String)partListing.getKey());
            Assert.assertEquals((String)uploadId, (String)partListing.getUploadId());
            Assert.assertEquals((int)1000, (int)partListing.getMaxParts());
            Assert.assertEquals((int)10, (int)partListing.getNextPartNumberMarker());
            Assert.assertFalse((boolean)partListing.isTruncated());
            ListMultipartUploadsRequest listMultipartUploadsRequest = new ListMultipartUploadsRequest(bucketName);
            MultipartUploadListing multipartUploadListing = secondClient.listMultipartUploads(listMultipartUploadsRequest);
            Assert.assertEquals((String)bucketName, (String)multipartUploadListing.getBucketName());
            Assert.assertEquals((int)1000, (int)multipartUploadListing.getMaxUploads());
            Assert.assertFalse((boolean)multipartUploadListing.isTruncated());
            Assert.assertEquals((String)"normal-upload-multiparts-object", (String)multipartUploadListing.getNextKeyMarker());
            Assert.assertEquals((String)uploadId, (String)multipartUploadListing.getNextUploadIdMarker());
            Assert.assertNull((Object)multipartUploadListing.getDelimiter());
            Assert.assertNull((Object)multipartUploadListing.getPrefix());
            Assert.assertNull((Object)multipartUploadListing.getKeyMarker());
            Assert.assertNull((Object)multipartUploadListing.getUploadIdMarker());
            List<MultipartUpload> multipartUploads = multipartUploadListing.getMultipartUploads();
            Assert.assertEquals((int)1, (int)multipartUploads.size());
            Assert.assertEquals((String)"normal-upload-multiparts-object", (String)multipartUploads.get(0).getKey());
            Assert.assertEquals((String)uploadId, (String)multipartUploads.get(0).getUploadId());
            CompleteMultipartUploadRequest completeMultipartUploadRequest = new CompleteMultipartUploadRequest(bucketName, "normal-upload-multiparts-object", uploadId, partETags);
            CompleteMultipartUploadResult completeMultipartUploadResult = secondClient.completeMultipartUpload(completeMultipartUploadRequest);
            Assert.assertEquals((String)TestUtils.composeLocation(secondClient, "http://oss-test.aliyun-inc.com", bucketName, "normal-upload-multiparts-object"), (String)completeMultipartUploadResult.getLocation());
            Assert.assertEquals((String)bucketName, (String)completeMultipartUploadResult.getBucketName());
            Assert.assertEquals((String)"normal-upload-multiparts-object", (String)completeMultipartUploadResult.getKey());
            Assert.assertEquals((String)TestUtils.calcMultipartsETag(partETags), (String)completeMultipartUploadResult.getETag());
            listMultipartUploadsRequest = new ListMultipartUploadsRequest(bucketName);
            multipartUploadListing = secondClient.listMultipartUploads(listMultipartUploadsRequest);
            Assert.assertEquals((int)0, (int)multipartUploadListing.getMultipartUploads().size());
            Assert.assertEquals((String)bucketName, (String)multipartUploadListing.getBucketName());
            Assert.assertEquals((int)1000, (int)multipartUploadListing.getMaxUploads());
            Assert.assertFalse((boolean)multipartUploadListing.isTruncated());
            Assert.assertNull((Object)multipartUploadListing.getNextKeyMarker());
            Assert.assertNull((Object)multipartUploadListing.getNextUploadIdMarker());
            Assert.assertNull((Object)multipartUploadListing.getDelimiter());
            Assert.assertNull((Object)multipartUploadListing.getPrefix());
            Assert.assertNull((Object)multipartUploadListing.getKeyMarker());
            Assert.assertNull((Object)multipartUploadListing.getUploadIdMarker());
            OSSObject o = secondClient.getObject(bucketName, "normal-upload-multiparts-object");
            long objectSize = 0x140000L;
            Assert.assertEquals((long)0x140000L, (long)o.getObjectMetadata().getContentLength());
            Assert.assertEquals((String)TestUtils.calcMultipartsETag(partETags), (String)o.getObjectMetadata().getETag());
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testNormalListParts() {
        String key = "normal-list-parts-object";
        int partSize = 131072;
        int partCount = 25;
        try {
            String uploadId = TestUtils.claimUploadId(secondClient, bucketName, "normal-list-parts-object");
            ListPartsRequest listPartsRequest = new ListPartsRequest(bucketName, "normal-list-parts-object", uploadId);
            PartListing partListing = secondClient.listParts(listPartsRequest);
            Assert.assertEquals((int)0, (int)partListing.getParts().size());
            Assert.assertEquals((String)bucketName, (String)partListing.getBucketName());
            Assert.assertEquals((String)"normal-list-parts-object", (String)partListing.getKey());
            Assert.assertEquals((String)uploadId, (String)partListing.getUploadId());
            Assert.assertEquals((int)1000, (int)partListing.getMaxParts());
            Assert.assertNull((Object)partListing.getNextPartNumberMarker());
            Assert.assertFalse((boolean)partListing.isTruncated());
            ArrayList<PartETag> partETags = new ArrayList<PartETag>();
            int i = 0;
            while (i < 25) {
                InputStream instream = TestUtils.genFixedLengthInputStream(131072L);
                UploadPartRequest uploadPartRequest = new UploadPartRequest();
                uploadPartRequest.setBucketName(bucketName);
                uploadPartRequest.setKey("normal-list-parts-object");
                uploadPartRequest.setInputStream(instream);
                uploadPartRequest.setPartNumber(i + 1);
                uploadPartRequest.setPartSize(131072L);
                uploadPartRequest.setUploadId(uploadId);
                UploadPartResult uploadPartResult = secondClient.uploadPart(uploadPartRequest);
                partETags.add(uploadPartResult.getPartETag());
                ++i;
            }
            listPartsRequest = new ListPartsRequest(bucketName, "normal-list-parts-object", uploadId);
            partListing = secondClient.listParts(listPartsRequest);
            Assert.assertEquals((int)25, (int)partListing.getParts().size());
            i = 0;
            while (i < 25) {
                PartSummary ps = partListing.getParts().get(i);
                PartETag eTag = (PartETag)partETags.get(i);
                Assert.assertEquals((int)eTag.getPartNumber(), (int)ps.getPartNumber());
                Assert.assertEquals((String)eTag.getETag(), (String)ps.getETag());
                ++i;
            }
            Assert.assertEquals((String)bucketName, (String)partListing.getBucketName());
            Assert.assertEquals((String)"normal-list-parts-object", (String)partListing.getKey());
            Assert.assertEquals((String)uploadId, (String)partListing.getUploadId());
            Assert.assertEquals((int)1000, (int)partListing.getMaxParts());
            Assert.assertEquals((int)25, (int)partListing.getNextPartNumberMarker());
            Assert.assertFalse((boolean)partListing.isTruncated());
            int maxParts = 15;
            listPartsRequest = new ListPartsRequest(bucketName, "normal-list-parts-object", uploadId);
            listPartsRequest.setMaxParts(15);
            partListing = secondClient.listParts(listPartsRequest);
            Assert.assertEquals((int)15, (int)partListing.getParts().size());
            int i2 = 0;
            while (i2 < 15) {
                PartSummary ps = partListing.getParts().get(i2);
                PartETag eTag = (PartETag)partETags.get(i2);
                Assert.assertEquals((int)eTag.getPartNumber(), (int)ps.getPartNumber());
                Assert.assertEquals((String)eTag.getETag(), (String)ps.getETag());
                Assert.assertEquals((long)131072L, (long)ps.getSize());
                ++i2;
            }
            Assert.assertEquals((String)bucketName, (String)partListing.getBucketName());
            Assert.assertEquals((String)"normal-list-parts-object", (String)partListing.getKey());
            Assert.assertEquals((String)uploadId, (String)partListing.getUploadId());
            Assert.assertEquals((int)15, (int)partListing.getMaxParts());
            Assert.assertEquals((int)15, (int)partListing.getNextPartNumberMarker());
            Assert.assertTrue((boolean)partListing.isTruncated());
            int partNumberMarker = 20;
            listPartsRequest.setPartNumberMarker(20);
            partListing = secondClient.listParts(listPartsRequest);
            Assert.assertEquals((int)5, (int)partListing.getParts().size());
            int i3 = 0;
            while (i3 < 5) {
                PartSummary ps = partListing.getParts().get(i3);
                PartETag eTag = (PartETag)partETags.get(20 + i3);
                Assert.assertEquals((int)eTag.getPartNumber(), (int)ps.getPartNumber());
                Assert.assertEquals((String)eTag.getETag(), (String)ps.getETag());
                Assert.assertEquals((long)131072L, (long)ps.getSize());
                ++i3;
            }
            Assert.assertEquals((String)bucketName, (String)partListing.getBucketName());
            Assert.assertEquals((String)"normal-list-parts-object", (String)partListing.getKey());
            Assert.assertEquals((String)uploadId, (String)partListing.getUploadId());
            Assert.assertEquals((int)15, (int)partListing.getMaxParts());
            Assert.assertEquals((int)25, (int)partListing.getNextPartNumberMarker());
            Assert.assertFalse((boolean)partListing.isTruncated());
            CompleteMultipartUploadRequest completeMultipartUploadRequest = new CompleteMultipartUploadRequest(bucketName, "normal-list-parts-object", uploadId, partETags);
            CompleteMultipartUploadResult completeMultipartUploadResult = secondClient.completeMultipartUpload(completeMultipartUploadRequest);
            Assert.assertEquals((String)TestUtils.composeLocation(secondClient, "http://oss-test.aliyun-inc.com", bucketName, "normal-list-parts-object"), (String)completeMultipartUploadResult.getLocation());
            Assert.assertEquals((String)bucketName, (String)completeMultipartUploadResult.getBucketName());
            Assert.assertEquals((String)"normal-list-parts-object", (String)completeMultipartUploadResult.getKey());
            Assert.assertEquals((String)TestUtils.calcMultipartsETag(partETags), (String)completeMultipartUploadResult.getETag());
            OSSObject o = secondClient.getObject(bucketName, "normal-list-parts-object");
            long objectSize = 0x320000L;
            Assert.assertEquals((long)0x320000L, (long)o.getObjectMetadata().getContentLength());
            Assert.assertEquals((String)TestUtils.calcMultipartsETag(partETags), (String)o.getObjectMetadata().getETag());
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testUnormalListParts() {
        String key = "unormal-list-parts-object";
        String nonexistentUploadId = "nonexistent-upload-id";
        try {
            ListPartsRequest listPartsRequest = new ListPartsRequest(bucketName, "unormal-list-parts-object", "nonexistent-upload-id");
            secondClient.listParts(listPartsRequest);
            Assert.fail((String)"List parts should not be successful");
        }
        catch (OSSException e) {
            Assert.assertEquals((String)"NoSuchUpload", (String)e.getErrorCode());
            Assert.assertTrue((boolean)e.getMessage().startsWith("The specified upload does not exist. The upload ID may be invalid, or the upload may have been aborted or completed."));
        }
        String uploadId = null;
        try {
            uploadId = TestUtils.claimUploadId(secondClient, bucketName, "unormal-list-parts-object");
            ListPartsRequest listPartsRequest = new ListPartsRequest(bucketName, "unormal-list-parts-object", uploadId);
            listPartsRequest.setMaxParts(1001);
            secondClient.listParts(listPartsRequest);
            Assert.fail((String)"List parts should not be successful");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IllegalArgumentException));
            AbortMultipartUploadRequest abortMultipartUploadRequest = new AbortMultipartUploadRequest(bucketName, "unormal-list-parts-object", uploadId);
            secondClient.abortMultipartUpload(abortMultipartUploadRequest);
        }
    }

    @Test
    public void testUnormalAbortMultipartUpload() {
        String key = "unormal-abort-multipart-upload-object";
        String nonexistentUploadId = "nonexistent-upload-id";
        try {
            AbortMultipartUploadRequest abortMultipartUploadRequest = new AbortMultipartUploadRequest(bucketName, "unormal-abort-multipart-upload-object", "nonexistent-upload-id");
            secondClient.abortMultipartUpload(abortMultipartUploadRequest);
            Assert.fail((String)"Abort multipart upload should not be successful");
        }
        catch (OSSException e) {
            Assert.assertEquals((String)"NoSuchUpload", (String)e.getErrorCode());
            Assert.assertTrue((boolean)e.getMessage().startsWith("The specified upload does not exist. The upload ID may be invalid, or the upload may have been aborted or completed."));
        }
        String existingBucket = "unormal-abort-multipart-upload-existing-bucket";
        try {
            try {
                secondClient.createBucket("unormal-abort-multipart-upload-existing-bucket");
                String uploadId = TestUtils.claimUploadId(secondClient, "unormal-abort-multipart-upload-existing-bucket", "unormal-abort-multipart-upload-object");
                try {
                    secondClient.deleteBucket("unormal-abort-multipart-upload-existing-bucket");
                }
                catch (OSSException e) {
                    Assert.assertEquals((String)"BucketNotEmpty", (String)e.getErrorCode());
                    Assert.assertTrue((boolean)e.getMessage().startsWith("The bucket you tried to delete is not empty."));
                }
                AbortMultipartUploadRequest abortMultipartUploadRequest = new AbortMultipartUploadRequest("unormal-abort-multipart-upload-existing-bucket", "unormal-abort-multipart-upload-object", uploadId);
                secondClient.abortMultipartUpload(abortMultipartUploadRequest);
            }
            catch (Exception e) {
                Assert.fail((String)e.getMessage());
                secondClient.deleteBucket("unormal-abort-multipart-upload-existing-bucket");
            }
        }
        finally {
            secondClient.deleteBucket("unormal-abort-multipart-upload-existing-bucket");
        }
    }

    @Test
    public void testNormalListMultipartUploads() {
        try {
            ArrayList<String> existingKeys = new ArrayList<String>();
            int lv1KeyCount = 101;
            int lv2KeyCount = 11;
            int multipartUploadCount = 1012;
            String lv0KeyPrefix = "normal-list-multiparts-lv0-objects-";
            String lv1KeyPrefix = "normal-list-multiparts-lv0-objects/lv1-objects-";
            String lv2KeyPrefix = "normal-list-multiparts-lv0-objects/lv1-objects/lv2-objects-";
            int i = 0;
            while (i <= 1000) {
                if (i % 10 != 0) {
                    existingKeys.add("normal-list-multiparts-lv0-objects-" + i);
                } else {
                    existingKeys.add("normal-list-multiparts-lv0-objects/lv1-objects-" + i);
                    if (i % 100 == 0) {
                        existingKeys.add("normal-list-multiparts-lv0-objects/lv1-objects/lv2-objects-" + i);
                    }
                }
                ++i;
            }
            int partSize = 128;
            ArrayList<String> uploadIds = new ArrayList<String>(1012);
            int i2 = 0;
            while (i2 < 1012) {
                String key = (String)existingKeys.get(i2);
                String uploadId = TestUtils.claimUploadId(secondClient, bucketName, key);
                uploadIds.add(uploadId);
                InputStream instream = TestUtils.genFixedLengthInputStream(128L);
                UploadPartRequest uploadPartRequest = new UploadPartRequest();
                uploadPartRequest.setBucketName(bucketName);
                uploadPartRequest.setKey(key);
                uploadPartRequest.setInputStream(instream);
                uploadPartRequest.setPartNumber(1);
                uploadPartRequest.setPartSize(128L);
                uploadPartRequest.setUploadId(uploadId);
                UploadPartResult uploadPartResult = secondClient.uploadPart(uploadPartRequest);
                Assert.assertEquals((int)1, (int)uploadPartResult.getPartNumber());
                ++i2;
            }
            ListMultipartUploadsRequest listMultipartUploadsRequest = new ListMultipartUploadsRequest(bucketName);
            MultipartUploadListing multipartUploadListing = secondClient.listMultipartUploads(listMultipartUploadsRequest);
            Assert.assertEquals((String)bucketName, (String)multipartUploadListing.getBucketName());
            Assert.assertEquals((int)1000, (int)multipartUploadListing.getMaxUploads());
            Assert.assertTrue((boolean)multipartUploadListing.isTruncated());
            Assert.assertNotNull((Object)multipartUploadListing.getNextKeyMarker());
            Assert.assertNotNull((Object)multipartUploadListing.getNextUploadIdMarker());
            Assert.assertNull((Object)multipartUploadListing.getDelimiter());
            Assert.assertNull((Object)multipartUploadListing.getPrefix());
            Assert.assertNull((Object)multipartUploadListing.getKeyMarker());
            Assert.assertNull((Object)multipartUploadListing.getUploadIdMarker());
            List<MultipartUpload> multipartUploads = multipartUploadListing.getMultipartUploads();
            Assert.assertEquals((int)1000, (int)multipartUploads.size());
            int i3 = 0;
            while (i3 < 1000) {
                Assert.assertTrue((boolean)existingKeys.contains(multipartUploads.get(i3).getKey()));
                Assert.assertTrue((boolean)uploadIds.contains(multipartUploads.get(i3).getUploadId()));
                ++i3;
            }
            String keyMarker = multipartUploadListing.getNextKeyMarker();
            String uploadIdMarker = multipartUploadListing.getNextUploadIdMarker();
            listMultipartUploadsRequest.setKeyMarker(keyMarker);
            listMultipartUploadsRequest.setUploadIdMarker(uploadIdMarker);
            multipartUploadListing = secondClient.listMultipartUploads(listMultipartUploadsRequest);
            Assert.assertEquals((String)bucketName, (String)multipartUploadListing.getBucketName());
            Assert.assertEquals((int)1000, (int)multipartUploadListing.getMaxUploads());
            Assert.assertFalse((boolean)multipartUploadListing.isTruncated());
            Assert.assertNotNull((Object)multipartUploadListing.getNextKeyMarker());
            Assert.assertNotNull((Object)multipartUploadListing.getNextUploadIdMarker());
            Assert.assertNull((Object)multipartUploadListing.getDelimiter());
            Assert.assertNull((Object)multipartUploadListing.getPrefix());
            Assert.assertNull((Object)multipartUploadListing.getKeyMarker());
            Assert.assertNull((Object)multipartUploadListing.getUploadIdMarker());
            multipartUploads = multipartUploadListing.getMultipartUploads();
            Assert.assertEquals((int)12, (int)multipartUploads.size());
            int i4 = 0;
            while (i4 < 12) {
                Assert.assertTrue((boolean)existingKeys.contains(multipartUploads.get(i4).getKey()));
                Assert.assertTrue((boolean)uploadIds.contains(multipartUploads.get(i4).getUploadId()));
                ++i4;
            }
            int maxUploads = 100;
            listMultipartUploadsRequest = new ListMultipartUploadsRequest(bucketName);
            listMultipartUploadsRequest.setMaxUploads(100);
            listMultipartUploadsRequest.setPrefix("normal-list-multiparts-lv0-objects/lv1-objects-");
            multipartUploadListing = secondClient.listMultipartUploads(listMultipartUploadsRequest);
            Assert.assertEquals((String)bucketName, (String)multipartUploadListing.getBucketName());
            Assert.assertEquals((int)100, (int)multipartUploadListing.getMaxUploads());
            Assert.assertTrue((boolean)multipartUploadListing.isTruncated());
            Assert.assertNotNull((Object)multipartUploadListing.getNextKeyMarker());
            Assert.assertNotNull((Object)multipartUploadListing.getNextUploadIdMarker());
            Assert.assertNull((Object)multipartUploadListing.getDelimiter());
            Assert.assertEquals((String)"normal-list-multiparts-lv0-objects/lv1-objects-", (String)multipartUploadListing.getPrefix());
            Assert.assertNull((Object)multipartUploadListing.getKeyMarker());
            Assert.assertNull((Object)multipartUploadListing.getUploadIdMarker());
            multipartUploads = multipartUploadListing.getMultipartUploads();
            Assert.assertEquals((int)100, (int)multipartUploads.size());
            int i5 = 0;
            while (i5 < 100) {
                Assert.assertTrue((boolean)existingKeys.contains(multipartUploads.get(i5).getKey()));
                Assert.assertTrue((boolean)uploadIds.contains(multipartUploads.get(i5).getUploadId()));
                ++i5;
            }
            keyMarker = multipartUploadListing.getNextKeyMarker();
            uploadIdMarker = multipartUploadListing.getNextUploadIdMarker();
            listMultipartUploadsRequest.setKeyMarker(keyMarker);
            listMultipartUploadsRequest.setUploadIdMarker(uploadIdMarker);
            multipartUploadListing = secondClient.listMultipartUploads(listMultipartUploadsRequest);
            Assert.assertEquals((String)bucketName, (String)multipartUploadListing.getBucketName());
            Assert.assertEquals((int)100, (int)multipartUploadListing.getMaxUploads());
            Assert.assertFalse((boolean)multipartUploadListing.isTruncated());
            Assert.assertNotNull((Object)multipartUploadListing.getNextKeyMarker());
            Assert.assertNotNull((Object)multipartUploadListing.getNextUploadIdMarker());
            Assert.assertNull((Object)multipartUploadListing.getDelimiter());
            Assert.assertEquals((String)"normal-list-multiparts-lv0-objects/lv1-objects-", (String)multipartUploadListing.getPrefix());
            Assert.assertNull((Object)multipartUploadListing.getKeyMarker());
            Assert.assertNull((Object)multipartUploadListing.getUploadIdMarker());
            multipartUploads = multipartUploadListing.getMultipartUploads();
            Assert.assertEquals((int)1, (int)multipartUploads.size());
            i5 = 0;
            while (i5 < 1) {
                Assert.assertTrue((boolean)existingKeys.contains(multipartUploads.get(i5).getKey()));
                Assert.assertTrue((boolean)uploadIds.contains(multipartUploads.get(i5).getUploadId()));
                ++i5;
            }
            String delimiter = "/";
            String keyPrefix0 = "normal-list-multiparts-lv0-objects/";
            String keyPrefix1 = "normal-list-multiparts-lv0-objects/lv1-objects/";
            listMultipartUploadsRequest = new ListMultipartUploadsRequest(bucketName);
            listMultipartUploadsRequest.setPrefix("normal-list-multiparts-lv0-objects/");
            listMultipartUploadsRequest.setDelimiter("/");
            multipartUploadListing = secondClient.listMultipartUploads(listMultipartUploadsRequest);
            Assert.assertEquals((String)bucketName, (String)multipartUploadListing.getBucketName());
            Assert.assertEquals((int)1000, (int)multipartUploadListing.getMaxUploads());
            Assert.assertFalse((boolean)multipartUploadListing.isTruncated());
            Assert.assertNotNull((Object)multipartUploadListing.getNextKeyMarker());
            Assert.assertNotNull((Object)multipartUploadListing.getNextUploadIdMarker());
            Assert.assertEquals((String)"/", (String)multipartUploadListing.getDelimiter());
            Assert.assertEquals((String)"normal-list-multiparts-lv0-objects/", (String)multipartUploadListing.getPrefix());
            Assert.assertNull((Object)multipartUploadListing.getKeyMarker());
            Assert.assertNull((Object)multipartUploadListing.getUploadIdMarker());
            multipartUploads = multipartUploadListing.getMultipartUploads();
            Assert.assertEquals((int)101, (int)multipartUploads.size());
            int i6 = 0;
            while (i6 < 101) {
                Assert.assertTrue((boolean)existingKeys.contains(multipartUploads.get(i6).getKey()));
                Assert.assertTrue((boolean)uploadIds.contains(multipartUploads.get(i6).getUploadId()));
                ++i6;
            }
            Assert.assertEquals((int)1, (int)multipartUploadListing.getCommonPrefixes().size());
            Assert.assertEquals((String)"normal-list-multiparts-lv0-objects/lv1-objects/", (String)multipartUploadListing.getCommonPrefixes().get(0));
            i6 = 0;
            while (i6 < 1012) {
                AbortMultipartUploadRequest abortMultipartUploadRequest = new AbortMultipartUploadRequest(bucketName, (String)existingKeys.get(i6), (String)uploadIds.get(i6));
                secondClient.abortMultipartUpload(abortMultipartUploadRequest);
                ++i6;
            }
            listMultipartUploadsRequest = new ListMultipartUploadsRequest(bucketName);
            multipartUploadListing = secondClient.listMultipartUploads(listMultipartUploadsRequest);
            Assert.assertEquals((int)0, (int)multipartUploadListing.getMultipartUploads().size());
            Assert.assertEquals((String)bucketName, (String)multipartUploadListing.getBucketName());
            Assert.assertEquals((int)1000, (int)multipartUploadListing.getMaxUploads());
            Assert.assertFalse((boolean)multipartUploadListing.isTruncated());
            Assert.assertNull((Object)multipartUploadListing.getNextKeyMarker());
            Assert.assertNull((Object)multipartUploadListing.getNextUploadIdMarker());
            Assert.assertNull((Object)multipartUploadListing.getDelimiter());
            Assert.assertNull((Object)multipartUploadListing.getPrefix());
            Assert.assertNull((Object)multipartUploadListing.getKeyMarker());
            Assert.assertNull((Object)multipartUploadListing.getUploadIdMarker());
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testUnormalListMultipartUploads() {
        String key = "unormal-list-multipart-uploads-object";
        String nonexistentBucket = "nonexistent-upload-id";
        try {
            ListMultipartUploadsRequest listMultipartUploadsRequest = new ListMultipartUploadsRequest("nonexistent-upload-id");
            secondClient.listMultipartUploads(listMultipartUploadsRequest);
            Assert.fail((String)"List multipart uploads should not be successful");
        }
        catch (OSSException e) {
            Assert.assertEquals((String)"NoSuchBucket", (String)e.getErrorCode());
            Assert.assertTrue((boolean)e.getMessage().startsWith("The specified bucket does not exist."));
        }
        int maxUploads = 1001;
        String uploadId = null;
        try {
            uploadId = TestUtils.claimUploadId(secondClient, bucketName, "unormal-list-multipart-uploads-object");
            ListMultipartUploadsRequest listMultipartUploadsRequest = new ListMultipartUploadsRequest(bucketName);
            listMultipartUploadsRequest.setMaxUploads(1001);
            secondClient.listMultipartUploads(listMultipartUploadsRequest);
            Assert.fail((String)"List multipart uploads should not be successful");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IllegalArgumentException));
            AbortMultipartUploadRequest abortMultipartUploadRequest = new AbortMultipartUploadRequest(bucketName, "unormal-list-multipart-uploads-object", uploadId);
            secondClient.abortMultipartUpload(abortMultipartUploadRequest);
        }
    }

    @Test
    public void testNormalCompleteMultipartUpload() {
        String key = "normal-complete-multipart-upload-object";
        int partSize = 131072;
        int partCount = 10;
        try {
            String uploadId = TestUtils.claimUploadId(secondClient, bucketName, "normal-complete-multipart-upload-object");
            ArrayList<PartETag> partETags = new ArrayList<PartETag>();
            int i = 0;
            while (i < 10) {
                InputStream instream = TestUtils.genFixedLengthInputStream(131072L);
                UploadPartRequest uploadPartRequest = new UploadPartRequest();
                uploadPartRequest.setBucketName(bucketName);
                uploadPartRequest.setKey("normal-complete-multipart-upload-object");
                uploadPartRequest.setInputStream(instream);
                uploadPartRequest.setPartNumber(i + 1);
                uploadPartRequest.setPartSize(131072L);
                uploadPartRequest.setUploadId(uploadId);
                UploadPartResult uploadPartResult = secondClient.uploadPart(uploadPartRequest);
                partETags.add(uploadPartResult.getPartETag());
                ++i;
            }
            CompleteMultipartUploadRequest completeMultipartUploadRequest = new CompleteMultipartUploadRequest(bucketName, "normal-complete-multipart-upload-object", uploadId, partETags);
            CompleteMultipartUploadResult completeMultipartUploadResult = secondClient.completeMultipartUpload(completeMultipartUploadRequest);
            Assert.assertEquals((String)TestUtils.composeLocation(secondClient, "http://oss-test.aliyun-inc.com", bucketName, "normal-complete-multipart-upload-object"), (String)completeMultipartUploadResult.getLocation());
            Assert.assertEquals((String)bucketName, (String)completeMultipartUploadResult.getBucketName());
            Assert.assertEquals((String)"normal-complete-multipart-upload-object", (String)completeMultipartUploadResult.getKey());
            Assert.assertEquals((String)TestUtils.calcMultipartsETag(partETags), (String)completeMultipartUploadResult.getETag());
            OSSObject o = secondClient.getObject(bucketName, "normal-complete-multipart-upload-object");
            long objectSize = 0x140000L;
            Assert.assertEquals((long)objectSize, (long)o.getObjectMetadata().getContentLength());
            Assert.assertEquals((String)TestUtils.calcMultipartsETag(partETags), (String)o.getObjectMetadata().getETag());
            uploadId = TestUtils.claimUploadId(secondClient, bucketName, "normal-complete-multipart-upload-object");
            partETags.clear();
            int i2 = 0;
            while (i2 < 10) {
                InputStream instream = TestUtils.genFixedLengthInputStream(131072L);
                UploadPartRequest uploadPartRequest = new UploadPartRequest();
                uploadPartRequest.setBucketName(bucketName);
                uploadPartRequest.setKey("normal-complete-multipart-upload-object");
                uploadPartRequest.setInputStream(instream);
                uploadPartRequest.setPartNumber(i2 + 1);
                uploadPartRequest.setPartSize(131072L);
                uploadPartRequest.setUploadId(uploadId);
                UploadPartResult uploadPartResult = secondClient.uploadPart(uploadPartRequest);
                partETags.add(uploadPartResult.getPartETag());
                ++i2;
            }
            ArrayList<PartETag> discontinuousPartETags = new ArrayList<PartETag>();
            discontinuousPartETags.add((PartETag)partETags.get(0));
            discontinuousPartETags.add((PartETag)partETags.get(4));
            discontinuousPartETags.add((PartETag)partETags.get(7));
            completeMultipartUploadRequest = new CompleteMultipartUploadRequest(bucketName, "normal-complete-multipart-upload-object", uploadId, discontinuousPartETags);
            completeMultipartUploadResult = secondClient.completeMultipartUpload(completeMultipartUploadRequest);
            Assert.assertEquals((String)TestUtils.composeLocation(secondClient, "http://oss-test.aliyun-inc.com", bucketName, "normal-complete-multipart-upload-object"), (String)completeMultipartUploadResult.getLocation());
            Assert.assertEquals((String)bucketName, (String)completeMultipartUploadResult.getBucketName());
            Assert.assertEquals((String)"normal-complete-multipart-upload-object", (String)completeMultipartUploadResult.getKey());
            Assert.assertEquals((String)TestUtils.calcMultipartsETag(discontinuousPartETags), (String)completeMultipartUploadResult.getETag());
            o = secondClient.getObject(bucketName, "normal-complete-multipart-upload-object");
            objectSize = discontinuousPartETags.size() * 131072;
            Assert.assertEquals((long)objectSize, (long)o.getObjectMetadata().getContentLength());
            Assert.assertEquals((String)TestUtils.calcMultipartsETag(discontinuousPartETags), (String)o.getObjectMetadata().getETag());
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testUnormalCompleteMultipartUpload() {
        String key = "unormal-complete-multipart-upload-object";
        int partSize = 131072;
        int partCount = 10;
        try {
            CompleteMultipartUploadRequest completeMultipartUploadRequest;
            ArrayList<PartETag> partETags;
            String uploadId;
            block23: {
                block21: {
                    block19: {
                        uploadId = TestUtils.claimUploadId(secondClient, bucketName, "unormal-complete-multipart-upload-object");
                        int invalidPartSize = 65536;
                        partETags = new ArrayList<PartETag>();
                        int i = 0;
                        while (i < 10) {
                            InputStream instream = TestUtils.genFixedLengthInputStream(131072L);
                            UploadPartRequest uploadPartRequest = new UploadPartRequest();
                            uploadPartRequest.setBucketName(bucketName);
                            uploadPartRequest.setKey("unormal-complete-multipart-upload-object");
                            uploadPartRequest.setInputStream(instream);
                            uploadPartRequest.setPartNumber(i + 1);
                            uploadPartRequest.setPartSize(65536L);
                            uploadPartRequest.setUploadId(uploadId);
                            UploadPartResult uploadPartResult = secondClient.uploadPart(uploadPartRequest);
                            partETags.add(uploadPartResult.getPartETag());
                            ++i;
                        }
                        try {
                            CompleteMultipartUploadRequest completeMultipartUploadRequest2 = new CompleteMultipartUploadRequest(bucketName, "unormal-complete-multipart-upload-object", uploadId, partETags);
                            secondClient.completeMultipartUpload(completeMultipartUploadRequest2);
                        }
                        catch (OSSException e) {
                            Assert.assertEquals((String)"EntityTooSmall", (String)e.getErrorCode());
                            Assert.assertTrue((boolean)e.getMessage().startsWith("Your proposed upload smaller than the minimum allowed size."));
                        }
                        AbortMultipartUploadRequest abortMultipartUploadRequest = new AbortMultipartUploadRequest(bucketName, "unormal-complete-multipart-upload-object", uploadId);
                        secondClient.abortMultipartUpload(abortMultipartUploadRequest);
                        uploadId = TestUtils.claimUploadId(secondClient, bucketName, "unormal-complete-multipart-upload-object");
                        partETags.clear();
                        int i2 = 0;
                        while (i2 < 10) {
                            InputStream instream = TestUtils.genFixedLengthInputStream(131072L);
                            UploadPartRequest uploadPartRequest = new UploadPartRequest();
                            uploadPartRequest.setBucketName(bucketName);
                            uploadPartRequest.setKey("unormal-complete-multipart-upload-object");
                            uploadPartRequest.setInputStream(instream);
                            uploadPartRequest.setPartNumber(i2 + 1);
                            uploadPartRequest.setPartSize(131072L);
                            uploadPartRequest.setUploadId(uploadId);
                            UploadPartResult uploadPartResult = secondClient.uploadPart(uploadPartRequest);
                            partETags.add(uploadPartResult.getPartETag());
                            ++i2;
                        }
                        String invalidETag = "Invalid-ETag";
                        int partNumber = 4;
                        PartETag originalPartETag = (PartETag)partETags.get(3);
                        PartETag invalidPartETag = new PartETag(4, "Invalid-ETag");
                        partETags.set(3, invalidPartETag);
                        try {
                            try {
                                CompleteMultipartUploadRequest completeMultipartUploadRequest3 = new CompleteMultipartUploadRequest(bucketName, "unormal-complete-multipart-upload-object", uploadId, partETags);
                                secondClient.completeMultipartUpload(completeMultipartUploadRequest3);
                                Assert.fail((String)"Complete multipart upload should not be successful");
                            }
                            catch (OSSException e) {
                                Assert.assertEquals((String)"InvalidPart", (String)e.getErrorCode());
                                Assert.assertTrue((boolean)e.getMessage().startsWith("One or more of the specified parts could not be found or the specified entity tag might not have matched the part's entity tag."));
                                partETags.set(3, originalPartETag);
                                break block19;
                            }
                        }
                        catch (Throwable throwable) {
                            partETags.set(3, originalPartETag);
                            throw throwable;
                        }
                        partETags.set(3, originalPartETag);
                    }
                    int swapFrom = 2;
                    int swapTo = 5;
                    PartETag tmp = (PartETag)partETags.get(5);
                    partETags.set(5, (PartETag)partETags.get(2));
                    partETags.set(2, tmp);
                    try {
                        try {
                            CompleteMultipartUploadRequest completeMultipartUploadRequest4 = new CompleteMultipartUploadRequest(bucketName, "unormal-complete-multipart-upload-object", uploadId, partETags);
                            secondClient.completeMultipartUpload(completeMultipartUploadRequest4);
                            Assert.fail((String)"Complete multipart upload should not be successful");
                        }
                        catch (OSSException e) {
                            Assert.assertEquals((String)"InvalidPartOrder", (String)e.getErrorCode());
                            Assert.assertTrue((boolean)e.getMessage().startsWith("The list of parts was not in ascending order. Parts list must specified in order by part number."));
                            partETags.set(2, (PartETag)partETags.get(5));
                            partETags.set(5, tmp);
                            break block21;
                        }
                    }
                    catch (Throwable throwable) {
                        partETags.set(2, (PartETag)partETags.get(5));
                        partETags.set(5, tmp);
                        throw throwable;
                    }
                    partETags.set(2, (PartETag)partETags.get(5));
                    partETags.set(5, tmp);
                }
                PartETag nonexistentPartETag = new PartETag(11, "Invalid-ETag");
                partETags.add(nonexistentPartETag);
                try {
                    try {
                        completeMultipartUploadRequest = new CompleteMultipartUploadRequest(bucketName, "unormal-complete-multipart-upload-object", uploadId, partETags);
                        secondClient.completeMultipartUpload(completeMultipartUploadRequest);
                        Assert.fail((String)"Complete multipart upload should not be successful");
                    }
                    catch (OSSException e) {
                        Assert.assertEquals((String)"InvalidPart", (String)e.getErrorCode());
                        Assert.assertTrue((boolean)e.getMessage().startsWith("One or more of the specified parts could not be found or the specified entity tag might not have matched the part's entity tag."));
                        partETags.remove(10);
                        break block23;
                    }
                }
                catch (Throwable throwable) {
                    partETags.remove(10);
                    throw throwable;
                }
                partETags.remove(10);
            }
            completeMultipartUploadRequest = new CompleteMultipartUploadRequest(bucketName, "unormal-complete-multipart-upload-object", uploadId, partETags);
            CompleteMultipartUploadResult completeMultipartUploadResult = secondClient.completeMultipartUpload(completeMultipartUploadRequest);
            Assert.assertEquals((String)TestUtils.composeLocation(secondClient, "http://oss-test.aliyun-inc.com", bucketName, "unormal-complete-multipart-upload-object"), (String)completeMultipartUploadResult.getLocation());
            Assert.assertEquals((String)bucketName, (String)completeMultipartUploadResult.getBucketName());
            Assert.assertEquals((String)"unormal-complete-multipart-upload-object", (String)completeMultipartUploadResult.getKey());
            Assert.assertEquals((String)TestUtils.calcMultipartsETag(partETags), (String)completeMultipartUploadResult.getETag());
            OSSObject o = secondClient.getObject(bucketName, "unormal-complete-multipart-upload-object");
            long objectSize = 0x140000L;
            Assert.assertEquals((long)objectSize, (long)o.getObjectMetadata().getContentLength());
            Assert.assertEquals((String)TestUtils.calcMultipartsETag(partETags), (String)o.getObjectMetadata().getETag());
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testUploadPartWithChunked() {
        block9: {
            OSSObject o;
            CompleteMultipartUploadResult completeMultipartUploadResult;
            UploadPartRequest uploadPartRequest;
            InputStream instream;
            ArrayList<PartETag> partETags;
            String key = "upload-part-with-chunked-object";
            int partSize = 131072;
            int partCount = 10;
            String uploadId = null;
            String filePath = null;
            try {
                uploadId = TestUtils.claimUploadId(secondClient, bucketName, "upload-part-with-chunked-object");
                partETags = new ArrayList<PartETag>();
                int i = 0;
                while (i < 10) {
                    instream = TestUtils.genFixedLengthInputStream(131072L);
                    uploadPartRequest = new UploadPartRequest();
                    uploadPartRequest.setBucketName(bucketName);
                    uploadPartRequest.setKey("upload-part-with-chunked-object");
                    uploadPartRequest.setInputStream(instream);
                    uploadPartRequest.setPartNumber(i + 1);
                    uploadPartRequest.setUseChunkEncoding(true);
                    uploadPartRequest.setUploadId(uploadId);
                    UploadPartResult uploadPartResult = secondClient.uploadPart(uploadPartRequest);
                    partETags.add(uploadPartResult.getPartETag());
                    ++i;
                }
                CompleteMultipartUploadRequest completeMultipartUploadRequest = new CompleteMultipartUploadRequest(bucketName, "upload-part-with-chunked-object", uploadId, partETags);
                completeMultipartUploadResult = secondClient.completeMultipartUpload(completeMultipartUploadRequest);
                Assert.assertEquals((String)TestUtils.composeLocation(secondClient, "http://oss-test.aliyun-inc.com", bucketName, "upload-part-with-chunked-object"), (String)completeMultipartUploadResult.getLocation());
                Assert.assertEquals((String)bucketName, (String)completeMultipartUploadResult.getBucketName());
                Assert.assertEquals((String)"upload-part-with-chunked-object", (String)completeMultipartUploadResult.getKey());
                Assert.assertEquals((String)TestUtils.calcMultipartsETag(partETags), (String)completeMultipartUploadResult.getETag());
                o = secondClient.getObject(bucketName, "upload-part-with-chunked-object");
                long objectSize = 0x140000L;
                Assert.assertEquals((long)objectSize, (long)o.getObjectMetadata().getContentLength());
                Assert.assertEquals((String)TestUtils.calcMultipartsETag(partETags), (String)o.getObjectMetadata().getETag());
            }
            catch (Exception e) {
                Assert.fail((String)e.getMessage());
            }
            try {
                try {
                    uploadId = TestUtils.claimUploadId(secondClient, bucketName, "upload-part-with-chunked-object");
                    filePath = TestUtils.genFixedLengthFile(0x140000L);
                    partETags = new ArrayList();
                    int i = 0;
                    while (i < 10) {
                        instream = new FileInputStream(new File(filePath));
                        instream.skip(i * 131072);
                        uploadPartRequest = new UploadPartRequest();
                        uploadPartRequest.setBucketName(bucketName);
                        uploadPartRequest.setKey("upload-part-with-chunked-object");
                        uploadPartRequest.setInputStream(instream);
                        uploadPartRequest.setPartNumber(i + 1);
                        uploadPartRequest.setPartSize(131072L);
                        uploadPartRequest.setUseChunkEncoding(true);
                        uploadPartRequest.setUploadId(uploadId);
                        UploadPartResult uploadPartResult = secondClient.uploadPart(uploadPartRequest);
                        partETags.add(uploadPartResult.getPartETag());
                        ++i;
                    }
                    CompleteMultipartUploadRequest completeMultipartUploadRequest = new CompleteMultipartUploadRequest(bucketName, "upload-part-with-chunked-object", uploadId, partETags);
                    completeMultipartUploadResult = secondClient.completeMultipartUpload(completeMultipartUploadRequest);
                    Assert.assertEquals((String)TestUtils.composeLocation(secondClient, "http://oss-test.aliyun-inc.com", bucketName, "upload-part-with-chunked-object"), (String)completeMultipartUploadResult.getLocation());
                    Assert.assertEquals((String)bucketName, (String)completeMultipartUploadResult.getBucketName());
                    Assert.assertEquals((String)"upload-part-with-chunked-object", (String)completeMultipartUploadResult.getKey());
                    Assert.assertEquals((String)TestUtils.calcMultipartsETag(partETags), (String)completeMultipartUploadResult.getETag());
                    o = secondClient.getObject(bucketName, "upload-part-with-chunked-object");
                    long objectSize = 0x140000L;
                    Assert.assertEquals((long)objectSize, (long)o.getObjectMetadata().getContentLength());
                    Assert.assertEquals((String)TestUtils.calcMultipartsETag(partETags), (String)o.getObjectMetadata().getETag());
                }
                catch (Exception e) {
                    Assert.fail((String)e.getMessage());
                    TestUtils.removeFile(filePath);
                    break block9;
                }
            }
            catch (Throwable throwable) {
                TestUtils.removeFile(filePath);
                throw throwable;
            }
            TestUtils.removeFile(filePath);
        }
    }

    @Test
    public void testDeleteAllBuckets() {
        try {
            List<Bucket> returnedBuckets = secondClient.listBuckets();
            for (Bucket bkt : returnedBuckets) {
                String bktName = bkt.getName();
                String keyMarker = null;
                String uploadIdMarker = null;
                ListMultipartUploadsRequest listMultipartUploadsRequest = null;
                MultipartUploadListing multipartUploadListing = null;
                List<MultipartUpload> multipartUploads = null;
                do {
                    listMultipartUploadsRequest = new ListMultipartUploadsRequest(bktName);
                    listMultipartUploadsRequest.setKeyMarker(keyMarker);
                    listMultipartUploadsRequest.setUploadIdMarker(uploadIdMarker);
                    multipartUploadListing = secondClient.listMultipartUploads(listMultipartUploadsRequest);
                    multipartUploads = multipartUploadListing.getMultipartUploads();
                    for (MultipartUpload mu : multipartUploads) {
                        String key = mu.getKey();
                        String uploadId = mu.getUploadId();
                        secondClient.abortMultipartUpload(new AbortMultipartUploadRequest(bktName, key, uploadId));
                    }
                    keyMarker = multipartUploadListing.getKeyMarker();
                    uploadIdMarker = multipartUploadListing.getUploadIdMarker();
                } while (multipartUploadListing != null && multipartUploadListing.isTruncated());
                UploadPartTest.deleteBucketWithObjects(secondClient, bktName);
            }
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }
}

