/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.common.comm;

import com.aliyun.oss.ClientConfiguration;
import com.aliyun.oss.ClientException;
import com.aliyun.oss.HttpMethod;
import com.aliyun.oss.ServiceException;
import com.aliyun.oss.common.comm.ExecutionContext;
import com.aliyun.oss.common.comm.HttpMesssage;
import com.aliyun.oss.common.comm.RequestHandler;
import com.aliyun.oss.common.comm.RequestMessage;
import com.aliyun.oss.common.comm.ResponseHandler;
import com.aliyun.oss.common.comm.ResponseMessage;
import com.aliyun.oss.common.comm.RetryStrategy;
import com.aliyun.oss.common.utils.CodingUtils;
import com.aliyun.oss.common.utils.HttpUtil;
import com.aliyun.oss.common.utils.ResourceManager;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class ServiceClient {
    private static final Log log = LogFactory.getLog(ServiceClient.class);
    private static final ResourceManager rm = ResourceManager.getInstance("common");
    protected final ClientConfiguration config;

    protected ServiceClient(ClientConfiguration config) {
        this.config = config == null ? new ClientConfiguration() : config;
    }

    public ClientConfiguration getClientConfiguration() {
        return this.config == null ? new ClientConfiguration() : this.config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseMessage sendRequest(RequestMessage request, ExecutionContext context) throws ServiceException, ClientException {
        CodingUtils.assertParameterNotNull(request, "request");
        CodingUtils.assertParameterNotNull(context, "context");
        try {
            ResponseMessage responseMessage = this.sendRequestImpl(request, context);
            return responseMessage;
        }
        finally {
            block7: {
                try {
                    request.close();
                }
                catch (IOException e) {
                    if (!log.isWarnEnabled()) break block7;
                    log.warn((Object)("Unexpected io exception when trying to close http request: " + e.getMessage()));
                }
            }
        }
    }

    private ResponseMessage sendRequestImpl(RequestMessage request, ExecutionContext context) throws ClientException, ServiceException {
        InputStream requestContent;
        RetryStrategy retryStrategy;
        RetryStrategy retryStrategy2 = retryStrategy = context.getRetryStrategy() != null ? context.getRetryStrategy() : this.getDefaultRetryStrategy();
        if (context.getSigner() != null && !request.isUseUrlSignature()) {
            context.getSigner().sign(request);
        }
        if ((requestContent = request.getContent()) != null && requestContent.markSupported()) {
            requestContent.mark(131072);
        }
        int retries = 0;
        ResponseMessage response = null;
        while (true) {
            try {
                if (retries > 0) {
                    this.pause(retries, retryStrategy);
                    if (requestContent != null && requestContent.markSupported()) {
                        try {
                            requestContent.reset();
                        }
                        catch (IOException ex) {
                            throw new ClientException("Failed to reset the request input stream", ex);
                        }
                    }
                }
                Request httpRequest = this.buildRequest(request, context);
                this.handleRequest(httpRequest, context.getResquestHandlers());
                response = this.sendRequestCore(httpRequest, context);
                this.handleResponse(response, context.getResponseHandlers());
                ResponseMessage responseMessage = response;
                return responseMessage;
            }
            catch (ServiceException ex) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)("Unable to execute HTTP request: " + ex.getMessage()));
                }
                this.closeResponseSilently(response);
                if (this.shouldRetry(ex, request, response, retries, retryStrategy)) continue;
                throw ex;
            }
            catch (ClientException ex) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)("Unable to execute HTTP request: " + ex.getMessage()));
                }
                this.closeResponseSilently(response);
                if (ex.getErrorCode().equals("InvalidResponse")) {
                    throw ex;
                }
                if (this.shouldRetry(ex, request, response, retries, retryStrategy)) continue;
                throw ex;
            }
            catch (Exception ex) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)("Unable to execute HTTP request: " + ex.getMessage()));
                }
                this.closeResponseSilently(response);
                throw new ClientException(rm.getFormattedString("ConnectionError", ex.getMessage()), ex);
            }
            finally {
                ++retries;
                continue;
            }
            break;
        }
    }

    protected abstract ResponseMessage sendRequestCore(Request var1, ExecutionContext var2) throws IOException;

    private Request buildRequest(RequestMessage requestMessage, ExecutionContext context) throws ClientException {
        boolean putParamsInUri;
        Request request = new Request();
        request.setMethod(requestMessage.getMethod());
        request.setUseChunkEncoding(requestMessage.isUseChunkEncoding());
        if (requestMessage.isUseUrlSignature()) {
            request.setUrl(requestMessage.getAbsoluteUrl().toString());
            request.setUseUrlSignature(true);
            request.setContent(requestMessage.getContent());
            request.setContentLength(requestMessage.getContentLength());
            request.setHeaders(requestMessage.getHeaders());
            return request;
        }
        request.setHeaders(requestMessage.getHeaders());
        if (request.getHeaders() != null) {
            HttpUtil.convertHeaderCharsetToIso88591(request.getHeaders());
        }
        String delimiter = "/";
        String uri = requestMessage.getEndpoint().toString();
        if (!(uri.endsWith("/") || requestMessage.getResourcePath() != null && requestMessage.getResourcePath().startsWith("/"))) {
            uri = uri + "/";
        }
        if (requestMessage.getResourcePath() != null) {
            uri = uri + requestMessage.getResourcePath();
        }
        String paramString = HttpUtil.paramToQueryString(requestMessage.getParameters(), context.getCharset());
        boolean requestHasNoPayload = requestMessage.getContent() != null;
        boolean requestIsPost = requestMessage.getMethod() == HttpMethod.POST;
        boolean bl = putParamsInUri = !requestIsPost || requestHasNoPayload;
        if (paramString != null && putParamsInUri) {
            uri = uri + "?" + paramString;
        }
        request.setUrl(uri);
        if (requestIsPost && requestMessage.getContent() == null && paramString != null) {
            try {
                byte[] buf = paramString.getBytes(context.getCharset());
                ByteArrayInputStream content = new ByteArrayInputStream(buf);
                request.setContent(content);
                request.setContentLength(buf.length);
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(rm.getFormattedString("EncodingFailed", e.getMessage()));
            }
        } else {
            request.setContent(requestMessage.getContent());
            request.setContentLength(requestMessage.getContentLength());
        }
        return request;
    }

    private void handleResponse(ResponseMessage response, List<ResponseHandler> responseHandlers) throws ServiceException, ClientException {
        for (ResponseHandler h : responseHandlers) {
            if (!response.isSuccessful() && log.isDebugEnabled()) {
                log.debug((Object)response.getDebugInfo());
            }
            h.handle(response);
        }
    }

    private void handleRequest(Request message, List<RequestHandler> resquestHandlers) throws ServiceException, ClientException {
        for (RequestHandler h : resquestHandlers) {
            h.handle(message);
        }
    }

    private void pause(int retries, RetryStrategy retryStrategy) throws ClientException {
        long delay = retryStrategy.getPauseDelay(retries);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Retriable error detected, will retry in " + delay + "ms, attempt number: " + retries));
        }
        try {
            Thread.sleep(delay);
        }
        catch (InterruptedException e) {
            throw new ClientException(e.getMessage(), e);
        }
    }

    private boolean shouldRetry(Exception exception, RequestMessage request, ResponseMessage response, int retries, RetryStrategy retryStrategy) {
        if (retries >= this.config.getMaxErrorRetry()) {
            return false;
        }
        if (!request.isRepeatable()) {
            return false;
        }
        if (retryStrategy.shouldRetry(exception, request, response, retries)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Retrying on " + exception.getClass().getName() + ": " + exception.getMessage()));
            }
            return true;
        }
        return false;
    }

    private void closeResponseSilently(ResponseMessage response) {
        if (response != null) {
            try {
                response.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected abstract RetryStrategy getDefaultRetryStrategy();

    public abstract void shutdown();

    public static class Request
    extends HttpMesssage {
        private String uri;
        private HttpMethod method;
        private boolean useUrlSignature = false;
        private boolean useChunkEncoding = false;

        public String getUri() {
            return this.uri;
        }

        public void setUrl(String uri) {
            this.uri = uri;
        }

        public HttpMethod getMethod() {
            return this.method;
        }

        public void setMethod(HttpMethod method) {
            this.method = method;
        }

        public boolean isUseUrlSignature() {
            return this.useUrlSignature;
        }

        public void setUseUrlSignature(boolean useUrlSignature) {
            this.useUrlSignature = useUrlSignature;
        }

        public boolean isUseChunkEncoding() {
            return this.useChunkEncoding;
        }

        public void setUseChunkEncoding(boolean useChunkEncoding) {
            this.useChunkEncoding = useChunkEncoding;
        }
    }
}

