/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.internal;

import com.aliyun.oss.ClientException;
import com.aliyun.oss.HttpMethod;
import com.aliyun.oss.OSSException;
import com.aliyun.oss.ServiceException;
import com.aliyun.oss.common.auth.CredentialsProvider;
import com.aliyun.oss.common.comm.RequestMessage;
import com.aliyun.oss.common.comm.ResponseHandler;
import com.aliyun.oss.common.comm.ResponseMessage;
import com.aliyun.oss.common.comm.ServiceClient;
import com.aliyun.oss.common.comm.io.RepeatableFileInputStream;
import com.aliyun.oss.common.parser.RequestMarshallers;
import com.aliyun.oss.common.utils.BinaryUtil;
import com.aliyun.oss.common.utils.CodingUtils;
import com.aliyun.oss.common.utils.DateUtil;
import com.aliyun.oss.common.utils.ExceptionFactory;
import com.aliyun.oss.common.utils.HttpUtil;
import com.aliyun.oss.common.utils.IOUtils;
import com.aliyun.oss.common.utils.RangeSpec;
import com.aliyun.oss.internal.Mimetypes;
import com.aliyun.oss.internal.OSSOperation;
import com.aliyun.oss.internal.OSSRequestMessageBuilder;
import com.aliyun.oss.internal.OSSUtils;
import com.aliyun.oss.internal.ResponseParsers;
import com.aliyun.oss.model.CopyObjectRequest;
import com.aliyun.oss.model.CopyObjectResult;
import com.aliyun.oss.model.DeleteObjectsRequest;
import com.aliyun.oss.model.DeleteObjectsResult;
import com.aliyun.oss.model.GetObjectRequest;
import com.aliyun.oss.model.HeadObjectRequest;
import com.aliyun.oss.model.OSSObject;
import com.aliyun.oss.model.ObjectMetadata;
import com.aliyun.oss.model.PutObjectRequest;
import com.aliyun.oss.model.PutObjectResult;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class OSSObjectOperation
extends OSSOperation {
    public OSSObjectOperation(ServiceClient client, CredentialsProvider credsProvider) {
        super(client, credsProvider);
    }

    public PutObjectResult putObject(PutObjectRequest putObjectRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(putObjectRequest, "putObjectRequest");
        String bucketName = putObjectRequest.getBucketName();
        String key = putObjectRequest.getKey();
        InputStream originalInputStream = putObjectRequest.getInputStream();
        ObjectMetadata metadata = putObjectRequest.getMetadata();
        if (metadata == null) {
            metadata = new ObjectMetadata();
        }
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        CodingUtils.assertParameterNotNull(key, "key");
        OSSUtils.ensureBucketNameValid(bucketName);
        OSSUtils.ensureObjectKeyValid(key);
        InputStream repeatableInputStream = null;
        if (putObjectRequest.getFile() != null) {
            File toUpload = putObjectRequest.getFile();
            if (!IOUtils.checkFile(toUpload)) {
                throw new ClientException("Illegal file path: " + toUpload.getPath());
            }
            metadata.setContentLength(toUpload.length());
            if (metadata.getContentType() == null) {
                metadata.setContentType(Mimetypes.getInstance().getMimetype(toUpload));
            }
            try {
                repeatableInputStream = new RepeatableFileInputStream(toUpload);
            }
            catch (IOException e) {
                throw new ClientException("Cannot locate file to upload", e);
            }
        }
        CodingUtils.assertTrue(originalInputStream != null, "Please specify input stream or file to upload");
        if (metadata.getContentType() == null) {
            metadata.setContentType("application/octet-stream");
        }
        try {
            repeatableInputStream = IOUtils.newRepeatableInputStream(originalInputStream);
        }
        catch (IOException e) {
            throw new ClientException("Cannot wrap to repeatable input stream", e);
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        OSSUtils.populateRequestMetadata(headers, metadata);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.PUT).setBucket(bucketName).setKey(key).setHeaders(headers).setInputStream(repeatableInputStream).setInputSize(OSSUtils.determineInputStreamLength(repeatableInputStream, metadata.getContentLength())).build();
        return this.doOperation(request, ResponseParsers.putObjectReponseParser, bucketName, key, true);
    }

    public PutObjectResult putObject(URL signedUrl, InputStream requestContent, long contentLength, Map<String, String> requestHeaders, boolean useChunkEncoding) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(signedUrl, "signedUrl");
        CodingUtils.assertParameterNotNull(requestContent, "requestContent");
        if (requestHeaders == null) {
            requestHeaders = new HashMap<String, String>();
        }
        RequestMessage request = new RequestMessage();
        request.setMethod(HttpMethod.PUT);
        request.setAbsoluteUrl(signedUrl);
        request.setUseUrlSignature(true);
        request.setContent(requestContent);
        request.setContentLength(OSSUtils.determineInputStreamLength(requestContent, contentLength, useChunkEncoding));
        request.setHeaders(requestHeaders);
        request.setUseChunkEncoding(useChunkEncoding);
        return this.doOperation(request, ResponseParsers.putObjectReponseParser, null, null, true);
    }

    public OSSObject getObject(String bucketName, String key) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        CodingUtils.assertParameterNotNull(key, "key");
        OSSUtils.ensureBucketNameValid(bucketName);
        OSSUtils.ensureObjectKeyValid(key);
        return this.getObject(new GetObjectRequest(bucketName, key));
    }

    public OSSObject getObject(GetObjectRequest getObjectRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(getObjectRequest, "getObjectRequest");
        String bucketName = null;
        String key = null;
        RequestMessage request = null;
        if (!getObjectRequest.isUseUrlSignature()) {
            CodingUtils.assertParameterNotNull(getObjectRequest, "getObjectRequest");
            bucketName = getObjectRequest.getBucketName();
            key = getObjectRequest.getKey();
            CodingUtils.assertParameterNotNull(bucketName, "bucketName");
            CodingUtils.assertParameterNotNull(key, "key");
            OSSUtils.ensureBucketNameValid(bucketName);
            OSSUtils.ensureObjectKeyValid(key);
            HashMap<String, String> headers = new HashMap<String, String>();
            OSSObjectOperation.populateGetObjectRequestHeaders(getObjectRequest, headers);
            HashMap<String, String> params = new HashMap<String, String>();
            OSSUtils.populateResponseHeaderParameters(params, getObjectRequest.getResponseHeaders());
            request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.GET).setBucket(bucketName).setKey(key).setHeaders(headers).setParameters(params).build();
        } else {
            request = new RequestMessage();
            request.setMethod(HttpMethod.GET);
            request.setAbsoluteUrl(getObjectRequest.getAbsoluteUri());
            request.setUseUrlSignature(true);
            request.setHeaders(getObjectRequest.getHeaders());
        }
        return this.doOperation(request, new ResponseParsers.GetObjectResponseParser(bucketName, key), bucketName, key, true);
    }

    public ObjectMetadata getObject(GetObjectRequest getObjectRequest, File file) throws OSSException, ClientException {
        ObjectMetadata objectMetadata;
        CodingUtils.assertParameterNotNull(file, "file");
        OSSObject ossObject = this.getObject(getObjectRequest);
        BufferedOutputStream outputStream = null;
        try {
            int bytesRead;
            outputStream = new BufferedOutputStream(new FileOutputStream(file));
            byte[] buffer = new byte[8192];
            while ((bytesRead = ossObject.getObjectContent().read(buffer)) != -1) {
                ((OutputStream)outputStream).write(buffer, 0, bytesRead);
            }
            objectMetadata = ossObject.getObjectMetadata();
        }
        catch (IOException e) {
            try {
                throw new ClientException(OSSUtils.OSS_RESOURCE_MANAGER.getString("CannotReadContentStream"), e);
            }
            catch (Throwable throwable) {
                IOUtils.safeClose(outputStream);
                IOUtils.safeClose(ossObject.getObjectContent());
                throw throwable;
            }
        }
        IOUtils.safeClose(outputStream);
        IOUtils.safeClose(ossObject.getObjectContent());
        return objectMetadata;
    }

    public ObjectMetadata getObjectMetadata(String bucketName, String key) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        CodingUtils.assertParameterNotNull(key, "key");
        OSSUtils.ensureBucketNameValid(bucketName);
        OSSUtils.ensureObjectKeyValid(key);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.HEAD).setBucket(bucketName).setKey(key).build();
        ArrayList<ResponseHandler> reponseHandlers = new ArrayList<ResponseHandler>();
        reponseHandlers.add(new ResponseHandler(){

            @Override
            public void handle(ResponseMessage response) throws ServiceException, ClientException {
                if (response.getStatusCode() == 404) {
                    OSSUtils.safeCloseResponse(response);
                    throw ExceptionFactory.createOSSException(response.getHeaders().get("x-oss-request-id"), "NoSuchKey", OSSUtils.OSS_RESOURCE_MANAGER.getString("NoSuchKey"));
                }
            }
        });
        return this.doOperation(request, ResponseParsers.getObjectMetadataResponseParser, bucketName, key, true, null, reponseHandlers);
    }

    public CopyObjectResult copyObject(CopyObjectRequest copyObjectRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(copyObjectRequest, "copyObjectRequest");
        HashMap<String, String> headers = new HashMap<String, String>();
        OSSObjectOperation.populateCopyObjectHeaders(copyObjectRequest, headers);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.PUT).setBucket(copyObjectRequest.getDestinationBucketName()).setKey(copyObjectRequest.getDestinationKey()).setHeaders(headers).build();
        return this.doOperation(request, ResponseParsers.copyObjectResponseParser, copyObjectRequest.getDestinationBucketName(), copyObjectRequest.getDestinationKey(), true);
    }

    public void deleteObject(String bucketName, String key) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        CodingUtils.assertParameterNotNull(key, "key");
        OSSUtils.ensureObjectKeyValid(key);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.DELETE).setBucket(bucketName).setKey(key).build();
        this.doOperation(request, emptyResponseParser, bucketName, key);
    }

    public DeleteObjectsResult deleteObjects(DeleteObjectsRequest deleteObjectsRequest) {
        CodingUtils.assertParameterNotNull(deleteObjectsRequest, "deleteObjectsRequest");
        String bucketName = deleteObjectsRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("delete", null);
        byte[] rawContent = RequestMarshallers.deleteObjectsRequestMarshaller.marshall(deleteObjectsRequest);
        HashMap<String, String> headers = new HashMap<String, String>();
        OSSObjectOperation.addDeleteObjectsRequiredHeaders(headers, rawContent);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.POST).setBucket(bucketName).setParameters(params).setHeaders(headers).setInputSize(rawContent.length).setInputStream(new ByteArrayInputStream(rawContent)).build();
        return this.doOperation(request, ResponseParsers.deleteObjectsResponseParser, bucketName, null, true);
    }

    public void headObject(HeadObjectRequest headObjectRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(headObjectRequest, "headObjectRequest");
        String bucketName = headObjectRequest.getBucketName();
        String key = headObjectRequest.getKey();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        CodingUtils.assertParameterNotNull(key, "key");
        OSSUtils.ensureObjectKeyValid(key);
        HashMap<String, String> headers = new HashMap<String, String>();
        OSSUtils.addDateHeader(headers, "If-Modified-Since", headObjectRequest.getModifiedSinceConstraint());
        OSSUtils.addDateHeader(headers, "If-Unmodified-Since", headObjectRequest.getUnmodifiedSinceConstraint());
        OSSUtils.addStringListHeader(headers, "If-Match", headObjectRequest.getMatchingETagConstraints());
        OSSUtils.addStringListHeader(headers, "If-None-Match", headObjectRequest.getNonmatchingETagConstraints());
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.HEAD).setBucket(bucketName).setKey(key).setHeaders(headers).build();
        this.doOperation(request, emptyResponseParser, bucketName, key);
    }

    private static void populateCopyObjectHeaders(CopyObjectRequest copyObjectRequest, Map<String, String> headers) {
        String copySourceHeader = "/" + copyObjectRequest.getSourceBucketName() + "/" + HttpUtil.urlEncode(copyObjectRequest.getSourceKey(), "utf-8");
        headers.put("x-oss-copy-source", copySourceHeader);
        OSSUtils.addDateHeader(headers, "x-oss-copy-source-if-modified-since", copyObjectRequest.getModifiedSinceConstraint());
        OSSUtils.addDateHeader(headers, "x-oss-copy-source-if-unmodified-since", copyObjectRequest.getUnmodifiedSinceConstraint());
        OSSUtils.addStringListHeader(headers, "x-oss-copy-source-if-match", copyObjectRequest.getMatchingETagConstraints());
        OSSUtils.addStringListHeader(headers, "x-oss-copy-source-if-none-match", copyObjectRequest.getNonmatchingEtagConstraints());
        OSSUtils.addHeader(headers, "x-oss-server-side-encryption", copyObjectRequest.getServerSideEncryption());
        ObjectMetadata newObjectMetadata = copyObjectRequest.getNewObjectMetadata();
        if (newObjectMetadata != null) {
            headers.put("x-oss-metadata-directive", MetadataDirective.REPLACE.toString());
            OSSUtils.populateRequestMetadata(headers, newObjectMetadata);
        }
        OSSUtils.removeHeader(headers, "Content-Length");
    }

    private static void populateGetObjectRequestHeaders(GetObjectRequest getObjectRequest, Map<String, String> headers) {
        if (getObjectRequest.getRange() != null) {
            OSSObjectOperation.addGetObjectRangeHeader(getObjectRequest.getRange(), headers);
        }
        if (getObjectRequest.getModifiedSinceConstraint() != null) {
            headers.put("If-Modified-Since", DateUtil.formatRfc822Date(getObjectRequest.getModifiedSinceConstraint()));
        }
        if (getObjectRequest.getUnmodifiedSinceConstraint() != null) {
            headers.put("If-Unmodified-Since", DateUtil.formatRfc822Date(getObjectRequest.getUnmodifiedSinceConstraint()));
        }
        if (getObjectRequest.getMatchingETagConstraints().size() > 0) {
            headers.put("If-Match", OSSUtils.joinETags(getObjectRequest.getMatchingETagConstraints()));
        }
        if (getObjectRequest.getNonmatchingETagConstraints().size() > 0) {
            headers.put("If-None-Match", OSSUtils.joinETags(getObjectRequest.getNonmatchingETagConstraints()));
        }
        headers.putAll(getObjectRequest.getHeaders());
    }

    private static void addDeleteObjectsRequiredHeaders(Map<String, String> headers, byte[] rawContent) {
        headers.put("Content-Length", String.valueOf(rawContent.length));
        byte[] md5 = BinaryUtil.calculateMd5(rawContent);
        String md5Base64 = BinaryUtil.toBase64String(md5);
        headers.put("Content-MD5", md5Base64);
    }

    private static void addGetObjectRangeHeader(long[] range, Map<String, String> headers) {
        RangeSpec rangeSpec = RangeSpec.parse(range);
        headers.put("Range", rangeSpec.toString());
    }

    private static enum MetadataDirective {
        COPY("COPY"),
        REPLACE("REPLACE");

        private final String directive;

        private MetadataDirective(String directive) {
            this.directive = directive;
        }

        public String toString() {
            return this.directive;
        }
    }
}

