/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.common.comm;

import com.aliyun.oss.ClientException;
import com.aliyun.oss.common.comm.HttpMesssage;
import com.aliyun.oss.common.comm.ServiceClient;
import com.aliyun.oss.common.utils.ResourceManager;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class ResponseMessage
extends HttpMesssage {
    private static final int HTTP_SUCCESS_STATUS_CODE = 200;
    private static ResourceManager rm = ResourceManager.getInstance("common");
    private String uri;
    private int statusCode;
    private ServiceClient.Request request;

    public ResponseMessage(ServiceClient.Request request) {
        this.request = request;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUrl(String uri) {
        this.uri = uri;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    public String getRequestId() {
        return this.getHeaders().get("x-oss-request-id");
    }

    public ServiceClient.Request getRequest() {
        return this.request;
    }

    public boolean isSuccessful() {
        return this.statusCode / 100 == 2;
    }

    public String getDebugInfo() throws ClientException {
        String debugInfo = "Response Header:\n" + this.getHeaders().toString() + "\nResponse Content:\n";
        InputStream inStream = this.getContent();
        if (inStream == null) {
            return debugInfo;
        }
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        int len = -1;
        try {
            while ((len = inStream.read(buffer)) != -1) {
                outStream.write(buffer, 0, len);
            }
            outStream.flush();
            debugInfo = debugInfo + outStream.toString("utf-8");
            this.setContent(new ByteArrayInputStream(outStream.toByteArray()));
            return debugInfo;
        }
        catch (IOException e) {
            throw new ClientException(this.getRequestId(), "InvalidResponse", rm.getFormattedString("FailedToParseResponse", e.getMessage()), e);
        }
    }
}

