/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.data.remoting.sessionserver.forward;

import com.alipay.remoting.exception.RemotingException;
import com.alipay.sofa.registry.common.model.store.URL;
import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import com.alipay.sofa.registry.net.NetUtil;
import com.alipay.sofa.registry.remoting.exchange.message.Request;
import com.alipay.sofa.registry.server.data.bootstrap.DataServerConfig;
import com.alipay.sofa.registry.server.data.node.DataNodeStatus;
import com.alipay.sofa.registry.server.data.node.DataServerNode;
import com.alipay.sofa.registry.server.data.remoting.DataNodeExchanger;
import com.alipay.sofa.registry.server.data.remoting.dataserver.DataServerNodeFactory;
import com.alipay.sofa.registry.server.data.remoting.sessionserver.forward.ForwardService;
import com.alipay.sofa.registry.server.data.util.LocalServerStatusEnum;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public class ForwardServiceImpl
implements ForwardService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ForwardServiceImpl.class);
    @Autowired
    private DataServerConfig dataServerBootstrapConfig;
    @Autowired
    private DataNodeStatus dataNodeStatus;
    @Autowired
    private DataNodeExchanger dataNodeExchanger;

    @Override
    public boolean needForward(String dataInfoId) {
        return this.dataNodeStatus.getStatus() != LocalServerStatusEnum.WORKING;
    }

    @Override
    public Object forwardRequest(String dataInfoId, final Object request) throws RemotingException {
        try {
            List<DataServerNode> dataServerNodes = DataServerNodeFactory.computeDataServerNodes(this.dataServerBootstrapConfig.getLocalDataCenter(), dataInfoId, this.dataServerBootstrapConfig.getStoreNodes());
            if (null == dataServerNodes || dataServerNodes.size() <= 0) {
                throw new RuntimeException("No available server to forward");
            }
            boolean next = false;
            String localIp = NetUtil.getLocalAddress().getHostAddress();
            DataServerNode nextNode = null;
            for (DataServerNode dataServerNode : dataServerNodes) {
                if (next) {
                    nextNode = dataServerNode;
                    break;
                }
                if (null == localIp || !localIp.equals(dataServerNode.getIp())) continue;
                next = true;
            }
            if (null == nextNode || null == nextNode.getConnection()) {
                throw new RuntimeException("No available connection to forward");
            }
            LOGGER.info("[forward] target: {}, dataInfoId: {}, request: {}, allNodes: {}", new Object[]{nextNode.getIp(), dataInfoId, request, dataServerNodes});
            final DataServerNode finalNextNode = nextNode;
            return this.dataNodeExchanger.request(new Request(){

                public Object getRequestBody() {
                    return request;
                }

                public URL getRequestUrl() {
                    return new URL(finalNextNode.getConnection().getRemoteIP(), finalNextNode.getConnection().getRemotePort());
                }
            }).getResult();
        }
        catch (Exception e) {
            throw new RemotingException("ForwardServiceImpl forwardRequest error", (Throwable)e);
        }
    }
}

