/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson;

import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONStreamContext;
import com.alibaba.fastjson.JSONStreamState;
import com.alibaba.fastjson.serializer.JSONSerializer;
import com.alibaba.fastjson.serializer.SerializeWriter;
import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.Writer;

public class JSONWriter
implements Closeable,
Flushable {
    private SerializeWriter writer;
    private JSONSerializer serializer;
    private JSONStreamContext context;

    public JSONWriter(Writer out) {
        this.writer = new SerializeWriter(out);
        this.serializer = new JSONSerializer(this.writer);
    }

    public void startObject() {
        if (this.context != null) {
            this.beginStructure();
        }
        this.context = new JSONStreamContext(this.context, JSONStreamState.BeginObject);
        this.writer.write('{');
    }

    public void endObject() {
        this.writer.write('}');
        this.endStructure();
    }

    public void writeKey(String key) {
        if (this.context.getState() == JSONStreamState.PropertyValue) {
            this.writer.write(',');
        }
        this.writer.writeString(key);
        this.context.setState(JSONStreamState.PropertyKey);
    }

    public void writeValue(Object object) {
        switch (this.context.getState()) {
            case PropertyKey: {
                this.writer.write(':');
                break;
            }
            case ArrayValue: {
                this.writer.write(',');
                break;
            }
        }
        this.serializer.write(object);
        this.context.setState(JSONStreamState.PropertyValue);
    }

    public void startArray() {
        if (this.context != null) {
            this.beginStructure();
        }
        this.context = new JSONStreamContext(this.context, JSONStreamState.BeginArray);
        this.writer.write('[');
    }

    private void beginStructure() {
        JSONStreamState state = this.context.getState();
        switch (state) {
            case PropertyKey: {
                this.writer.write(':');
                break;
            }
            case ArrayValue: {
                this.writer.write(',');
                break;
            }
            case BeginObject: {
                break;
            }
            case BeginArray: {
                break;
            }
            default: {
                throw new JSONException("illegal state : " + (Object)((Object)state));
            }
        }
    }

    public void endArray() {
        this.writer.write(']');
        this.endStructure();
    }

    private void endStructure() {
        this.context = this.context.getParent();
        if (this.context != null) {
            JSONStreamState state = this.context.getState();
            JSONStreamState newState = null;
            switch (state) {
                case PropertyKey: {
                    newState = JSONStreamState.PropertyValue;
                    break;
                }
                case BeginArray: {
                    newState = JSONStreamState.ArrayValue;
                    break;
                }
                case ArrayValue: {
                    break;
                }
            }
            if (newState != null) {
                this.context.setState(newState);
            }
        }
    }

    public void flush() throws IOException {
        this.writer.flush();
    }

    public void close() throws IOException {
        this.writer.close();
    }

    @Deprecated
    public void writeStartObject() {
        this.startObject();
    }

    @Deprecated
    public void writeEndObject() {
        this.endObject();
    }

    @Deprecated
    public void writeStartArray() {
        this.startArray();
    }

    @Deprecated
    public void writeEndArray() {
        this.endArray();
    }
}

