/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.rpc.protocol.dubbo;

import com.alibaba.dubbo.common.io.UnsafeByteArrayInputStream;
import com.alibaba.dubbo.remoting.Channel;
import com.alibaba.dubbo.remoting.Codec;
import com.alibaba.dubbo.remoting.exchange.Request;
import com.alibaba.dubbo.remoting.exchange.Response;
import com.alibaba.dubbo.remoting.exchange.support.MultiMessage;
import com.alibaba.dubbo.rpc.RpcInvocation;
import com.alibaba.dubbo.rpc.RpcResult;
import com.alibaba.dubbo.rpc.protocol.dubbo.DubboCodec;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class DubboCountCodec
implements Codec {
    private DubboCodec codec = new DubboCodec();

    public void encode(Channel channel, OutputStream output, Object msg) throws IOException {
        this.codec.encode(channel, output, msg);
    }

    public Object decode(Channel channel, InputStream input) throws IOException {
        UnsafeByteArrayInputStream bis = (UnsafeByteArrayInputStream)input;
        int save = bis.position();
        MultiMessage result = MultiMessage.create();
        while (true) {
            Object obj;
            if (NEED_MORE_INPUT == (obj = this.codec.decode(channel, bis))) break;
            result.addMessage(obj);
            this.logMessageLength(obj, bis.position() - save);
            save = bis.position();
        }
        bis.position(save);
        if (result.isEmpty()) {
            return NEED_MORE_INPUT;
        }
        if (result.size() == 1) {
            return result.get(0);
        }
        return result;
    }

    private void logMessageLength(Object result, int bytes) {
        if (bytes <= 0) {
            return;
        }
        if (result instanceof Request) {
            try {
                ((RpcInvocation)((Request)result).getData()).setAttachment("input", String.valueOf(bytes));
            }
            catch (Throwable e) {}
        } else if (result instanceof Response) {
            try {
                ((RpcResult)((Response)result).getResult()).setAttachment("output", String.valueOf(bytes));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

