/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.remoting.transport.mina;

import com.alibaba.dubbo.common.URL;
import com.alibaba.dubbo.common.io.Bytes;
import com.alibaba.dubbo.common.io.UnsafeByteArrayInputStream;
import com.alibaba.dubbo.common.io.UnsafeByteArrayOutputStream;
import com.alibaba.dubbo.remoting.ChannelHandler;
import com.alibaba.dubbo.remoting.Codec;
import com.alibaba.dubbo.remoting.transport.mina.MinaChannel;
import java.io.IOException;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.IoSession;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolDecoder;
import org.apache.mina.filter.codec.ProtocolDecoderOutput;
import org.apache.mina.filter.codec.ProtocolEncoder;
import org.apache.mina.filter.codec.ProtocolEncoderOutput;

final class MinaCodecAdapter
implements ProtocolCodecFactory {
    private static final String BUFFER_KEY = MinaCodecAdapter.class.getName() + ".BUFFER";
    private final ProtocolEncoder encoder = new InternalEncoder();
    private final ProtocolDecoder decoder = new InternalDecoder();
    private final Codec codec;
    private final URL url;
    private final ChannelHandler handler;
    private final int bufferSize;

    public MinaCodecAdapter(Codec codec, URL url, ChannelHandler handler) {
        this.codec = codec;
        this.url = url;
        this.handler = handler;
        int b = url.getPositiveParameter("buffer", 8192);
        this.bufferSize = b >= 1024 && b <= 16384 ? b : 8192;
    }

    public ProtocolEncoder getEncoder() {
        return this.encoder;
    }

    public ProtocolDecoder getDecoder() {
        return this.decoder;
    }

    private class InternalDecoder
    implements ProtocolDecoder {
        private InternalDecoder() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void decode(IoSession session, ByteBuffer in, ProtocolDecoderOutput out) throws Exception {
            block18: {
                block17: {
                    int off;
                    int limit;
                    byte[] buf;
                    int readable = in.limit();
                    if (readable <= 0) {
                        return;
                    }
                    Object[] tmp = (Object[])session.getAttribute(BUFFER_KEY);
                    if (tmp == null) {
                        buf = new byte[MinaCodecAdapter.this.bufferSize];
                        limit = 0;
                        off = 0;
                    } else {
                        buf = (byte[])tmp[0];
                        off = (Integer)tmp[1];
                        limit = (Integer)tmp[2];
                    }
                    MinaChannel channel = MinaChannel.getOrAddChannel(session, MinaCodecAdapter.this.url, MinaCodecAdapter.this.handler);
                    boolean remaining = true;
                    try {
                        block4: do {
                            int read = Math.min(readable, buf.length - limit);
                            in.get(buf, limit, read);
                            readable -= read;
                            UnsafeByteArrayInputStream bis = new UnsafeByteArrayInputStream(buf, off, (limit += read) - off);
                            do {
                                Object msg;
                                try {
                                    msg = MinaCodecAdapter.this.codec.decode(channel, bis);
                                }
                                catch (IOException e) {
                                    remaining = false;
                                    throw e;
                                }
                                if (msg == Codec.NEED_MORE_INPUT) {
                                    if (off == 0) {
                                        if (readable <= 0) continue block4;
                                        buf = Bytes.copyOf(buf, buf.length << 1);
                                        continue block4;
                                    }
                                    int len = limit - off;
                                    System.arraycopy(buf, off, buf, 0, len);
                                    off = 0;
                                    limit = len;
                                    continue block4;
                                }
                                int pos = bis.position();
                                if (pos == off) {
                                    remaining = false;
                                    throw new IOException("Decode without read data.");
                                }
                                if (msg != null) {
                                    out.write(msg);
                                }
                                off = pos;
                            } while (bis.available() > 0);
                        } while (readable > 0);
                        Object var16_16 = null;
                        if (!remaining) break block17;
                    }
                    catch (Throwable throwable) {
                        Object var16_17 = null;
                        if (remaining) {
                            int len = limit - off;
                            if (len < buf.length / 2) {
                                System.arraycopy(buf, off, buf, 0, len);
                                off = 0;
                                limit = len;
                            }
                            session.setAttribute(BUFFER_KEY, (Object)new Object[]{buf, off, limit});
                        } else {
                            session.removeAttribute(BUFFER_KEY);
                        }
                        MinaChannel.removeChannelIfDisconnectd(session);
                        throw throwable;
                    }
                    int len = limit - off;
                    if (len < buf.length / 2) {
                        System.arraycopy(buf, off, buf, 0, len);
                        off = 0;
                        limit = len;
                    }
                    session.setAttribute(BUFFER_KEY, (Object)new Object[]{buf, off, limit});
                    break block18;
                }
                session.removeAttribute(BUFFER_KEY);
            }
            MinaChannel.removeChannelIfDisconnectd(session);
        }

        public void dispose(IoSession session) throws Exception {
        }

        public void finishDecode(IoSession session, ProtocolDecoderOutput out) throws Exception {
        }
    }

    private class InternalEncoder
    implements ProtocolEncoder {
        private InternalEncoder() {
        }

        public void dispose(IoSession session) throws Exception {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void encode(IoSession session, Object msg, ProtocolEncoderOutput out) throws Exception {
            UnsafeByteArrayOutputStream os = new UnsafeByteArrayOutputStream(1024);
            MinaChannel channel = MinaChannel.getOrAddChannel(session, MinaCodecAdapter.this.url, MinaCodecAdapter.this.handler);
            try {
                MinaCodecAdapter.this.codec.encode(channel, os, msg);
                Object var7_6 = null;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                MinaChannel.removeChannelIfDisconnectd(session);
                throw throwable;
            }
            MinaChannel.removeChannelIfDisconnectd(session);
            out.write(ByteBuffer.wrap((byte[])os.toByteArray()));
            out.flush();
        }
    }
}

