/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.oracle.parser;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLPartition;
import com.alibaba.druid.sql.ast.SQLPartitionBy;
import com.alibaba.druid.sql.ast.SQLPartitionByHash;
import com.alibaba.druid.sql.ast.SQLPartitionByList;
import com.alibaba.druid.sql.ast.SQLPartitionByRange;
import com.alibaba.druid.sql.ast.SQLSubPartition;
import com.alibaba.druid.sql.ast.SQLSubPartitionBy;
import com.alibaba.druid.sql.ast.SQLSubPartitionByHash;
import com.alibaba.druid.sql.ast.SQLSubPartitionByList;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLIntegerExpr;
import com.alibaba.druid.sql.ast.expr.SQLNumericLiteralExpr;
import com.alibaba.druid.sql.ast.statement.SQLCreateTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.dialect.oracle.ast.clause.OracleLobStorageClause;
import com.alibaba.druid.sql.dialect.oracle.ast.clause.OracleStorageClause;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleCreateTableStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleSupplementalIdKey;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleSupplementalLogGrp;
import com.alibaba.druid.sql.dialect.oracle.parser.OracleExprParser;
import com.alibaba.druid.sql.dialect.oracle.parser.OracleSelectParser;
import com.alibaba.druid.sql.parser.Lexer;
import com.alibaba.druid.sql.parser.ParserException;
import com.alibaba.druid.sql.parser.SQLCreateTableParser;
import com.alibaba.druid.sql.parser.Token;

public class OracleCreateTableParser
extends SQLCreateTableParser {
    public OracleCreateTableParser(Lexer lexer) {
        super(new OracleExprParser(lexer));
    }

    public OracleCreateTableParser(String sql) {
        super(new OracleExprParser(sql));
    }

    @Override
    protected OracleCreateTableStatement newCreateStatement() {
        return new OracleCreateTableStatement();
    }

    @Override
    public OracleCreateTableStatement parseCrateTable(boolean acceptCreate) {
        OracleCreateTableStatement stmt;
        block28: {
            stmt = (OracleCreateTableStatement)super.parseCrateTable(acceptCreate);
            if (this.lexer.token() == Token.OF) {
                this.lexer.nextToken();
                stmt.setOf(this.exprParser.name());
                if (this.identifierEquals("OIDINDEX")) {
                    this.lexer.nextToken();
                    OracleCreateTableStatement.OIDIndex oidIndex = new OracleCreateTableStatement.OIDIndex();
                    if (this.lexer.token() != Token.LPAREN) {
                        oidIndex.setName(this.exprParser.name());
                    }
                    this.accept(Token.LPAREN);
                    this.getExprParser().parseSegmentAttributes(oidIndex);
                    this.accept(Token.RPAREN);
                    stmt.setOidIndex(oidIndex);
                }
            }
            while (true) {
                this.getExprParser().parseSegmentAttributes(stmt);
                if (this.identifierEquals("IN_MEMORY_METADATA")) {
                    this.lexer.nextToken();
                    stmt.setInMemoryMetadata(true);
                    continue;
                }
                if (this.identifierEquals("CURSOR_SPECIFIC_SEGMENT")) {
                    this.lexer.nextToken();
                    stmt.setCursorSpecificSegment(true);
                    continue;
                }
                if (this.identifierEquals("NOPARALLEL")) {
                    this.lexer.nextToken();
                    stmt.setParallel(false);
                    continue;
                }
                if (this.lexer.token() == Token.CACHE) {
                    this.lexer.nextToken();
                    stmt.setCache(Boolean.TRUE);
                    continue;
                }
                if (this.lexer.token() == Token.NOCACHE) {
                    this.lexer.nextToken();
                    stmt.setCache(Boolean.FALSE);
                    continue;
                }
                if (this.lexer.token() == Token.ENABLE) {
                    this.lexer.nextToken();
                    if (this.lexer.token() == Token.ROW) {
                        this.lexer.nextToken();
                        this.acceptIdentifier("MOVEMENT");
                        stmt.setEnableRowMovement(Boolean.TRUE);
                        continue;
                    }
                    throw new ParserException("TODO : " + this.lexer.info());
                }
                if (this.lexer.token() == Token.DISABLE) {
                    this.lexer.nextToken();
                    if (this.lexer.token() == Token.ROW) {
                        this.lexer.nextToken();
                        this.acceptIdentifier("MOVEMENT");
                        stmt.setEnableRowMovement(Boolean.FALSE);
                        continue;
                    }
                    throw new ParserException("TODO : " + this.lexer.info());
                }
                if (this.lexer.token() == Token.ON) {
                    this.lexer.nextToken();
                    this.accept(Token.COMMIT);
                    stmt.setOnCommit(true);
                    continue;
                }
                if (this.identifierEquals("PRESERVE")) {
                    this.lexer.nextToken();
                    this.acceptIdentifier("ROWS");
                    stmt.setPreserveRows(true);
                    continue;
                }
                if (this.identifierEquals("STORAGE")) {
                    OracleStorageClause storage = ((OracleExprParser)this.exprParser).parseStorage();
                    stmt.setStorage(storage);
                    continue;
                }
                if (this.identifierEquals("ORGANIZATION")) {
                    this.parseOrganization(stmt);
                    continue;
                }
                if (this.identifierEquals("CLUSTER")) {
                    this.lexer.nextToken();
                    SQLName cluster = this.exprParser.name();
                    stmt.setCluster(cluster);
                    this.accept(Token.LPAREN);
                    this.exprParser.names(stmt.getClusterColumns(), cluster);
                    this.accept(Token.RPAREN);
                    continue;
                }
                if (this.lexer.token() == Token.LOB) {
                    OracleLobStorageClause lobStorage = ((OracleExprParser)this.exprParser).parseLobStorage();
                    stmt.setLobStorage(lobStorage);
                    continue;
                }
                if (this.lexer.token() == Token.SEGMENT) {
                    this.lexer.nextToken();
                    this.accept(Token.CREATION);
                    if (this.lexer.token() == Token.IMMEDIATE) {
                        this.lexer.nextToken();
                        stmt.setDeferredSegmentCreation(OracleCreateTableStatement.DeferredSegmentCreation.IMMEDIATE);
                        continue;
                    }
                    this.accept(Token.DEFERRED);
                    stmt.setDeferredSegmentCreation(OracleCreateTableStatement.DeferredSegmentCreation.DEFERRED);
                    continue;
                }
                if (this.lexer.token() != Token.PARTITION) break block28;
                this.lexer.nextToken();
                this.accept(Token.BY);
                if (this.identifierEquals("RANGE")) {
                    SQLPartitionByRange partitionByRange = this.partitionByRange();
                    this.partitionClauseRest(partitionByRange);
                    stmt.setPartitioning(partitionByRange);
                    continue;
                }
                if (this.identifierEquals("HASH")) {
                    SQLPartitionByHash partitionByHash = this.partitionByHash();
                    this.partitionClauseRest(partitionByHash);
                    if (this.lexer.token() == Token.LPAREN) {
                        this.lexer.nextToken();
                        while (true) {
                            SQLPartition partition = this.getExprParser().parsePartition();
                            partitionByHash.addPartition(partition);
                            if (this.lexer.token() != Token.COMMA) break;
                            this.lexer.nextToken();
                        }
                        if (this.lexer.token() == Token.RPAREN) {
                            this.lexer.nextToken();
                        } else {
                            throw new ParserException("TODO : " + (Object)((Object)this.lexer.token()) + " " + this.lexer.stringVal());
                        }
                    }
                    stmt.setPartitioning(partitionByHash);
                    continue;
                }
                if (!this.identifierEquals("LIST")) break;
                SQLPartitionByList partitionByList = this.partitionByList();
                this.partitionClauseRest(partitionByList);
                stmt.setPartitioning(partitionByList);
            }
            throw new ParserException("TODO : " + (Object)((Object)this.lexer.token()) + " " + this.lexer.stringVal());
        }
        if (this.lexer.token() == Token.AS) {
            this.lexer.nextToken();
            SQLSelect select = new OracleSelectParser(this.exprParser).select();
            stmt.setSelect(select);
        }
        return stmt;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parseOrganization(OracleCreateTableStatement stmt) {
        OracleCreateTableStatement.Organization organization = new OracleCreateTableStatement.Organization();
        this.acceptIdentifier("ORGANIZATION");
        if (this.lexer.token() == Token.INDEX) {
            this.lexer.nextToken();
            organization.setType("INDEX");
            this.getExprParser().parseSegmentAttributes(organization);
            if (this.identifierEquals("PCTTHRESHOLD")) {
                this.lexer.nextToken();
                if (this.lexer.token() == Token.LITERAL_INT) {
                    int pctthreshold = ((SQLNumericLiteralExpr)this.exprParser.primary()).getNumber().intValue();
                    organization.setPctthreshold(pctthreshold);
                }
            }
        } else if (this.identifierEquals("HEAP")) {
            this.lexer.nextToken();
            organization.setType("HEAP");
            this.getExprParser().parseSegmentAttributes(organization);
        } else {
            if (!this.identifierEquals("EXTERNAL")) throw new ParserException("TODO " + this.lexer.info());
            this.lexer.nextToken();
            organization.setType("EXTERNAL");
            this.accept(Token.LPAREN);
            if (this.identifierEquals("TYPE")) {
                this.lexer.nextToken();
                organization.setExternalType(this.exprParser.name());
            }
            this.accept(Token.DEFAULT);
            this.acceptIdentifier("DIRECTORY");
            organization.setExternalDirectory(this.exprParser.expr());
            if (this.identifierEquals("ACCESS")) {
                this.lexer.nextToken();
                this.acceptIdentifier("PARAMETERS");
                if (this.lexer.token() == Token.LPAREN) {
                    this.lexer.nextToken();
                    OracleCreateTableStatement.OracleExternalRecordFormat recordFormat = new OracleCreateTableStatement.OracleExternalRecordFormat();
                    if (this.identifierEquals("RECORDS")) {
                        this.lexer.nextToken();
                        if (!this.identifierEquals("DELIMITED")) throw new ParserException("TODO " + this.lexer.info());
                        this.lexer.nextToken();
                        this.accept(Token.BY);
                        if (!this.identifierEquals("NEWLINE")) throw new ParserException("TODO " + this.lexer.info());
                        this.lexer.nextToken();
                        recordFormat.setDelimitedBy(new SQLIdentifierExpr("NEWLINE"));
                    }
                    if (this.identifierEquals("FIELDS")) {
                        this.lexer.nextToken();
                        if (!this.identifierEquals("TERMINATED")) throw new ParserException("TODO " + this.lexer.info());
                        this.lexer.nextToken();
                        this.accept(Token.BY);
                        recordFormat.setTerminatedBy(this.exprParser.primary());
                    }
                    organization.setExternalDirectoryRecordFormat(recordFormat);
                    this.accept(Token.RPAREN);
                } else if (this.lexer.token() == Token.USING) {
                    this.lexer.nextToken();
                    this.acceptIdentifier("CLOB");
                    throw new ParserException("TODO " + this.lexer.info());
                }
            }
            this.acceptIdentifier("LOCATION");
            this.accept(Token.LPAREN);
            this.exprParser.exprList(organization.getExternalDirectoryLocation(), organization);
            this.accept(Token.RPAREN);
            this.accept(Token.RPAREN);
            if (this.lexer.token() == Token.REJECT) {
                this.lexer.nextToken();
                this.accept(Token.LIMIT);
                organization.setExternalRejectLimit(this.exprParser.primary());
            }
        }
        stmt.setOrganization(organization);
    }

    protected SQLPartitionByList partitionByList() {
        this.acceptIdentifier("LIST");
        SQLPartitionByList partitionByList = new SQLPartitionByList();
        this.accept(Token.LPAREN);
        partitionByList.setExpr(this.exprParser.expr());
        this.accept(Token.RPAREN);
        this.parsePartitionByRest(partitionByList);
        return partitionByList;
    }

    protected SQLPartitionByHash partitionByHash() {
        this.acceptIdentifier("HASH");
        SQLPartitionByHash partitionByHash = new SQLPartitionByHash();
        if (this.lexer.token() == Token.KEY) {
            this.lexer.nextToken();
            partitionByHash.setKey(true);
        }
        this.accept(Token.LPAREN);
        partitionByHash.setExpr(this.exprParser.expr());
        this.accept(Token.RPAREN);
        return partitionByHash;
    }

    protected SQLPartitionByRange partitionByRange() {
        this.acceptIdentifier("RANGE");
        this.accept(Token.LPAREN);
        SQLPartitionByRange clause = new SQLPartitionByRange();
        while (true) {
            SQLName column = this.exprParser.name();
            clause.addColumn(column);
            if (this.lexer.token() != Token.COMMA) break;
            this.lexer.nextToken();
        }
        this.accept(Token.RPAREN);
        if (this.lexer.token() == Token.INTERVAL) {
            this.lexer.nextToken();
            this.accept(Token.LPAREN);
            clause.setInterval(this.exprParser.expr());
            this.accept(Token.RPAREN);
        }
        this.parsePartitionByRest(clause);
        return clause;
    }

    protected void parsePartitionByRest(SQLPartitionBy clause) {
        if (this.lexer.token() == Token.STORE) {
            this.lexer.nextToken();
            this.accept(Token.IN);
            this.accept(Token.LPAREN);
            while (true) {
                SQLName tablespace = this.exprParser.name();
                clause.getStoreIn().add(tablespace);
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
            }
            this.accept(Token.RPAREN);
        }
        if (this.identifierEquals("SUBPARTITION")) {
            SQLSubPartitionBy subPartitionBy = this.subPartitionBy();
            clause.setSubPartitionBy(subPartitionBy);
        }
        this.accept(Token.LPAREN);
        while (true) {
            SQLPartition partition = this.getExprParser().parsePartition();
            clause.addPartition(partition);
            if (this.lexer.token() != Token.COMMA) break;
            this.lexer.nextToken();
        }
        this.accept(Token.RPAREN);
    }

    protected void partitionClauseRest(SQLPartitionBy clause) {
        if (this.identifierEquals("PARTITIONS")) {
            this.lexer.nextToken();
            SQLIntegerExpr countExpr = this.exprParser.integerExpr();
            clause.setPartitionsCount(countExpr);
        }
        if (this.lexer.token() == Token.STORE) {
            this.lexer.nextToken();
            this.accept(Token.IN);
            this.accept(Token.LPAREN);
            this.exprParser.names(clause.getStoreIn(), clause);
            this.accept(Token.RPAREN);
        }
    }

    protected SQLSubPartitionBy subPartitionBy() {
        this.lexer.nextToken();
        this.accept(Token.BY);
        if (this.identifierEquals("HASH")) {
            this.lexer.nextToken();
            this.accept(Token.LPAREN);
            SQLSubPartitionByHash byHash = new SQLSubPartitionByHash();
            SQLExpr expr = this.exprParser.expr();
            byHash.setExpr(expr);
            this.accept(Token.RPAREN);
            return byHash;
        }
        if (this.identifierEquals("LIST")) {
            this.lexer.nextToken();
            this.accept(Token.LPAREN);
            SQLSubPartitionByList byList = new SQLSubPartitionByList();
            SQLName column = this.exprParser.name();
            byList.setColumn(column);
            this.accept(Token.RPAREN);
            if (this.identifierEquals("SUBPARTITION")) {
                this.lexer.nextToken();
                this.acceptIdentifier("TEMPLATE");
                this.accept(Token.LPAREN);
                while (true) {
                    SQLSubPartition subPartition = this.getExprParser().parseSubPartition();
                    subPartition.setParent(byList);
                    byList.getSubPartitionTemplate().add(subPartition);
                    if (this.lexer.token() != Token.COMMA) break;
                    this.lexer.nextToken();
                }
                this.accept(Token.RPAREN);
            }
            return byList;
        }
        throw new ParserException("TODO : " + (Object)((Object)this.lexer.token()) + " " + this.lexer.stringVal());
    }

    @Override
    protected void parseCreateTableSupplementalLogingProps(SQLCreateTableStatement stmt) {
        this.acceptIdentifier("SUPPLEMENTAL");
        this.acceptIdentifier("LOG");
        if (this.lexer.token() == Token.GROUP) {
            this.lexer.nextToken();
            OracleSupplementalLogGrp logGrp = new OracleSupplementalLogGrp();
            logGrp.setGroup(this.exprParser.name());
            this.accept(Token.LPAREN);
            while (true) {
                SQLName column = this.exprParser.name();
                if (this.identifierEquals("NO")) {
                    this.lexer.nextToken();
                    this.acceptIdentifier("LOG");
                    column.putAttribute("NO LOG", Boolean.TRUE);
                }
                logGrp.addColumn(column);
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
            }
            if (this.lexer.token() != Token.RPAREN) {
                throw new ParserException("TODO " + this.lexer.info());
            }
            this.accept(Token.RPAREN);
            if (this.identifierEquals("ALWAYS")) {
                this.lexer.nextToken();
                logGrp.setAlways(true);
            }
            logGrp.setParent(stmt);
            stmt.getTableElementList().add(logGrp);
        } else {
            this.acceptIdentifier("DATA");
            OracleSupplementalIdKey idKey = new OracleSupplementalIdKey();
            this.accept(Token.LPAREN);
            while (true) {
                if (this.lexer.token() == Token.ALL) {
                    this.lexer.nextToken();
                    idKey.setAll(true);
                } else if (this.lexer.token() == Token.PRIMARY) {
                    this.lexer.nextToken();
                    this.accept(Token.KEY);
                    idKey.setPrimaryKey(true);
                } else if (this.lexer.token() == Token.UNIQUE) {
                    this.lexer.nextToken();
                    if (this.lexer.token() == Token.INDEX) {
                        this.lexer.nextToken();
                        idKey.setUniqueIndex(true);
                    } else {
                        idKey.setUnique(true);
                    }
                } else if (this.lexer.token() == Token.FOREIGN) {
                    this.lexer.nextToken();
                    this.accept(Token.KEY);
                    idKey.setForeignKey(true);
                }
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
            }
            if (this.lexer.token() != Token.RPAREN) {
                throw new ParserException("TODO " + this.lexer.info());
            }
            this.accept(Token.RPAREN);
            this.acceptIdentifier("COLUMNS");
            idKey.setParent(stmt);
            stmt.getTableElementList().add(idKey);
        }
    }

    @Override
    public OracleExprParser getExprParser() {
        return (OracleExprParser)this.exprParser;
    }
}

