/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.ast.expr;

import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLExprImpl;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.SQLReplaceable;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOperator;
import com.alibaba.druid.sql.ast.expr.SQLNullExpr;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import com.alibaba.druid.util.Utils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class SQLBinaryOpExpr
extends SQLExprImpl
implements SQLReplaceable,
Serializable {
    private static final long serialVersionUID = 1L;
    private SQLExpr left;
    private SQLExpr right;
    private SQLBinaryOperator operator;
    private String dbType;

    public SQLBinaryOpExpr() {
    }

    public SQLBinaryOpExpr(String dbType) {
        this.dbType = dbType;
    }

    public SQLBinaryOpExpr(SQLExpr left, SQLBinaryOperator operator, SQLExpr right) {
        this(left, operator, right, null);
    }

    public SQLBinaryOpExpr(SQLExpr left, SQLBinaryOperator operator, SQLExpr right, String dbType) {
        this.setLeft(left);
        this.setRight(right);
        this.operator = operator;
        this.dbType = dbType;
    }

    public SQLBinaryOpExpr(SQLExpr left, SQLExpr right, SQLBinaryOperator operator) {
        this.setLeft(left);
        this.setRight(right);
        this.operator = operator;
    }

    public String getDbType() {
        return this.dbType;
    }

    public void setDbType(String dbType) {
        this.dbType = dbType;
    }

    public SQLExpr getLeft() {
        return this.left;
    }

    public void setLeft(SQLExpr left) {
        if (left != null) {
            left.setParent(this);
        }
        this.left = left;
    }

    public SQLExpr getRight() {
        return this.right;
    }

    public void setRight(SQLExpr right) {
        if (right != null) {
            right.setParent(this);
        }
        this.right = right;
    }

    public SQLBinaryOperator getOperator() {
        return this.operator;
    }

    public void setOperator(SQLBinaryOperator operator) {
        this.operator = operator;
    }

    @Override
    protected void accept0(SQLASTVisitor visitor) {
        if (visitor.visit(this)) {
            this.acceptChild(visitor, this.left);
            this.acceptChild(visitor, this.right);
        }
        visitor.endVisit(this);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.left == null ? 0 : this.left.hashCode());
        result = 31 * result + (this.operator == null ? 0 : this.operator.hashCode());
        result = 31 * result + (this.right == null ? 0 : this.right.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SQLBinaryOpExpr)) {
            return false;
        }
        SQLBinaryOpExpr other = (SQLBinaryOpExpr)obj;
        if (this.left == null ? other.left != null : !this.left.equals(other.left)) {
            return false;
        }
        if (this.operator != other.operator) {
            return false;
        }
        return !(this.right == null ? other.right != null : !this.right.equals(other.right));
    }

    public boolean equalsIgoreOrder(SQLBinaryOpExpr other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.operator != other.operator) {
            return false;
        }
        return Utils.equals(this.left, other.left) && Utils.equals(this.right, other.right) || Utils.equals(this.left, other.right) && Utils.equals(this.right, other.left);
    }

    @Override
    public SQLBinaryOpExpr clone() {
        return new SQLBinaryOpExpr(this.left, this.operator, this.right, this.dbType);
    }

    @Override
    public String toString() {
        return SQLUtils.toSQLString(this, this.getDbType());
    }

    public static SQLExpr combine(List<? extends SQLExpr> items, SQLBinaryOperator op) {
        if (items == null || op == null) {
            return null;
        }
        int size = items.size();
        if (size == 0) {
            return null;
        }
        if (size == 1) {
            return items.get(0);
        }
        SQLBinaryOpExpr expr = new SQLBinaryOpExpr(items.get(0), op, items.get(1));
        for (int i = 2; i < size; ++i) {
            SQLExpr item = items.get(i);
            expr = new SQLBinaryOpExpr((SQLExpr)expr, op, item);
        }
        return expr;
    }

    public static List<SQLExpr> split(SQLBinaryOpExpr x) {
        return SQLBinaryOpExpr.split(x, x.getOperator());
    }

    public static List<SQLExpr> split(SQLBinaryOpExpr x, SQLBinaryOperator op) {
        if (x.getOperator() != op) {
            ArrayList<SQLExpr> groupList = new ArrayList<SQLExpr>(1);
            groupList.add(x);
            return groupList;
        }
        ArrayList<SQLExpr> groupList = new ArrayList<SQLExpr>();
        SQLBinaryOpExpr.split(groupList, x, op);
        return groupList;
    }

    public static void split(List<SQLExpr> outList, SQLExpr expr, SQLBinaryOperator op) {
        ArrayList<SQLExpr> rightList;
        block14: {
            if (expr == null) {
                return;
            }
            if (!(expr instanceof SQLBinaryOpExpr)) {
                outList.add(expr);
                return;
            }
            SQLBinaryOpExpr binaryExpr = (SQLBinaryOpExpr)expr;
            if (binaryExpr.getOperator() != op) {
                outList.add(binaryExpr);
                return;
            }
            rightList = new ArrayList<SQLExpr>();
            rightList.add(binaryExpr.getRight());
            SQLExpr left = binaryExpr.getLeft();
            while (left instanceof SQLBinaryOpExpr) {
                SQLBinaryOpExpr leftBinary = (SQLBinaryOpExpr)left;
                if (leftBinary.operator == op) {
                    left = leftBinary.getLeft();
                    rightList.add(leftBinary.getRight());
                    continue;
                }
                outList.add(leftBinary);
                break block14;
            }
            outList.add(left);
        }
        for (int i = rightList.size() - 1; i >= 0; --i) {
            SQLExpr right = (SQLExpr)rightList.get(i);
            if (right instanceof SQLBinaryOpExpr) {
                SQLBinaryOpExpr binaryRight = (SQLBinaryOpExpr)right;
                if (binaryRight.operator == op) {
                    SQLExpr rightLeft = binaryRight.getLeft();
                    if (rightLeft instanceof SQLBinaryOpExpr) {
                        SQLBinaryOpExpr rightLeftBinary = (SQLBinaryOpExpr)rightLeft;
                        if (rightLeftBinary.operator == op) {
                            SQLBinaryOpExpr.split(outList, rightLeftBinary, op);
                        } else {
                            outList.add(rightLeftBinary);
                        }
                    } else {
                        outList.add(rightLeft);
                    }
                    SQLExpr rightRight = binaryRight.getRight();
                    if (rightRight instanceof SQLBinaryOpExpr) {
                        SQLBinaryOpExpr rightRightBinary = (SQLBinaryOpExpr)rightRight;
                        if (rightRightBinary.operator == op) {
                            SQLBinaryOpExpr.split(outList, rightRightBinary, op);
                            continue;
                        }
                        outList.add(rightRightBinary);
                        continue;
                    }
                    outList.add(rightRight);
                    continue;
                }
                outList.add(binaryRight);
                continue;
            }
            outList.add(right);
        }
    }

    public static SQLExpr and(SQLExpr a, SQLExpr b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        if (b instanceof SQLBinaryOpExpr) {
            SQLBinaryOpExpr bb = (SQLBinaryOpExpr)b;
            if (bb.operator == SQLBinaryOperator.BooleanAnd) {
                return SQLBinaryOpExpr.and(SQLBinaryOpExpr.and(a, bb.left), bb.right);
            }
        }
        return new SQLBinaryOpExpr(a, SQLBinaryOperator.BooleanAnd, b);
    }

    public static SQLExpr andIfNotExists(SQLExpr a, SQLExpr b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        ArrayList<SQLExpr> groupListA = new ArrayList<SQLExpr>();
        ArrayList<SQLExpr> groupListB = new ArrayList<SQLExpr>();
        SQLBinaryOpExpr.split(groupListA, a, SQLBinaryOperator.BooleanAnd);
        SQLBinaryOpExpr.split(groupListB, a, SQLBinaryOperator.BooleanAnd);
        for (SQLExpr itemB : groupListB) {
            boolean exist = false;
            for (SQLExpr itemA : groupListA) {
                if (itemA.equals(itemB)) {
                    exist = true;
                    continue;
                }
                if (!(itemA instanceof SQLBinaryOpExpr) || !(itemB instanceof SQLBinaryOpExpr) || !((SQLBinaryOpExpr)itemA).equalsIgoreOrder((SQLBinaryOpExpr)itemB)) continue;
                exist = true;
            }
            if (exist) continue;
            groupListA.add(itemB);
        }
        return SQLBinaryOpExpr.combine(groupListA, SQLBinaryOperator.BooleanAnd);
    }

    public static SQLBinaryOpExpr isNotNull(SQLExpr expr) {
        return new SQLBinaryOpExpr(expr, SQLBinaryOperator.IsNot, new SQLNullExpr());
    }

    public static SQLBinaryOpExpr isNull(SQLExpr expr) {
        return new SQLBinaryOpExpr(expr, SQLBinaryOperator.Is, new SQLNullExpr());
    }

    @Override
    public boolean replace(SQLExpr expr, SQLExpr taget) {
        SQLObject parent = this.getParent();
        if (this.left == expr) {
            if (taget == null) {
                if (parent instanceof SQLReplaceable) {
                    return ((SQLReplaceable)((Object)parent)).replace(this, this.right);
                }
                return false;
            }
            this.setLeft(taget);
            return true;
        }
        if (this.right == expr) {
            if (taget == null) {
                if (parent instanceof SQLReplaceable) {
                    return ((SQLReplaceable)((Object)parent)).replace(this, this.left);
                }
                return false;
            }
            this.setRight(taget);
            return true;
        }
        return false;
    }
}

