/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.visitor;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOperator;
import com.alibaba.druid.sql.ast.expr.SQLInListExpr;
import com.alibaba.druid.sql.ast.expr.SQLLiteralExpr;
import com.alibaba.druid.sql.ast.expr.SQLVariantRefExpr;
import com.alibaba.druid.sql.dialect.mysql.visitor.MySqlParameterizedOutputVisitor;
import com.alibaba.druid.sql.dialect.oracle.visitor.OracleParameterizedOutputVisitor;
import com.alibaba.druid.sql.dialect.postgresql.visitor.PGParameterizedOutputVisitor;
import com.alibaba.druid.sql.dialect.sqlserver.visitor.SQLServerParameterizedOutputVisitor;
import com.alibaba.druid.sql.parser.SQLParserUtils;
import com.alibaba.druid.sql.parser.SQLStatementParser;
import com.alibaba.druid.sql.visitor.ParameterizedOutputVisitor;
import com.alibaba.druid.sql.visitor.SQLASTOutputVisitor;
import java.util.List;

public class ParameterizedOutputVisitorUtils {
    public static final String ATTR_PARAMS_SKIP = "druid.parameterized.skip";

    public static String parameterize(String sql, String dbType) {
        SQLStatementParser parser = SQLParserUtils.createSQLStatementParser(sql, dbType);
        List<SQLStatement> statementList = parser.parseStatementList();
        SQLStatement stmt = statementList.get(0);
        StringBuilder out = new StringBuilder();
        SQLASTOutputVisitor visitor = ParameterizedOutputVisitorUtils.createParameterizedOutputVisitor(out, dbType);
        stmt.accept(visitor);
        return out.toString();
    }

    public static SQLASTOutputVisitor createParameterizedOutputVisitor(Appendable out, String dbType) {
        if ("oracle".equals(dbType) || "AliOracle".equals(dbType)) {
            return new OracleParameterizedOutputVisitor(out);
        }
        if ("mysql".equals(dbType)) {
            return new MySqlParameterizedOutputVisitor(out);
        }
        if ("mariadb".equals(dbType)) {
            return new MySqlParameterizedOutputVisitor(out);
        }
        if ("h2".equals(dbType)) {
            return new MySqlParameterizedOutputVisitor(out);
        }
        if ("postgresql".equals(dbType)) {
            return new PGParameterizedOutputVisitor(out);
        }
        if ("sqlserver".equals(dbType) || "jtds".equals(dbType)) {
            return new SQLServerParameterizedOutputVisitor(out);
        }
        return new ParameterizedOutputVisitor(out);
    }

    public static boolean visit(SQLASTOutputVisitor v, SQLInListExpr x) {
        x.getExpr().accept(v);
        if (x.isNot()) {
            v.print(" NOT IN (?)");
        } else {
            v.print(" IN (?)");
        }
        return false;
    }

    public static SQLBinaryOpExpr merge(SQLBinaryOpExpr x) {
        if (x.getLeft() instanceof SQLLiteralExpr && x.getRight() instanceof SQLLiteralExpr) {
            if (x.getOperator() == SQLBinaryOperator.Equality || x.getOperator() == SQLBinaryOperator.NotEqual) {
                x.getLeft().getAttributes().put(ATTR_PARAMS_SKIP, true);
                x.getRight().getAttributes().put(ATTR_PARAMS_SKIP, true);
            }
            return x;
        }
        if (x.getRight() instanceof SQLLiteralExpr) {
            x = new SQLBinaryOpExpr(x.getLeft(), x.getOperator(), new SQLVariantRefExpr("?"));
        }
        if (x.getLeft() instanceof SQLLiteralExpr) {
            x = new SQLBinaryOpExpr((SQLExpr)new SQLVariantRefExpr("?"), x.getOperator(), x.getRight());
        }
        while (x.getRight() instanceof SQLBinaryOpExpr) {
            SQLBinaryOpExpr leftBinaryExpr;
            if (x.getLeft() instanceof SQLBinaryOpExpr && (leftBinaryExpr = (SQLBinaryOpExpr)x.getLeft()).getRight().equals(x.getRight())) {
                x = leftBinaryExpr;
                continue;
            }
            x = new SQLBinaryOpExpr(x.getLeft(), x.getOperator(), ParameterizedOutputVisitorUtils.merge((SQLBinaryOpExpr)x.getRight()));
            break;
        }
        if (x.getLeft() instanceof SQLBinaryOpExpr) {
            x = new SQLBinaryOpExpr((SQLExpr)ParameterizedOutputVisitorUtils.merge((SQLBinaryOpExpr)x.getLeft()), x.getOperator(), x.getRight());
        }
        if (x.getOperator() == SQLBinaryOperator.BooleanOr && x.getLeft() instanceof SQLBinaryOpExpr && x.getRight() instanceof SQLBinaryOpExpr) {
            SQLBinaryOpExpr right;
            SQLBinaryOpExpr left = (SQLBinaryOpExpr)x.getLeft();
            if (ParameterizedOutputVisitorUtils.mergeEqual(left, right = (SQLBinaryOpExpr)x.getRight())) {
                return left;
            }
            if (ParameterizedOutputVisitorUtils.isLiteralExpr(left.getLeft()) && left.getOperator() == SQLBinaryOperator.BooleanOr && ParameterizedOutputVisitorUtils.mergeEqual(left.getRight(), right)) {
                return left;
            }
        }
        return x;
    }

    private static boolean mergeEqual(SQLExpr a, SQLExpr b) {
        if (!(a instanceof SQLBinaryOpExpr)) {
            return false;
        }
        if (!(b instanceof SQLBinaryOpExpr)) {
            return false;
        }
        SQLBinaryOpExpr binaryA = (SQLBinaryOpExpr)a;
        SQLBinaryOpExpr binaryB = (SQLBinaryOpExpr)b;
        if (binaryA.getOperator() != SQLBinaryOperator.Equality) {
            return false;
        }
        if (binaryB.getOperator() != SQLBinaryOperator.Equality) {
            return false;
        }
        if (!(binaryA.getRight() instanceof SQLLiteralExpr) && !(binaryA.getRight() instanceof SQLVariantRefExpr)) {
            return false;
        }
        if (!(binaryB.getRight() instanceof SQLLiteralExpr) && !(binaryB.getRight() instanceof SQLVariantRefExpr)) {
            return false;
        }
        return binaryA.getLeft().toString().equals(binaryB.getLeft().toString());
    }

    private static boolean isLiteralExpr(SQLExpr expr) {
        if (expr instanceof SQLLiteralExpr) {
            return true;
        }
        if (expr instanceof SQLBinaryOpExpr) {
            SQLBinaryOpExpr binary = (SQLBinaryOpExpr)expr;
            return ParameterizedOutputVisitorUtils.isLiteralExpr(binary.getLeft()) && ParameterizedOutputVisitorUtils.isLiteralExpr(binary.getRight());
        }
        return false;
    }
}

