/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.sqlserver.parser;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.druid.sql.dialect.sqlserver.ast.SQLServerTop;
import com.alibaba.druid.sql.dialect.sqlserver.ast.expr.SQLServerObjectReferenceExpr;
import com.alibaba.druid.sql.dialect.sqlserver.parser.SQLServerLexer;
import com.alibaba.druid.sql.dialect.sqlserver.parser.SQLServerSelectParser;
import com.alibaba.druid.sql.parser.Lexer;
import com.alibaba.druid.sql.parser.SQLExprParser;
import com.alibaba.druid.sql.parser.Token;

public class SQLServerExprParser
extends SQLExprParser {
    public SQLServerExprParser(Lexer lexer) {
        super(lexer);
    }

    public SQLServerExprParser(String sql) {
        super(new SQLServerLexer(sql));
        this.lexer.nextToken();
    }

    @Override
    public SQLExpr primary() {
        if (this.lexer.token() == Token.LBRACKET) {
            this.lexer.nextToken();
            SQLName name = this.name();
            this.accept(Token.RBRACKET);
            return this.primaryRest(name);
        }
        return super.primary();
    }

    @Override
    public SQLServerSelectParser createSelectParser() {
        return new SQLServerSelectParser(this);
    }

    @Override
    public SQLExpr primaryRest(SQLExpr expr) {
        if (this.lexer.token() == Token.DOTDOT) {
            expr = this.nameRest((SQLName)expr);
        }
        return super.primaryRest(expr);
    }

    @Override
    protected SQLExpr dotRest(SQLExpr expr) {
        boolean backet = false;
        if (this.lexer.token() == Token.LBRACKET) {
            this.lexer.nextToken();
            backet = true;
        }
        expr = super.dotRest(expr);
        if (backet) {
            this.accept(Token.RBRACKET);
        }
        return expr;
    }

    @Override
    public SQLName nameRest(SQLName expr) {
        if (this.lexer.token() == Token.DOTDOT) {
            this.lexer.nextToken();
            boolean backet = false;
            if (this.lexer.token() == Token.LBRACKET) {
                this.lexer.nextToken();
                backet = true;
            }
            String text = this.lexer.stringVal();
            this.lexer.nextToken();
            if (backet) {
                this.accept(Token.RBRACKET);
            }
            SQLServerObjectReferenceExpr owner = new SQLServerObjectReferenceExpr(expr);
            expr = new SQLPropertyExpr(owner, text);
        }
        return super.nameRest(expr);
    }

    @Override
    public boolean isAggreateFunction(String word) {
        String[] aggregateFunctions = new String[]{"AVG", "COUNT", "MAX", "MIN", "ROW_NUMBER", "STDDEV", "SUM"};
        for (int i = 0; i < aggregateFunctions.length; ++i) {
            if (aggregateFunctions[i].compareToIgnoreCase(word) != 0) continue;
            return true;
        }
        return false;
    }

    public SQLServerTop parseTop() {
        if (this.lexer.token() == Token.TOP) {
            SQLServerTop top = new SQLServerTop();
            this.lexer.nextToken();
            boolean paren = false;
            if (this.lexer.token() == Token.LPAREN) {
                paren = true;
                this.lexer.nextToken();
            }
            top.setExpr(this.primary());
            if (paren) {
                this.accept(Token.RPAREN);
            }
            if (this.lexer.token() == Token.PERCENT) {
                this.lexer.nextToken();
                top.setPercent(true);
            }
            return top;
        }
        return null;
    }
}

