/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.ast.expr;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLExprImpl;
import com.alibaba.druid.sql.dialect.oracle.visitor.OracleASTVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class SQLMethodInvokeExpr
extends SQLExprImpl
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String methodName;
    private SQLExpr owner;
    private final List<SQLExpr> parameters = new ArrayList<SQLExpr>();

    public SQLMethodInvokeExpr() {
    }

    public SQLMethodInvokeExpr(String methodName) {
        this.methodName = methodName;
    }

    public SQLMethodInvokeExpr(String methodName, SQLExpr owner) {
        this.methodName = methodName;
        this.owner = owner;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public SQLExpr getOwner() {
        return this.owner;
    }

    public void setOwner(SQLExpr owner) {
        this.owner = owner;
    }

    public List<SQLExpr> getParameters() {
        return this.parameters;
    }

    @Override
    public void output(StringBuffer buf) {
        if (this.owner != null) {
            this.owner.output(buf);
            buf.append(".");
        }
        buf.append(this.methodName);
        buf.append("(");
        int size = this.parameters.size();
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                buf.append(", ");
            }
            this.parameters.get(i).output(buf);
        }
        buf.append(")");
    }

    @Override
    protected void accept0(SQLASTVisitor visitor) {
        if (visitor.visit(this)) {
            this.acceptChild(visitor, this.owner);
            this.acceptChild(visitor, this.parameters);
        }
        visitor.endVisit(this);
    }

    protected void accept0(OracleASTVisitor visitor) {
        if (visitor.visit(this)) {
            this.acceptChild((SQLASTVisitor)visitor, this.owner);
            this.acceptChild((SQLASTVisitor)visitor, this.parameters);
        }
        visitor.endVisit(this);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.methodName == null ? 0 : this.methodName.hashCode());
        result = 31 * result + (this.owner == null ? 0 : this.owner.hashCode());
        result = 31 * result + (this.parameters == null ? 0 : this.parameters.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SQLMethodInvokeExpr other = (SQLMethodInvokeExpr)obj;
        if (this.methodName == null ? other.methodName != null : !this.methodName.equals(other.methodName)) {
            return false;
        }
        if (this.owner == null ? other.owner != null : !this.owner.equals(other.owner)) {
            return false;
        }
        return !(this.parameters == null ? other.parameters != null : !this.parameters.equals(other.parameters));
    }
}

