/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.pool;

import com.alibaba.druid.pool.DruidPooledConnection;
import com.alibaba.druid.pool.DruidPooledResultSet;
import com.alibaba.druid.pool.DruidPooledStatement;
import com.alibaba.druid.pool.PreparedStatementHolder;
import com.alibaba.druid.pool.PreparedStatementPool;
import com.alibaba.druid.support.logging.Log;
import com.alibaba.druid.support.logging.LogFactory;
import com.alibaba.druid.util.OracleUtils;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Calendar;

public class DruidPooledPreparedStatement
extends DruidPooledStatement
implements PreparedStatement {
    private static final Log LOG = LogFactory.getLog(DruidPooledPreparedStatement.class);
    private final PreparedStatementHolder holder;
    private final PreparedStatement stmt;
    private final String sql;
    private int defaultMaxFieldSize;
    private int defaultMaxRows;
    private int defaultQueryTimeout;
    private int defaultFetchDirection;
    private int defaultFetchSize;
    private int currentMaxFieldSize;
    private int currentMaxRows;
    private int currentQueryTimeout;
    private int currentFetchDirection;
    private int currentFetchSize;

    public DruidPooledPreparedStatement(DruidPooledConnection conn, PreparedStatementHolder holder) throws SQLException {
        super(conn, holder.getStatement());
        this.stmt = holder.getStatement();
        this.holder = holder;
        this.sql = holder.getKey().sql;
        try {
            this.defaultMaxFieldSize = this.stmt.getMaxFieldSize();
        }
        catch (SQLException e) {
            LOG.error("getMaxFieldSize error", e);
        }
        try {
            this.defaultMaxRows = this.stmt.getMaxRows();
        }
        catch (SQLException e) {
            LOG.error("getMaxRows error", e);
        }
        try {
            this.defaultQueryTimeout = this.stmt.getQueryTimeout();
        }
        catch (SQLException e) {
            LOG.error("getMaxRows error", e);
        }
        try {
            this.defaultFetchDirection = this.stmt.getFetchDirection();
        }
        catch (SQLException e) {
            LOG.error("getFetchDirection error", e);
        }
        try {
            this.defaultFetchSize = this.stmt.getFetchSize();
        }
        catch (SQLException e) {
            LOG.error("getFetchSize error", e);
        }
        this.currentMaxFieldSize = this.defaultMaxFieldSize;
        this.currentMaxRows = this.defaultMaxRows;
        this.currentQueryTimeout = this.defaultQueryTimeout;
        this.currentFetchDirection = this.defaultFetchDirection;
        this.currentFetchSize = this.defaultFetchSize;
    }

    public PreparedStatementHolder getPreparedStatementHolder() {
        return this.holder;
    }

    public int getHitCount() {
        return this.holder.getHitCount();
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.currentFetchSize = rows;
        super.setFetchSize(rows);
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.currentFetchDirection = direction;
        super.setFetchDirection(direction);
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        this.currentMaxFieldSize = max;
        super.setMaxFieldSize(max);
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this.currentMaxRows = max;
        super.setMaxRows(max);
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.currentQueryTimeout = seconds;
        super.setQueryTimeout(seconds);
    }

    public String getSql() {
        return this.sql;
    }

    public PreparedStatementKey getKey() {
        return this.holder.getKey();
    }

    public PreparedStatement getRawPreparedStatement() {
        return this.stmt;
    }

    public PreparedStatement getRawStatement() {
        return this.stmt;
    }

    @Override
    public void close() throws SQLException {
        if (this.isClosed()) {
            return;
        }
        boolean connectionClosed = this.conn.isClosed();
        if (!connectionClosed) {
            try {
                if (this.defaultMaxFieldSize != this.currentMaxFieldSize) {
                    this.stmt.setMaxFieldSize(this.defaultMaxFieldSize);
                    this.currentMaxFieldSize = this.defaultMaxFieldSize;
                }
                if (this.defaultMaxRows != this.currentMaxRows) {
                    this.stmt.setMaxRows(this.defaultMaxRows);
                    this.currentMaxRows = this.defaultMaxRows;
                }
                if (this.defaultQueryTimeout != this.currentQueryTimeout) {
                    this.stmt.setQueryTimeout(this.defaultQueryTimeout);
                    this.currentQueryTimeout = this.defaultQueryTimeout;
                }
                if (this.defaultFetchDirection != this.currentFetchDirection) {
                    this.stmt.setFetchDirection(this.defaultFetchDirection);
                    this.currentFetchDirection = this.defaultFetchDirection;
                }
                if (this.defaultFetchSize != this.currentFetchSize) {
                    this.stmt.setFetchSize(this.defaultFetchSize);
                    this.currentFetchSize = this.defaultFetchSize;
                }
            }
            catch (Exception e) {
                this.conn.handleException(e);
            }
        }
        this.conn.closePoolableStatement(this);
    }

    void closeInternal() throws SQLException {
        super.close();
    }

    void setClosed(boolean value) {
        this.closed = value;
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        this.checkOpen();
        this.incrementExecuteCount();
        this.transactionRecord(this.sql);
        this.oracleSetRowPrefetch();
        this.conn.beforeExecute();
        try {
            ResultSet rs = this.stmt.executeQuery();
            if (rs == null) {
                ResultSet resultSet = null;
                return resultSet;
            }
            DruidPooledResultSet poolableResultSet = new DruidPooledResultSet(this, rs);
            this.resultSetTrace.add(poolableResultSet);
            DruidPooledResultSet druidPooledResultSet = poolableResultSet;
            return druidPooledResultSet;
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
        finally {
            this.conn.afterExecute();
        }
    }

    @Override
    public int executeUpdate() throws SQLException {
        this.checkOpen();
        this.incrementExecuteCount();
        this.transactionRecord(this.sql);
        this.conn.beforeExecute();
        try {
            int n = this.stmt.executeUpdate();
            return n;
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
        finally {
            this.conn.afterExecute();
        }
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.checkOpen();
        try {
            this.stmt.setNull(parameterIndex, sqlType);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.checkOpen();
        try {
            this.stmt.setBoolean(parameterIndex, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.checkOpen();
        try {
            this.stmt.setByte(parameterIndex, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        this.checkOpen();
        try {
            this.stmt.setShort(parameterIndex, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        this.checkOpen();
        try {
            this.stmt.setInt(parameterIndex, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        this.checkOpen();
        try {
            this.stmt.setLong(parameterIndex, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.checkOpen();
        try {
            this.stmt.setFloat(parameterIndex, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.checkOpen();
        try {
            this.stmt.setDouble(parameterIndex, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.checkOpen();
        try {
            this.stmt.setBigDecimal(parameterIndex, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        this.checkOpen();
        try {
            this.stmt.setString(parameterIndex, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.checkOpen();
        try {
            this.stmt.setBytes(parameterIndex, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.checkOpen();
        try {
            this.stmt.setDate(parameterIndex, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.checkOpen();
        try {
            this.stmt.setTime(parameterIndex, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.checkOpen();
        try {
            this.stmt.setTimestamp(parameterIndex, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.checkOpen();
        try {
            this.stmt.setAsciiStream(parameterIndex, x, length);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    @Deprecated
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.checkOpen();
        try {
            this.stmt.setUnicodeStream(parameterIndex, x, length);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.checkOpen();
        try {
            this.stmt.setBinaryStream(parameterIndex, x, length);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void clearParameters() throws SQLException {
        this.checkOpen();
        try {
            this.stmt.clearParameters();
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.checkOpen();
        try {
            this.stmt.setObject(parameterIndex, x, targetSqlType);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        this.checkOpen();
        try {
            this.stmt.setObject(parameterIndex, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public boolean execute() throws SQLException {
        this.checkOpen();
        this.incrementExecuteCount();
        this.transactionRecord(this.sql);
        this.conn.beforeExecute();
        try {
            boolean bl = this.stmt.execute();
            return bl;
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
        finally {
            this.conn.afterExecute();
        }
    }

    protected void oracleSetRowPrefetch() throws SQLException {
        int rowPrefetch;
        int defaultRowPretch;
        if (!this.conn.isOracle()) {
            return;
        }
        if (this.holder.getHitCount() == 0) {
            return;
        }
        int fetchRowPeak = this.holder.getFetchRowPeak();
        if (fetchRowPeak < 0) {
            return;
        }
        if (this.holder.getDefaultRowPretch() == -1 && (defaultRowPretch = OracleUtils.getRowPrefetch(this)) != this.holder.getDefaultRowPretch()) {
            this.holder.setDefaultRowPretch(defaultRowPretch);
            this.holder.setRowPrefetch(defaultRowPretch);
        }
        if ((rowPrefetch = fetchRowPeak <= 1 ? 2 : (fetchRowPeak > this.holder.getDefaultRowPretch() ? this.holder.getDefaultRowPretch() : fetchRowPeak + 1)) != this.holder.getRowPrefetch()) {
            OracleUtils.setRowPrefetch(this, rowPrefetch);
            this.holder.setRowPrefetch(rowPrefetch);
        }
    }

    @Override
    public void addBatch() throws SQLException {
        this.checkOpen();
        try {
            this.stmt.addBatch();
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public int[] executeBatch() throws SQLException {
        this.checkOpen();
        this.incrementExecuteCount();
        this.transactionRecord(this.sql);
        this.conn.beforeExecute();
        try {
            int[] nArray = this.stmt.executeBatch();
            return nArray;
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
        finally {
            this.conn.afterExecute();
        }
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        this.checkOpen();
        try {
            this.stmt.setCharacterStream(parameterIndex, reader, length);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void setRef(int parameterIndex, Ref x) throws SQLException {
        this.checkOpen();
        try {
            this.stmt.setRef(parameterIndex, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        this.checkOpen();
        try {
            this.stmt.setBlob(parameterIndex, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void setClob(int parameterIndex, Clob x) throws SQLException {
        this.checkOpen();
        try {
            this.stmt.setClob(parameterIndex, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void setArray(int parameterIndex, Array x) throws SQLException {
        this.checkOpen();
        try {
            this.stmt.setArray(parameterIndex, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkOpen();
        try {
            return this.stmt.getMetaData();
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        this.checkOpen();
        try {
            this.stmt.setDate(parameterIndex, x, cal);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        this.checkOpen();
        try {
            this.stmt.setTime(parameterIndex, x, cal);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this.checkOpen();
        try {
            this.stmt.setTimestamp(parameterIndex, x, cal);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.checkOpen();
        try {
            this.stmt.setNull(parameterIndex, sqlType, typeName);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        this.checkOpen();
        try {
            this.stmt.setURL(parameterIndex, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        this.checkOpen();
        try {
            return this.stmt.getParameterMetaData();
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        this.checkOpen();
        try {
            this.stmt.setRowId(parameterIndex, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        this.checkOpen();
        try {
            this.stmt.setNString(parameterIndex, value);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        this.checkOpen();
        try {
            this.stmt.setNCharacterStream(parameterIndex, value, length);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        this.checkOpen();
        try {
            this.stmt.setNClob(parameterIndex, value);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.checkOpen();
        try {
            this.stmt.setClob(parameterIndex, reader, length);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        this.checkOpen();
        try {
            this.stmt.setBlob(parameterIndex, inputStream, length);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.checkOpen();
        try {
            this.stmt.setNClob(parameterIndex, reader, length);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        this.checkOpen();
        try {
            this.stmt.setSQLXML(parameterIndex, xmlObject);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        this.checkOpen();
        try {
            this.stmt.setObject(parameterIndex, x, targetSqlType, scaleOrLength);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this.checkOpen();
        try {
            this.stmt.setAsciiStream(parameterIndex, x, length);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this.checkOpen();
        try {
            this.stmt.setBinaryStream(parameterIndex, x, length);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        this.checkOpen();
        try {
            this.stmt.setCharacterStream(parameterIndex, reader, length);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        this.checkOpen();
        try {
            this.stmt.setAsciiStream(parameterIndex, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        this.checkOpen();
        try {
            this.stmt.setBinaryStream(parameterIndex, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        this.checkOpen();
        try {
            this.stmt.setCharacterStream(parameterIndex, reader);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        this.checkOpen();
        try {
            this.stmt.setNCharacterStream(parameterIndex, value);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        this.checkOpen();
        try {
            this.stmt.setClob(parameterIndex, reader);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        this.checkOpen();
        try {
            this.stmt.setBlob(parameterIndex, inputStream);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        this.checkOpen();
        try {
            this.stmt.setNClob(parameterIndex, reader);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        if (iface == PreparedStatementHolder.class) {
            return true;
        }
        return super.isWrapperFor(iface);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface == PreparedStatementHolder.class) {
            return (T)this.holder;
        }
        return super.unwrap(iface);
    }

    public static class PreparedStatementKey {
        private final String sql;
        private final String catalog;
        protected final PreparedStatementPool.MethodType methodType;
        private final int resultSetType;
        private final int resultSetConcurrency;
        private final int resultSetHoldability;
        private final int autoGeneratedKeys;
        private final int[] columnIndexes;
        private final String[] columnNames;

        public PreparedStatementKey(String sql, String catalog, PreparedStatementPool.MethodType methodType) throws SQLException {
            this(sql, catalog, methodType, 0, 0, 0, 0, null, null);
        }

        public PreparedStatementKey(String sql, String catalog, PreparedStatementPool.MethodType methodType, int resultSetType, int resultSetConcurrency) throws SQLException {
            this(sql, catalog, methodType, resultSetType, resultSetConcurrency, 0, 0, null, null);
        }

        public PreparedStatementKey(String sql, String catalog, PreparedStatementPool.MethodType methodType, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
            this(sql, catalog, methodType, resultSetType, resultSetConcurrency, resultSetHoldability, 0, null, null);
        }

        public PreparedStatementKey(String sql, String catalog, PreparedStatementPool.MethodType methodType, int autoGeneratedKeys) throws SQLException {
            this(sql, catalog, methodType, 0, 0, 0, autoGeneratedKeys, null, null);
        }

        public PreparedStatementKey(String sql, String catalog, PreparedStatementPool.MethodType methodType, int[] columnIndexes) throws SQLException {
            this(sql, catalog, methodType, 0, 0, 0, 0, columnIndexes, null);
        }

        public PreparedStatementKey(String sql, String catalog, PreparedStatementPool.MethodType methodType, String[] columnNames) throws SQLException {
            this(sql, catalog, methodType, 0, 0, 0, 0, null, columnNames);
        }

        public PreparedStatementKey(String sql, String catalog, PreparedStatementPool.MethodType methodType, int resultSetType, int resultSetConcurrency, int resultSetHoldability, int autoGeneratedKeys, int[] columnIndexes, String[] columnNames) throws SQLException {
            if (sql == null) {
                throw new SQLException("sql is null");
            }
            this.sql = sql;
            this.catalog = catalog;
            this.methodType = methodType;
            this.resultSetType = resultSetType;
            this.resultSetConcurrency = resultSetConcurrency;
            this.resultSetHoldability = resultSetHoldability;
            this.autoGeneratedKeys = autoGeneratedKeys;
            this.columnIndexes = columnIndexes;
            this.columnNames = columnNames;
        }

        public int getResultSetType() {
            return this.resultSetType;
        }

        public int getResultSetConcurrency() {
            return this.resultSetConcurrency;
        }

        public int getResultSetHoldability() {
            return this.resultSetHoldability;
        }

        public boolean equals(Object object) {
            PreparedStatementKey that = (PreparedStatementKey)object;
            if (!this.sql.equals(that.sql)) {
                return false;
            }
            if (this.catalog == null ? that.catalog != null : !this.catalog.equals(that.catalog)) {
                return false;
            }
            if (this.methodType != that.methodType) {
                return false;
            }
            if (this.resultSetType != that.resultSetType) {
                return false;
            }
            if (this.resultSetConcurrency != that.resultSetConcurrency) {
                return false;
            }
            if (this.resultSetHoldability != that.resultSetHoldability) {
                return false;
            }
            if (this.autoGeneratedKeys != that.autoGeneratedKeys) {
                return false;
            }
            if (!Arrays.equals(this.columnIndexes, that.columnIndexes)) {
                return false;
            }
            return Arrays.equals(this.columnNames, that.columnNames);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.sql == null ? 0 : this.sql.hashCode());
            result = 31 * result + (this.catalog == null ? 0 : this.catalog.hashCode());
            result = 31 * result + (this.methodType == null ? 0 : this.methodType.hashCode());
            result = 31 * result + this.resultSetConcurrency;
            result = 31 * result + this.resultSetHoldability;
            result = 31 * result + this.resultSetType;
            result = 31 * result + this.autoGeneratedKeys;
            result = 31 * result + Arrays.hashCode(this.columnIndexes);
            result = 31 * result + Arrays.hashCode(this.columnNames);
            return result;
        }

        public String getSql() {
            return this.sql;
        }
    }
}

