/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.mock;

import com.alibaba.druid.mock.MockArray;
import com.alibaba.druid.mock.MockBlob;
import com.alibaba.druid.mock.MockCallableStatement;
import com.alibaba.druid.mock.MockClob;
import com.alibaba.druid.mock.MockConnectionClosedException;
import com.alibaba.druid.mock.MockDriver;
import com.alibaba.druid.mock.MockNClob;
import com.alibaba.druid.mock.MockPreparedStatement;
import com.alibaba.druid.mock.MockSQLXML;
import com.alibaba.druid.mock.MockSavepoint;
import com.alibaba.druid.mock.MockStatement;
import com.alibaba.druid.mock.MockStruct;
import com.alibaba.druid.util.jdbc.ConnectionBase;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;

public class MockConnection
extends ConnectionBase
implements Connection {
    private boolean closed = false;
    private MockDriver driver;
    private int savepointIdSeed = 0;
    private List<Savepoint> savepoints = new ArrayList<Savepoint>();
    private long id;
    private final long createdTimeMillis = System.currentTimeMillis();
    private long lastActiveTimeMillis = System.currentTimeMillis();
    private SQLException error;

    public MockConnection() {
        this(null, null, null);
    }

    public MockConnection(MockDriver driver, String url, Properties connectProperties) {
        super(url, connectProperties);
        this.driver = driver;
        if (driver != null) {
            this.id = driver.generateConnectionId();
        }
    }

    public SQLException getError() {
        return this.error;
    }

    public void setError(SQLException error) {
        this.error = error;
    }

    public List<Savepoint> getSavepoints() {
        return this.savepoints;
    }

    public long getLastActiveTimeMillis() {
        return this.lastActiveTimeMillis;
    }

    public void setLastActiveTimeMillis(long lastActiveTimeMillis) {
        this.lastActiveTimeMillis = lastActiveTimeMillis;
    }

    public long getCreatedTimeMillis() {
        return this.createdTimeMillis;
    }

    public long getId() {
        return this.id;
    }

    public MockDriver getDriver() {
        return this.driver;
    }

    public void setDriver(MockDriver driver) {
        this.driver = driver;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isInstance(this)) {
            return (T)this;
        }
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }

    @Override
    public Statement createStatement() throws SQLException {
        this.checkState();
        return this.createMockStatement();
    }

    private MockStatement createMockStatement() {
        if (this.driver != null) {
            return this.driver.createMockStatement(this);
        }
        return new MockStatement(this);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        this.checkState();
        return this.createMockPreparedStatement(sql);
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        this.checkState();
        return this.createMockCallableStatement(sql);
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        this.checkState();
        return sql;
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.checkState();
        super.setAutoCommit(autoCommit);
    }

    @Override
    public void commit() throws SQLException {
        this.checkState();
    }

    @Override
    public void rollback() throws SQLException {
        this.checkState();
        this.savepoints.clear();
    }

    @Override
    public void close() throws SQLException {
        if (!this.closed) {
            this.closed = true;
            if (this.driver != null) {
                this.driver.afterConnectionClose(this);
            }
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return null;
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkState();
        MockStatement stmt = this.createMockStatement();
        stmt.setResultSetType(resultSetType);
        stmt.setResultSetConcurrency(resultSetConcurrency);
        return stmt;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkState();
        MockPreparedStatement stmt = this.createMockPreparedStatement(sql);
        stmt.setResultSetType(resultSetType);
        stmt.setResultSetConcurrency(resultSetConcurrency);
        return stmt;
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkState();
        MockCallableStatement stmt = this.createMockCallableStatement(sql);
        stmt.setResultSetType(resultSetType);
        stmt.setResultSetConcurrency(resultSetConcurrency);
        return stmt;
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        return null;
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        this.checkState();
        MockSavepoint savepoint = new MockSavepoint();
        savepoint.setSavepointId(this.savepointIdSeed++);
        this.savepoints.add(savepoint);
        return savepoint;
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        this.checkState();
        MockSavepoint savepoint = new MockSavepoint();
        savepoint.setSavepointId(this.savepointIdSeed++);
        savepoint.setSavepointName(name);
        this.savepoints.add(savepoint);
        return savepoint;
    }

    @Override
    public void checkState() throws SQLException {
        if (this.error != null) {
            throw this.error;
        }
        if (this.closed) {
            throw new MockConnectionClosedException();
        }
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.checkState();
        int index = this.savepoints.indexOf(savepoint);
        if (index == -1) {
            throw new SQLException("savepoint not contained");
        }
        for (int i = this.savepoints.size() - 1; i >= index; --i) {
            this.savepoints.remove(i);
        }
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.checkState();
        if (savepoint == null) {
            throw new SQLException("argument is null");
        }
        int index = this.savepoints.indexOf(savepoint);
        if (index == -1) {
            throw new SQLException("savepoint not contained");
        }
        this.savepoints.remove(savepoint);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkState();
        MockStatement stmt = this.createMockStatement();
        stmt.setResultSetType(resultSetType);
        stmt.setResultSetConcurrency(resultSetConcurrency);
        stmt.setResultSetHoldability(resultSetHoldability);
        return stmt;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkState();
        MockPreparedStatement stmt = this.createMockPreparedStatement(sql);
        stmt.setResultSetType(resultSetType);
        stmt.setResultSetConcurrency(resultSetConcurrency);
        stmt.setResultSetHoldability(resultSetHoldability);
        return stmt;
    }

    private MockPreparedStatement createMockPreparedStatement(String sql) {
        if (this.driver != null) {
            return this.driver.createMockPreparedStatement(this, sql);
        }
        return new MockPreparedStatement(this, sql);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkState();
        MockCallableStatement stmt = this.createMockCallableStatement(sql);
        stmt.setResultSetType(resultSetType);
        stmt.setResultSetConcurrency(resultSetConcurrency);
        stmt.setResultSetHoldability(resultSetHoldability);
        return stmt;
    }

    private MockCallableStatement createMockCallableStatement(String sql) {
        if (this.driver != null) {
            return this.driver.createMockCallableStatement(this, sql);
        }
        return new MockCallableStatement(this, sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkState();
        return this.createMockPreparedStatement(sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        this.checkState();
        return this.createMockPreparedStatement(sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        this.checkState();
        return this.createMockPreparedStatement(sql);
    }

    @Override
    public Clob createClob() throws SQLException {
        if (this.driver != null) {
            return this.driver.createClob(this);
        }
        return new MockClob();
    }

    @Override
    public Blob createBlob() throws SQLException {
        if (this.driver != null) {
            return this.driver.createBlob(this);
        }
        return new MockBlob();
    }

    @Override
    public NClob createNClob() throws SQLException {
        if (this.driver != null) {
            return this.driver.createNClob(this);
        }
        return new MockNClob();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        if (this.driver != null) {
            return this.driver.createSQLXML(this);
        }
        return new MockSQLXML();
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        return false;
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        return null;
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        return new Properties();
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        return new MockArray();
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        return new MockStruct();
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public String getSchema() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.checkState();
        super.setReadOnly(readOnly);
    }

    public void handleSleep() {
        Object propertyValue;
        if (this.getConnectProperties() != null && (propertyValue = this.getConnectProperties().get("executeSleep")) != null) {
            long millis = Long.parseLong(propertyValue.toString());
            try {
                Thread.sleep(millis);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
    }
}

