/*
 * Decompiled with CFR 0.152.
 */
package cn.dreampie.websocket;

import cn.dreampie.websocket.Message;
import cn.dreampie.websocket.MessageDecoder;
import cn.dreampie.websocket.MessageEncoder;
import cn.dreampie.websocket.MessageServerConfigurator;
import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.websocket.CloseReason;
import javax.websocket.EncodeException;
import javax.websocket.EndpointConfig;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.PathParam;
import javax.websocket.server.ServerEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServerEndpoint(value="/im/{cid}", encoders={MessageEncoder.class}, decoders={MessageDecoder.class}, configurator=MessageServerConfigurator.class)
public class MessageServer {
    private static final Logger logger = LoggerFactory.getLogger(MessageServer.class);
    static Map<String, Session> users = new ConcurrentHashMap<String, Session>();
    public static long timeout = 1200000L;

    @OnOpen
    public void open(Session session, EndpointConfig conf, @PathParam(value="cid") String cid) {
        try {
            session.setMaxIdleTimeout(timeout);
            session.getBasicRemote().sendObject((Object)new Message("Welcome"));
        }
        catch (IOException e) {
            logger.error(e.toString());
        }
        catch (EncodeException e) {
            logger.error(e.toString());
        }
        users.put(cid, session);
        logger.info("Connection opened.login user id {},login time {}", (Object)cid, (Object)new Date());
    }

    @OnMessage
    public void message(Session session, Message msg) {
        if (msg != null) {
            if (msg.getReceiver().equals("all")) {
                MessageServer.sendAll(msg);
            } else {
                MessageServer.send(msg);
            }
        }
    }

    @OnError
    public void error(Session session, Throwable t) {
        this.removeSession(session);
        logger.error("Connection error.get error {},get error time {}", (Object)t.toString(), (Object)new Date());
    }

    @OnClose
    public void close(Session session, CloseReason reason) {
        this.removeSession(session);
        logger.info("Connection closed.close reson {},close time {}", (Object)reason.toString(), (Object)new Date());
    }

    public boolean removeSession(Session session) {
        Collection<Session> sessions = users.values();
        return sessions.contains(session) && sessions.remove(session);
    }

    public static void send(Message message) {
        String receiver = message.getReceiver();
        if (receiver == null || receiver.isEmpty()) {
            logger.info("Send: {}", (Object)"not receiver");
            return;
        }
        try {
            for (String cid : users.keySet()) {
                if (cid.equals(receiver)) {
                    users.get(cid).getBasicRemote().sendObject((Object)message);
                }
                logger.info("Send: {}", (Object)message);
            }
        }
        catch (IOException e) {
            logger.error(e.toString());
        }
        catch (EncodeException e) {
            logger.error(e.toString());
        }
    }

    public static void sendAll(Message message) {
        try {
            for (Session session : users.values()) {
                session.getBasicRemote().sendObject((Object)message);
                logger.info("SendAll: {}", (Object)message);
            }
        }
        catch (IOException e) {
            logger.error(e.toString());
        }
        catch (EncodeException e) {
            logger.error(e.toString());
        }
    }
}

