/*
 * Decompiled with CFR 0.152.
 */
package scallop.sca.binding.rmi.provider;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.Remote;
import java.rmi.server.UnicastRemoteObject;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import net.sf.cglib.asm.ClassWriter;
import net.sf.cglib.asm.Type;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import org.apache.tuscany.sca.assembly.Binding;
import org.apache.tuscany.sca.interfacedef.Interface;
import org.apache.tuscany.sca.interfacedef.InterfaceContract;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.interfacedef.java.JavaInterface;
import org.apache.tuscany.sca.interfacedef.java.impl.JavaInterfaceUtil;
import org.apache.tuscany.sca.provider.ServiceBindingProvider;
import org.apache.tuscany.sca.runtime.RuntimeComponent;
import org.apache.tuscany.sca.runtime.RuntimeComponentService;
import org.apache.tuscany.sca.runtime.RuntimeWire;
import org.osoa.sca.ServiceRuntimeException;
import scallop.sca.binding.rmi.RMIBinding;
import scallop.sca.host.rmi.RMIHost;
import scallop.sca.host.rmi.RMIHostException;

public class RMIServiceBindingProvider
implements ServiceBindingProvider {
    private RuntimeComponent component;
    private RuntimeComponentService service;
    private RMIBinding binding;
    private RMIHost rmiHost;
    private RuntimeWire wire;

    public RMIServiceBindingProvider(RuntimeComponent rc, RuntimeComponentService rcs, RMIBinding binding, RMIHost rmiHost) {
        this.component = rc;
        this.service = rcs;
        this.binding = binding;
        this.rmiHost = rmiHost;
    }

    public void start() {
        this.wire = this.service.getRuntimeWire((Binding)this.binding);
        Interface serviceInterface = this.service.getInterfaceContract().getInterface();
        Remote rmiProxy = this.createRmiService(serviceInterface);
        try {
            this.rmiHost.registerService(this.binding.getServiceName(), this.getPort(this.binding.getPort()), rmiProxy);
        }
        catch (RMIHostException e) {
            throw new ServiceRuntimeException((Throwable)e);
        }
    }

    public void stop() {
        this.rmiHost.unregisterService(this.binding.getServiceName(), this.getPort(this.binding.getPort()));
    }

    protected int getPort(String port) {
        int portNumber = 1099;
        if (port != null && port.length() > 0 && (portNumber = Integer.decode(port).intValue()) == -1) {
            portNumber = 1099;
        }
        return portNumber;
    }

    protected Remote createRmiService(final Interface serviceInterface) {
        Enhancer enhancer = new Enhancer();
        enhancer.setSuperclass(UnicastRemoteObject.class);
        enhancer.setCallback((Callback)new MethodInterceptor(){

            /*
             * Unable to fully structure code
             */
            public Object intercept(Object arg0, Method method, Object[] args, MethodProxy arg3) throws Throwable {
                try {
                    return RMIServiceBindingProvider.this.invokeTarget(JavaInterfaceUtil.findOperation((Method)method, (Collection)serviceInterface.getOperations()), args);
                }
                catch (InvocationTargetException e) {
                    cause = e.getCause();
                    var10_7 = method.getExceptionTypes();
                    var9_8 = var10_7.length;
                    var8_9 = 0;
                    ** while (var8_9 < var9_8)
                }
lbl-1000:
                // 1 sources

                {
                    declaredType = var10_7[var8_9];
                    if (declaredType.isInstance(cause)) {
                        throw e;
                    }
                    ++var8_9;
                    continue;
                }
lbl14:
                // 1 sources

                if (cause.getCause() != null) {
                    AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                        @Override
                        public Object run() throws Exception {
                            Field field = Throwable.class.getDeclaredField("cause");
                            field.setAccessible(true);
                            field.set(cause, null);
                            field.setAccessible(false);
                            return null;
                        }
                    });
                }
                throw cause;
            }
        });
        Class<?> targetJavaInterface = this.getTargetJavaClass(serviceInterface);
        if (!Remote.class.isAssignableFrom(targetJavaInterface)) {
            RMIServiceClassLoader classloader = new RMIServiceClassLoader(targetJavaInterface.getClassLoader());
            byte[] byteCode = this.generateRemoteInterface(targetJavaInterface);
            targetJavaInterface = classloader.defineClass(targetJavaInterface.getName(), byteCode);
            enhancer.setClassLoader((ClassLoader)classloader);
        }
        enhancer.setInterfaces(new Class[]{targetJavaInterface});
        return (Remote)enhancer.create();
    }

    protected Object invokeTarget(Operation op, Object[] args) throws InvocationTargetException {
        return this.wire.invoke(op, args);
    }

    protected byte[] generateRemoteInterface(Class serviceInterface) {
        Method[] methods;
        String interfazeName = serviceInterface.getName();
        ClassWriter cw = new ClassWriter(false);
        String simpleName = serviceInterface.getSimpleName();
        cw.visit(49, 1537, interfazeName.replace('.', '/'), "java/lang/Object", new String[]{"java/rmi/Remote"}, String.valueOf(simpleName) + ".java");
        StringBuffer argsAndReturn = null;
        Method[] methodArray = methods = serviceInterface.getMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            argsAndReturn = new StringBuffer("(");
            Class<?>[] paramTypes = method.getParameterTypes();
            Class<?> returnType = method.getReturnType();
            Class<?>[] classArray = paramTypes;
            int n3 = paramTypes.length;
            int n4 = 0;
            while (n4 < n3) {
                Class<?> paramType = classArray[n4];
                argsAndReturn.append(Type.getType(paramType));
                ++n4;
            }
            argsAndReturn.append(")");
            argsAndReturn.append(Type.getType(returnType));
            cw.visitMethod(1025, method.getName(), argsAndReturn.toString(), new String[]{"java/rmi/RemoteException"}, null);
            ++n2;
        }
        cw.visitEnd();
        return cw.toByteArray();
    }

    protected Class<?> getTargetJavaClass(Interface targetInterface) {
        return ((JavaInterface)targetInterface).getJavaClass();
    }

    public InterfaceContract getBindingInterfaceContract() {
        return this.service.getInterfaceContract();
    }

    public boolean supportsOneWayInvocation() {
        return false;
    }

    protected class RMIServiceClassLoader
    extends ClassLoader {
        public RMIServiceClassLoader(ClassLoader parent) {
            super(parent);
        }

        public Class<?> defineClass(String name, byte[] byteArray) {
            return super.defineClass(name, byteArray, 0, byteArray.length);
        }
    }
}

