/*
 * Decompiled with CFR 0.152.
 */
package scallop.sca.binding.rmi.provider;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.rmi.Remote;
import java.rmi.UnexpectedException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.tuscany.sca.invocation.DataExchangeSemantics;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.invocation.Message;
import org.osoa.sca.ServiceRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scallop.api.ScallopRemoteException;
import scallop.core.Observer;
import scallop.core.ScallopClient;
import scallop.core.loadbalance.ResourceLoader;
import scallop.core.thread.factory.DaemonThreadFactory;
import scallop.sca.binding.rmi.provider.RMIObserver;
import scallop.sca.binding.rmi.provider.RMIRemote;
import scallop.sca.host.rmi.RMIHost;
import scallop.sca.host.rmi.RMIHostRuntimeException;

public class RMIReferenceLoadBalanceInvoker
implements Invoker,
DataExchangeSemantics {
    private static final Logger logger = LoggerFactory.getLogger(RMIReferenceLoadBalanceInvoker.class);
    private RMIHost rmiHost;
    private String registryCenter;
    private String registryName;
    private String svcName;
    private Method remoteMethod;
    private RMIObserver observer;
    private static final String POINT = ".";
    private static final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new DaemonThreadFactory(""));
    private static Map<String, Long> methodExecuteMap;

    static {
        if (logger.isInfoEnabled()) {
            scheduler.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    for (Map.Entry entry : methodExecuteMap.entrySet()) {
                        logger.info("method invoke stat: " + (String)entry.getKey() + " count: " + entry.getValue() + " interval: " + ScallopClient.getInstance().getRmiExecuteTimesPrintInterval() + " rate: " + (Long)entry.getValue() / (ScallopClient.getInstance().getRmiExecuteTimesPrintInterval() / 60L) + " t/m");
                    }
                    methodExecuteMap = new ConcurrentHashMap();
                }
            }, ScallopClient.getInstance().getRmiExecuteTimesPrintInterval(), ScallopClient.getInstance().getRmiExecuteTimesPrintInterval(), TimeUnit.SECONDS);
        }
        methodExecuteMap = new ConcurrentHashMap<String, Long>();
    }

    public RMIReferenceLoadBalanceInvoker(RMIHost rmiHost, String registryCenter, String registryName, String svcName, Method remoteMethod) throws ConnectException, NumberFormatException, ScallopRemoteException {
        this.rmiHost = rmiHost;
        this.remoteMethod = remoteMethod;
        this.svcName = svcName;
        ScallopClient sc = ScallopClient.getInstance();
        this.registryName = registryName;
        this.registryCenter = sc.getRealRegistryCenter(registryCenter);
        this.observer = new RMIObserver(this.registryCenter, this.registryName);
        sc.registerObserver((Observer)this.observer);
        this.observer.update();
    }

    public Message invoke(Message msg) {
        try {
            Object[] args = (Object[])msg.getBody();
            Object resp = this.invokeTarget(args);
            msg.setBody(resp);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof ServiceRuntimeException) {
                msg.setFaultBody((Object)e.getCause().getCause());
            } else {
                msg.setFaultBody((Object)e.getCause());
            }
        }
        catch (Throwable e) {
            msg.setFaultBody((Object)e);
        }
        return msg;
    }

    private void statMethodExecute(String svcName, String method) {
        String key = new StringBuffer(svcName).append(POINT).append(method).toString();
        Long counter = methodExecuteMap.get(key);
        counter = counter == null ? Long.valueOf(1L) : Long.valueOf(counter + 1L);
        methodExecuteMap.put(key, counter);
    }

    public Object invokeTarget(Object payload) throws InvocationTargetException, SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, Throwable {
        ResourceLoader rr;
        long startTime = 0L;
        if (logger.isInfoEnabled()) {
            startTime = System.currentTimeMillis();
            this.statMethodExecute(this.svcName, this.remoteMethod.getName());
        }
        if ((rr = this.observer.getLoadBalancer().get()) == null) {
            logger.info("reupdate observer ");
            this.observer.update();
            rr = this.observer.getLoadBalancer().get();
        }
        RMIRemote lbr = (RMIRemote)rr.getResource();
        Remote proxy = ((RMIRemote)rr.getResource()).getProxy();
        try {
            long time;
            if (proxy == null) {
                proxy = this.rmiHost.findService(lbr.getHost(), lbr.getPort(), this.svcName);
                lbr.setProxy(proxy);
            }
            this.remoteMethod = proxy.getClass().getMethod(this.remoteMethod.getName(), this.remoteMethod.getParameterTypes());
            if (payload != null && !payload.getClass().isArray()) {
                long time2;
                Object obj = this.remoteMethod.invoke((Object)proxy, payload);
                if (logger.isInfoEnabled() && (time2 = System.currentTimeMillis() - startTime) > ScallopClient.getInstance().getRmiProcessTimeThreshold()) {
                    if (ScallopClient.getInstance().getRmiShowParameters()) {
                        logger.info(new StringBuffer("method process stat: ").append(this.svcName).append(POINT).append(this.remoteMethod.getName()).append(" time: ").append(time2).append(" params:").append(payload).toString());
                    } else {
                        logger.info(new StringBuffer("method process stat: ").append(this.svcName).append(POINT).append(this.remoteMethod.getName()).append(" time: ").append(time2).toString());
                    }
                }
                return obj;
            }
            Object obj = this.remoteMethod.invoke((Object)proxy, (Object[])payload);
            if (logger.isInfoEnabled() && (time = System.currentTimeMillis() - startTime) > ScallopClient.getInstance().getRmiProcessTimeThreshold()) {
                logger.info(" ip " + lbr);
                Object[] objs = (Object[])payload;
                if (ScallopClient.getInstance().getRmiShowParameters()) {
                    StringBuffer sb = new StringBuffer();
                    int i = 0;
                    int length = objs.length;
                    while (i < length) {
                        sb.append(i).append(":").append(objs[i]).append(")");
                        ++i;
                    }
                    logger.info(new StringBuffer("method process stat: ").append(this.svcName).append(POINT).append(this.remoteMethod.getName()).append(" time: ").append(time).append(" params:").append(sb.toString()).toString());
                } else {
                    logger.info(new StringBuffer("method process stat: ").append(this.svcName).append(POINT).append(this.remoteMethod.getName()).append(" time: ").append(time).toString());
                }
            }
            return obj;
        }
        catch (RMIHostRuntimeException exp) {
            return this.switchInvoke((ResourceLoader<RMIRemote>)rr, lbr, payload, this.remoteMethod);
        }
        catch (InvocationTargetException exp) {
            if (exp.getCause() != null && exp.getCause().getCause() instanceof UnexpectedException) {
                if (exp.getCause().getCause().getCause() != null && exp.getCause().getCause().getCause().getCause() instanceof SocketTimeoutException) {
                    throw exp.getCause().getCause().getCause().getCause();
                }
                return this.switchInvoke((ResourceLoader<RMIRemote>)rr, lbr, payload, this.remoteMethod);
            }
            throw exp;
        }
    }

    private Object switchInvoke(ResourceLoader<RMIRemote> rr, RMIRemote lbr, Object payload, Method remoteMethod) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        this.observer.removeRemote(lbr);
        return this.reinvoke(rr, lbr, payload, remoteMethod, false);
    }

    protected Object reinvoke(ResourceLoader<RMIRemote> rr, RMIRemote lbr, Object payload, Method remoteMethod, boolean isUpdate) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Remote proxy = null;
        if (isUpdate) {
            try {
                proxy = this.rmiHost.findService(lbr.getHost(), lbr.getPort(), this.svcName);
                lbr.setProxy(proxy);
            }
            catch (Exception e) {
                logger.warn("rmi find service failure. host:" + lbr.getHost() + " port:" + lbr.getPort() + " svcName:" + this.svcName + " message" + e.getMessage(), (Throwable)e);
            }
        }
        if (this.observer.getLoadBalancer().getResourceSize() >= 1) {
            rr = this.observer.getLoadBalancer().get(rr);
            lbr = (RMIRemote)rr.getResource();
            proxy = ((RMIRemote)rr.getResource()).getProxy();
            if (proxy == null) {
                logger.info("null proxy");
                proxy = this.rmiHost.findService(lbr.getHost(), lbr.getPort(), this.svcName);
                lbr.setProxy(proxy);
            }
        } else {
            logger.info(" no proxy ,so refind service atonce ");
            proxy = this.rmiHost.findService(lbr.getHost(), lbr.getPort(), this.svcName);
            lbr.setProxy(proxy);
            logger.info("and we will update observer ");
            try {
                this.observer.update();
            }
            catch (ScallopRemoteException e) {
                e.printStackTrace();
            }
        }
        if (payload != null && !payload.getClass().isArray()) {
            return remoteMethod.invoke((Object)proxy, payload);
        }
        return remoteMethod.invoke((Object)proxy, (Object[])payload);
    }

    public boolean allowsPassByReference() {
        return true;
    }
}

