/*
 * Decompiled with CFR 0.152.
 */
package scallop.sca.binding.rmi.provider;

import java.lang.reflect.Method;
import org.apache.tuscany.sca.interfacedef.InterfaceContract;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.interfacedef.java.JavaInterface;
import org.apache.tuscany.sca.interfacedef.java.impl.JavaInterfaceUtil;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.provider.ReferenceBindingProvider;
import org.apache.tuscany.sca.runtime.RuntimeComponent;
import org.apache.tuscany.sca.runtime.RuntimeComponentReference;
import org.osoa.sca.ServiceRuntimeException;
import scallop.sca.binding.rmi.RMIBinding;
import scallop.sca.binding.rmi.provider.RMIReferenceInvoker;
import scallop.sca.binding.rmi.provider.RMIReferenceLoadBalanceInvoker;
import scallop.sca.host.rmi.RMIHost;

public class RMIReferenceBindingProvider
implements ReferenceBindingProvider {
    private RuntimeComponentReference reference;
    private RMIHost rmiHost;
    private RMIBinding binding;

    public RMIReferenceBindingProvider(RuntimeComponent rc, RuntimeComponentReference rcr, RMIBinding binding, RMIHost rmiHost) {
        this.reference = rcr;
        this.rmiHost = rmiHost;
        this.binding = binding;
    }

    public Invoker createInvoker(Operation operation) {
        try {
            Class iface = ((JavaInterface)this.reference.getInterfaceContract().getInterface()).getJavaClass();
            Method remoteMethod = JavaInterfaceUtil.findMethod((Class)iface, (Operation)operation);
            if (this.binding.getRegistryName() != null && this.binding.getRegistryName().trim().length() > 0) {
                return new RMIReferenceLoadBalanceInvoker(this.rmiHost, this.binding.getRegistryCenter(), this.binding.getRegistryName(), this.binding.getServiceName(), remoteMethod);
            }
            return new RMIReferenceInvoker(this.rmiHost, this.binding.getHost(), this.binding.getPort(), this.binding.getServiceName(), remoteMethod);
        }
        catch (Exception e) {
            throw new ServiceRuntimeException(operation.toString(), (Throwable)e);
        }
    }

    public InterfaceContract getBindingInterfaceContract() {
        return this.reference.getInterfaceContract();
    }

    public void start() {
    }

    public void stop() {
    }

    public boolean supportsOneWayInvocation() {
        return false;
    }
}

