/*
 * Decompiled with CFR 0.152.
 */
package scallop.sca.binding.rmi.provider;

import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scallop.api.ScallopRemoteException;
import scallop.core.Observer;
import scallop.core.Resource;
import scallop.core.ResourceParser;
import scallop.core.ScallopClient;
import scallop.core.loadbalance.LoadBalancer;
import scallop.core.loadbalance.RoundRobinLoadBalancer;
import scallop.sca.binding.rmi.provider.RMIRemote;
import scallop.sca.binding.rmi.provider.RMIResourceParser;

public class RMIObserver
implements Observer {
    private static final Logger logger = LoggerFactory.getLogger(RMIObserver.class);
    private LoadBalancer<RMIRemote> loadBalancer;
    private String registryCenter;
    private String registryName;
    private static final String COLON = ":";

    public void update() throws ScallopRemoteException {
        Resource resource = ScallopClient.getInstance().getResource(this.registryCenter, this.registryName, (ResourceParser)new RMIResourceParser());
        if (resource.getResource().size() == 0) {
            throw new ScallopRemoteException("can not get resource. resource name:" + this.registryName);
        }
        ArrayList<RMIRemote> remotes = new ArrayList<RMIRemote>();
        for (String res : resource.getResource()) {
            String[] hostPort = res.split(COLON);
            remotes.add(new RMIRemote(hostPort[0], hostPort[1], null));
        }
        if (this.loadBalancer == null) {
            this.loadBalancer = new RoundRobinLoadBalancer(remotes);
        } else {
            ArrayList<RMIRemote> newRmiRemotes = new ArrayList<RMIRemote>();
            List rmiRemotes = this.loadBalancer.getResources();
            for (RMIRemote rr : remotes) {
                if (rmiRemotes.indexOf(rr) != -1) continue;
                newRmiRemotes.add(rr);
            }
            ArrayList<RMIRemote> uselessRmiRemotes = new ArrayList<RMIRemote>();
            for (RMIRemote rr : rmiRemotes) {
                if (remotes.indexOf(rr) != -1) continue;
                uselessRmiRemotes.add(rr);
            }
            if (!newRmiRemotes.isEmpty()) {
                rmiRemotes.addAll(newRmiRemotes);
            }
            if (!uselessRmiRemotes.isEmpty()) {
                rmiRemotes.removeAll(uselessRmiRemotes);
            }
        }
    }

    public RMIObserver(String registryCenter, String registryName) {
        this.registryCenter = registryCenter;
        this.registryName = registryName;
    }

    public LoadBalancer<RMIRemote> getLoadBalancer() {
        return this.loadBalancer;
    }

    public void removeRemote(RMIRemote lbr) {
        List rmiRemotes = this.loadBalancer.getResources();
        logger.info(" old useproxy  " + rmiRemotes);
        Integer size = rmiRemotes.size();
        rmiRemotes.remove(lbr);
        logger.info(" remove proxy  " + lbr + " count " + (rmiRemotes.size() - size));
        logger.info(" current useproxy  " + rmiRemotes);
    }
}

