/*
 * Decompiled with CFR 0.152.
 */
package scallop.sca.binding.jms.transport;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.JMSException;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.naming.NamingException;
import org.apache.tuscany.sca.core.assembly.EndpointReferenceImpl;
import org.apache.tuscany.sca.invocation.Interceptor;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.invocation.Message;
import org.apache.tuscany.sca.runtime.EndpointReference;
import org.apache.tuscany.sca.runtime.ReferenceParameters;
import org.apache.tuscany.sca.runtime.RuntimeComponentService;
import org.apache.tuscany.sca.runtime.RuntimeWire;
import scallop.sca.binding.jms.context.JMSBindingContext;
import scallop.sca.binding.jms.impl.JMSBinding;
import scallop.sca.binding.jms.impl.JMSBindingException;
import scallop.sca.binding.jms.provider.JMSMessageProcessor;
import scallop.sca.binding.jms.provider.JMSMessageProcessorUtil;
import scallop.sca.binding.jms.provider.JMSResourceFactory;

public class TransportServiceInterceptor
implements Interceptor {
    private static final Logger logger = Logger.getLogger(TransportServiceInterceptor.class.getName());
    private Invoker next;
    private RuntimeWire runtimeWire;
    private JMSResourceFactory jmsResourceFactory;
    private JMSBinding jmsBinding;
    private JMSMessageProcessor requestMessageProcessor;
    private JMSMessageProcessor responseMessageProcessor;
    private RuntimeComponentService service;
    private String correlationScheme;

    public TransportServiceInterceptor(JMSBinding jmsBinding, JMSResourceFactory jmsResourceFactory, RuntimeWire runtimeWire) {
        this.jmsBinding = jmsBinding;
        this.runtimeWire = runtimeWire;
        this.jmsResourceFactory = jmsResourceFactory;
        this.requestMessageProcessor = JMSMessageProcessorUtil.getRequestMessageProcessor(jmsBinding);
        this.responseMessageProcessor = JMSMessageProcessorUtil.getResponseMessageProcessor(jmsBinding);
        this.service = (RuntimeComponentService)runtimeWire.getTarget().getContract();
        this.correlationScheme = jmsBinding.getCorrelationScheme();
    }

    public Message invoke(Message msg) {
        try {
            return this.invokeResponse(this.next.invoke(this.invokeRequest(msg)));
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, "Exception invoking service '" + this.service.getName(), e);
            JMSBindingContext context = (JMSBindingContext)msg.getBindingContext();
            javax.jms.Message replyJMSMsg = this.responseMessageProcessor.createFaultMessage(context.getJmsSession(), e);
            msg.setBody((Object)replyJMSMsg);
            this.invokeResponse(msg);
            return msg;
        }
    }

    public Message invokeRequest(Message msg) {
        try {
            JMSBindingContext context = (JMSBindingContext)msg.getBindingContext();
            javax.jms.Message requestJMSMsg = context.getJmsMsg();
            context.setJmsSession(context.getJmsResourceFactory().createSession());
            EndpointReferenceImpl from = new EndpointReferenceImpl(null);
            msg.setFrom((EndpointReference)from);
            from.setCallbackEndpoint((EndpointReference)new EndpointReferenceImpl("/"));
            ReferenceParameters parameters = from.getReferenceParameters();
            String conversationID = requestJMSMsg.getStringProperty("scaConversationId");
            if (conversationID != null) {
                parameters.setConversationID((Object)conversationID);
            }
            return msg;
        }
        catch (JMSException e) {
            throw new JMSBindingException((Throwable)e);
        }
        catch (NamingException e) {
            throw new JMSBindingException((Throwable)e);
        }
    }

    public Message invokeResponse(Message msg) {
        Session session = null;
        try {
            JMSBindingContext context = (JMSBindingContext)msg.getBindingContext();
            session = context.getJmsSession();
            javax.jms.Message requestJMSMsg = context.getJmsMsg();
            javax.jms.Message responseJMSMsg = (javax.jms.Message)msg.getBody();
            if (requestJMSMsg.getJMSReplyTo() == null) {
                if (msg.getBody() != null) {
                    logger.log(Level.FINE, "JMS service '" + this.service.getName() + "' dropped response as request has no replyTo");
                }
                Message message = msg;
                return message;
            }
            responseJMSMsg.setJMSDeliveryMode(requestJMSMsg.getJMSDeliveryMode());
            responseJMSMsg.setJMSPriority(requestJMSMsg.getJMSPriority());
            if (this.correlationScheme == null || "requestmsgidtocorrelid".equalsIgnoreCase(this.correlationScheme)) {
                responseJMSMsg.setJMSCorrelationID(requestJMSMsg.getJMSMessageID());
            } else if ("requestcorrelidtocorrelid".equalsIgnoreCase(this.correlationScheme)) {
                responseJMSMsg.setJMSCorrelationID(requestJMSMsg.getJMSCorrelationID());
            }
            MessageProducer producer = session.createProducer(context.getReplyToDestination());
            producer.send((javax.jms.Message)msg.getBody());
            producer.close();
            Message message = msg;
            return message;
        }
        catch (JMSException e) {
            throw new JMSBindingException((Throwable)e);
        }
        finally {
            if (session != null) {
                try {
                    session.close();
                }
                catch (JMSException e) {
                    throw new JMSBindingException((Throwable)e);
                }
            }
        }
    }

    public Invoker getNext() {
        return this.next;
    }

    public void setNext(Invoker next) {
        this.next = next;
    }
}

