/*
 * Decompiled with CFR 0.152.
 */
package ytx.org.apache.http.impl.client;

import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import ytx.org.apache.http.Header;
import ytx.org.apache.http.HttpEntityEnclosingRequest;
import ytx.org.apache.http.HttpHost;
import ytx.org.apache.http.HttpRequest;
import ytx.org.apache.http.HttpResponse;
import ytx.org.apache.http.ProtocolException;
import ytx.org.apache.http.annotation.Immutable;
import ytx.org.apache.http.client.CircularRedirectException;
import ytx.org.apache.http.client.RedirectStrategy;
import ytx.org.apache.http.client.methods.HttpDelete;
import ytx.org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import ytx.org.apache.http.client.methods.HttpGet;
import ytx.org.apache.http.client.methods.HttpHead;
import ytx.org.apache.http.client.methods.HttpOptions;
import ytx.org.apache.http.client.methods.HttpPatch;
import ytx.org.apache.http.client.methods.HttpPost;
import ytx.org.apache.http.client.methods.HttpPut;
import ytx.org.apache.http.client.methods.HttpTrace;
import ytx.org.apache.http.client.methods.HttpUriRequest;
import ytx.org.apache.http.client.utils.URIUtils;
import ytx.org.apache.http.impl.client.RedirectLocations;
import ytx.org.apache.http.params.HttpParams;
import ytx.org.apache.http.protocol.HttpContext;

@Immutable
public class DefaultRedirectStrategy
implements RedirectStrategy {
    private final Log log = LogFactory.getLog(this.getClass());
    public static final String REDIRECT_LOCATIONS = "http.protocol.redirect-locations";
    private static final String[] REDIRECT_METHODS = new String[]{"GET", "HEAD"};

    @Override
    public boolean isRedirected(HttpRequest request, HttpResponse response, HttpContext context) throws ProtocolException {
        if (request == null) {
            throw new IllegalArgumentException("HTTP request may not be null");
        }
        if (response == null) {
            throw new IllegalArgumentException("HTTP response may not be null");
        }
        int statusCode = response.getStatusLine().getStatusCode();
        String method = request.getRequestLine().getMethod();
        Header locationHeader = response.getFirstHeader("location");
        switch (statusCode) {
            case 302: {
                return this.isRedirectable(method) && locationHeader != null;
            }
            case 301: 
            case 307: {
                return this.isRedirectable(method);
            }
            case 303: {
                return true;
            }
        }
        return false;
    }

    public URI getLocationURI(HttpRequest request, HttpResponse response, HttpContext context) throws ProtocolException {
        if (request == null) {
            throw new IllegalArgumentException("HTTP request may not be null");
        }
        if (response == null) {
            throw new IllegalArgumentException("HTTP response may not be null");
        }
        if (context == null) {
            throw new IllegalArgumentException("HTTP context may not be null");
        }
        Header locationHeader = response.getFirstHeader("location");
        if (locationHeader == null) {
            throw new ProtocolException("Received redirect response " + response.getStatusLine() + " but no location header");
        }
        String location = locationHeader.getValue();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Redirect requested to location '" + location + "'");
        }
        URI uri = this.createLocationURI(location);
        HttpParams params = request.getParams();
        try {
            uri = URIUtils.rewriteURI(uri);
            if (!uri.isAbsolute()) {
                if (params.isParameterTrue("http.protocol.reject-relative-redirect")) {
                    throw new ProtocolException("Relative redirect location '" + uri + "' not allowed");
                }
                HttpHost target = (HttpHost)context.getAttribute("http.target_host");
                if (target == null) {
                    throw new IllegalStateException("Target host not available in the HTTP context");
                }
                URI requestURI = new URI(request.getRequestLine().getUri());
                URI absoluteRequestURI = URIUtils.rewriteURI(requestURI, target, true);
                uri = URIUtils.resolve(absoluteRequestURI, uri);
            }
        }
        catch (URISyntaxException ex) {
            throw new ProtocolException(ex.getMessage(), ex);
        }
        RedirectLocations redirectLocations = (RedirectLocations)context.getAttribute(REDIRECT_LOCATIONS);
        if (redirectLocations == null) {
            redirectLocations = new RedirectLocations();
            context.setAttribute(REDIRECT_LOCATIONS, redirectLocations);
        }
        if (params.isParameterFalse("http.protocol.allow-circular-redirects") && redirectLocations.contains(uri)) {
            throw new CircularRedirectException("Circular redirect to '" + uri + "'");
        }
        redirectLocations.add(uri);
        return uri;
    }

    protected URI createLocationURI(String location) throws ProtocolException {
        try {
            return new URI(location).normalize();
        }
        catch (URISyntaxException ex) {
            throw new ProtocolException("Invalid redirect URI: " + location, ex);
        }
    }

    protected boolean isRedirectable(String method) {
        String[] stringArray = REDIRECT_METHODS;
        int n = REDIRECT_METHODS.length;
        int n2 = 0;
        while (n2 < n) {
            String m = stringArray[n2];
            if (m.equalsIgnoreCase(method)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public HttpUriRequest getRedirect(HttpRequest request, HttpResponse response, HttpContext context) throws ProtocolException {
        URI uri = this.getLocationURI(request, response, context);
        String method = request.getRequestLine().getMethod();
        if (method.equalsIgnoreCase("HEAD")) {
            return new HttpHead(uri);
        }
        if (method.equalsIgnoreCase("GET")) {
            return new HttpGet(uri);
        }
        int status = response.getStatusLine().getStatusCode();
        if (status == 307) {
            if (method.equalsIgnoreCase("POST")) {
                return this.copyEntity(new HttpPost(uri), request);
            }
            if (method.equalsIgnoreCase("PUT")) {
                return this.copyEntity(new HttpPut(uri), request);
            }
            if (method.equalsIgnoreCase("DELETE")) {
                return new HttpDelete(uri);
            }
            if (method.equalsIgnoreCase("TRACE")) {
                return new HttpTrace(uri);
            }
            if (method.equalsIgnoreCase("OPTIONS")) {
                return new HttpOptions(uri);
            }
            if (method.equalsIgnoreCase("PATCH")) {
                return this.copyEntity(new HttpPatch(uri), request);
            }
        }
        return new HttpGet(uri);
    }

    private HttpUriRequest copyEntity(HttpEntityEnclosingRequestBase redirect, HttpRequest original) {
        if (original instanceof HttpEntityEnclosingRequest) {
            redirect.setEntity(((HttpEntityEnclosingRequest)original).getEntity());
        }
        return redirect;
    }
}

