/*
 * Decompiled with CFR 0.152.
 */
package ytx.org.apache.http.client.protocol;

import java.io.IOException;
import java.util.Locale;
import ytx.org.apache.http.Header;
import ytx.org.apache.http.HeaderElement;
import ytx.org.apache.http.HttpEntity;
import ytx.org.apache.http.HttpException;
import ytx.org.apache.http.HttpResponse;
import ytx.org.apache.http.HttpResponseInterceptor;
import ytx.org.apache.http.annotation.Immutable;
import ytx.org.apache.http.client.entity.DeflateDecompressingEntity;
import ytx.org.apache.http.client.entity.GzipDecompressingEntity;
import ytx.org.apache.http.protocol.HttpContext;

@Immutable
public class ResponseContentEncoding
implements HttpResponseInterceptor {
    public static final String UNCOMPRESSED = "http.client.response.uncompressed";

    @Override
    public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
        Header ceheader;
        HttpEntity entity = response.getEntity();
        if (entity != null && (ceheader = entity.getContentEncoding()) != null) {
            HeaderElement[] codecs;
            HeaderElement[] headerElementArray = codecs = ceheader.getElements();
            if (codecs.length != 0) {
                HeaderElement codec = headerElementArray[0];
                String codecname = codec.getName().toLowerCase(Locale.US);
                if ("gzip".equals(codecname) || "x-gzip".equals(codecname)) {
                    response.setEntity(new GzipDecompressingEntity(response.getEntity()));
                    if (context != null) {
                        context.setAttribute(UNCOMPRESSED, true);
                    }
                    return;
                }
                if ("deflate".equals(codecname)) {
                    response.setEntity(new DeflateDecompressingEntity(response.getEntity()));
                    if (context != null) {
                        context.setAttribute(UNCOMPRESSED, true);
                    }
                    return;
                }
                if ("identity".equals(codecname)) {
                    return;
                }
                throw new HttpException("Unsupported Content-Coding: " + codec.getName());
            }
        }
    }
}

