/*
 * Decompiled with CFR 0.152.
 */
package com.qding.common.util.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GsonUtil {
    private static final Log log = LogFactory.getLog(GsonUtil.class);

    public static <T> T fromJson(String json, Class<T> clasz) {
        Gson gson = new GsonBuilder().create();
        return (T)gson.fromJson(json, clasz);
    }

    public static String toJson(Object src) {
        Gson gson = new GsonBuilder().create();
        return gson.toJson(src);
    }

    public static String get(String key, String snapshot) {
        if (StringUtils.isBlank((CharSequence)key) || StringUtils.isBlank((CharSequence)snapshot)) {
            return null;
        }
        Gson gson = new GsonBuilder().create();
        Map map = null;
        try {
            map = (Map)gson.fromJson(snapshot, new TypeToken<Map<String, String>>(){}.getType());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (MapUtils.isEmpty(map)) {
            return null;
        }
        return (String)map.get(key);
    }

    public static String put(String snapshot, String key, String value) {
        Gson gson = new GsonBuilder().create();
        Map map = (Map)gson.fromJson(snapshot, new TypeToken<Map<String, String>>(){}.getType());
        map.put(key, value);
        return gson.toJson((Object)map);
    }

    public static void main(String[] args) {
        Gson gson = new GsonBuilder().create();
        ArrayList list = new ArrayList();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("key", "xxxxxxx");
        map.put("value", "xxxxxxx");
        HashMap<String, String> map2 = new HashMap<String, String>();
        map2.put("key", "\u9000\u8d27\u8bf4\u660e");
        map2.put("value", "zzz");
        list.add(map);
        list.add(map2);
        String content = gson.toJson(list);
        log.info((Object)("content is " + content));
        List maps = (List)gson.fromJson(content, new TypeToken<List<Map<String, String>>>(){}.getType());
        log.info((Object)("map is " + maps));
    }
}

