/*
 * Decompiled with CFR 0.152.
 */
package com.qding.common.util.http.cookie;

import com.qding.common.util.http.cookie.DESUtil;
import com.qding.common.util.http.cookie.MD5Util;
import com.qding.common.util.http.cookie.XBase64;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections.LRUMap;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class UserCryptUtil {
    private static Log log = LogFactory.getLog(UserCryptUtil.class);
    private static String SEPARATAOR_STRING = "*";
    private static String SEPARATAOR_STR_L3 = ",";
    private static String TIME_KEY = "loginTime";
    private static Map<String, String> ciphertextMap = Collections.synchronizedMap(new LRUMap(5000));

    public static String userEncrypt(String passport, Long userId) {
        String userInfo = UserCryptUtil.createUserInfo(passport, userId);
        StringBuffer sb = new StringBuffer();
        try {
            String md5UserInfo = MD5Util.getMd5Sum(userInfo);
            String encrStr = DESUtil.encrypt(userInfo.getBytes());
            encrStr = XBase64.enReplace(encrStr);
            sb.append(md5UserInfo).append(SEPARATAOR_STRING).append(encrStr);
            return sb.toString();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            return null;
        }
    }

    public static String userEncrypt(Map<String, String> params, Long userId) {
        String userInfo = UserCryptUtil.createUserInfo(params, userId);
        StringBuffer sb = new StringBuffer();
        try {
            String md5UserInfo = MD5Util.getMd5Sum(userInfo);
            String encrStr = DESUtil.encrypt(userInfo.getBytes());
            encrStr = XBase64.enReplace(encrStr);
            sb.append(md5UserInfo).append(SEPARATAOR_STRING).append(encrStr);
            return sb.toString();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            return null;
        }
    }

    private static String createUserInfo(String passport, Long userId) {
        StringBuffer sb = new StringBuffer();
        sb.append(StringUtils.defaultIfEmpty((String)passport, (String)"")).append(SEPARATAOR_STRING).append(ObjectUtils.toString((Object)userId, (String)"")).append(SEPARATAOR_STRING).append(System.currentTimeMillis()).append(SEPARATAOR_STRING);
        log.debug((Object)("userInfo: " + sb.toString()));
        return sb.toString();
    }

    private static String createUserInfo(Map<String, String> params, Long userId) {
        StringBuffer sb = new StringBuffer();
        if (MapUtils.isNotEmpty(params)) {
            for (Map.Entry<String, String> entry : params.entrySet()) {
                if (!StringUtils.isNotBlank((String)entry.getKey()) || !StringUtils.isNotBlank((String)entry.getValue())) continue;
                sb.append(entry.getKey()).append(SEPARATAOR_STR_L3).append(entry.getValue()).append(SEPARATAOR_STRING);
            }
        }
        sb.append(TIME_KEY).append(SEPARATAOR_STR_L3).append(System.currentTimeMillis()).append(SEPARATAOR_STRING);
        log.debug((Object)("userInfo: " + sb.toString()));
        return sb.toString();
    }

    public static String userDecrypt(String enUserInfo) {
        if (StringUtils.isEmpty((String)enUserInfo)) {
            return null;
        }
        String plainStr = ciphertextMap.get(enUserInfo);
        if (StringUtils.isNotBlank((String)plainStr)) {
            return plainStr;
        }
        String md5 = StringUtils.substringBefore((String)enUserInfo, (String)SEPARATAOR_STRING);
        String encrStr = StringUtils.substringAfter((String)enUserInfo, (String)SEPARATAOR_STRING);
        if (StringUtils.isNotEmpty((String)md5) && StringUtils.isNotEmpty((String)encrStr)) {
            try {
                encrStr = XBase64.deReplace(encrStr);
                plainStr = DESUtil.decrypt(encrStr.getBytes());
                if (StringUtils.isNotEmpty((String)plainStr)) {
                    String md5UserInfo = MD5Util.getMd5Sum(plainStr);
                    if (ObjectUtils.equals((Object)md5UserInfo, (Object)md5)) {
                        ciphertextMap.put(enUserInfo, plainStr);
                        return plainStr;
                    }
                    return null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static String getUserNameFromPlain(String plainUserInfo) {
        if (StringUtils.isNotEmpty((String)plainUserInfo) && UserCryptUtil.isformat(plainUserInfo)) {
            return StringUtils.substringBefore((String)plainUserInfo, (String)SEPARATAOR_STRING);
        }
        return null;
    }

    public static Map<String, String> getMapFromPlain(String plainUserInfo) {
        String[] strs;
        HashMap<String, String> map = null;
        if (StringUtils.isNotEmpty((String)plainUserInfo) && UserCryptUtil.isformat(plainUserInfo) && null != (strs = StringUtils.split((String)plainUserInfo, (String)SEPARATAOR_STRING))) {
            map = new HashMap<String, String>();
            for (int i = 0; i < strs.length; ++i) {
                String[] value;
                if (!StringUtils.isNotBlank((String)strs[i]) || null == (value = StringUtils.split((String)strs[i], (String)SEPARATAOR_STR_L3))) continue;
                map.put(value[0], value[1]);
            }
        }
        return map;
    }

    public static Long getUserIdFromPlain(String plainUserInfo) {
        if (StringUtils.isNotEmpty((String)plainUserInfo) && UserCryptUtil.isformat(plainUserInfo)) {
            String[] infos = StringUtils.split((String)plainUserInfo, (String)SEPARATAOR_STRING);
            String userId = infos != null && infos.length >= 2 ? infos[1] : null;
            return StringUtils.isNotBlank(userId) && StringUtils.isNumeric((String)userId) ? Long.valueOf(NumberUtils.toLong((String)userId)) : null;
        }
        return null;
    }

    public static Long getUserIdFromCipher(String cipUserInfo) {
        String plainUserInfo = UserCryptUtil.userDecrypt(cipUserInfo);
        return UserCryptUtil.getUserIdFromPlain(plainUserInfo);
    }

    private static boolean isformat(String plainUserInfo) {
        return true;
    }

    public static void main(String[] args) {
        String enUserInfo = UserCryptUtil.userEncrypt("wywy_1208@hotmail.com", (Long)67789L);
        System.out.println(enUserInfo);
        String orgUserInfo = UserCryptUtil.userDecrypt(enUserInfo);
        System.out.println(orgUserInfo);
        System.out.println(UserCryptUtil.getUserIdFromPlain(orgUserInfo));
    }
}

