/*
 * Decompiled with CFR 0.152.
 */
package com.qding.common.util.http.cookie;

import com.qding.common.util.http.cookie.IdentityUtil;
import com.qding.common.util.http.cookie.MD5Util;
import com.qding.common.util.http.cookie.RequestUtil;
import java.security.NoSuchAlgorithmException;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CookieUtil {
    private static Log log = LogFactory.getLog(CookieUtil.class);
    public Integer cookieMaxAge = 1209600;
    private String home = "www.rxhui.com";
    private String domain = ".rxhui.com";
    public static final String verifyCode = "verifyCode";
    public static final String USER_CODE = "userCode";
    public static final String USER_ID = "userId";
    public static final String USER_NAME = "userName";
    public static final String SAVE_TIME = "saveTime";
    public static final String KAPTCHA = "Kaptcha";
    public static final String CURRENT_VISITOR = "currentVisitor";
    public static final String REFERER = "referer";
    public static final Long NONLOGIN_USER_ID = -1L;

    public void setIdentity(HttpServletRequest request, HttpServletResponse response, String userName, Long userId) {
        if (null != this.cookieMaxAge && 0 != this.cookieMaxAge) {
            IdentityUtil.setIdentity(request, response, this.home, userName, userId, (int)this.cookieMaxAge);
        } else {
            IdentityUtil.setIdentity(request, response, this.home, userName, userId);
        }
    }

    public void setIdentity(HttpServletRequest request, HttpServletResponse response, Map<String, String> params, Long userId) {
        if (null != this.cookieMaxAge && 0 != this.cookieMaxAge) {
            IdentityUtil.setIdentity(request, response, this.home, params, userId, (int)this.cookieMaxAge);
        } else {
            IdentityUtil.setIdentity(request, response, this.home, params, userId);
        }
    }

    public Map getIdentity(HttpServletRequest request, HttpServletResponse response) {
        Map userMap = IdentityUtil.getIdentity(request, this.home);
        if (null != userMap) {
            // empty if block
        }
        return userMap;
    }

    public String getKeyIdentity(HttpServletRequest request, String key) {
        Map<String, String> map = this.getIdentity(request);
        return map.get(key);
    }

    public Map<String, String> getIdentity(HttpServletRequest request) {
        Map<String, String> userMap = IdentityUtil.getMapFromCookie(request, this.home);
        if (null == userMap) {
            userMap = new HashMap<String, String>();
        }
        return userMap;
    }

    public void deleteIdentity(HttpServletRequest request, HttpServletResponse response) {
        IdentityUtil.deleteIdentity(request, response, this.home);
    }

    public Long getID(HttpServletRequest request, HttpServletResponse response) {
        Map map = this.getIdentity(request, response);
        if (map == null) {
            return null;
        }
        return (Long)map.get(USER_ID);
    }

    public Long getID(HttpServletRequest request) {
        Map<String, String> map = this.getIdentity(request);
        if (null == map || null == map.get(USER_ID)) {
            return null;
        }
        Long userId = Long.valueOf(map.get(USER_ID).toString());
        return userId;
    }

    public String getName(HttpServletRequest request, HttpServletResponse response) {
        Map map = this.getIdentity(request, response);
        if (map == null || StringUtils.isBlank((String)map.get(USER_NAME).toString())) {
            return null;
        }
        return (String)map.get(USER_NAME);
    }

    public void setIdentity(HttpServletRequest request, HttpServletResponse response, String kaptcha) {
        String value = null;
        try {
            value = MD5Util.getMd5Sum(kaptcha);
        }
        catch (NoSuchAlgorithmException e) {
            log.error((Object)"got error when getMD5", (Throwable)e);
            return;
        }
        RequestUtil.setCookie(response, verifyCode, value, -1, this.domain, null);
    }

    public String getKaptchaIdentity(HttpServletRequest request) {
        String capText = null;
        Cookie c = RequestUtil.getCookie(request, verifyCode);
        if (c != null) {
            capText = c.getValue();
        }
        return capText;
    }

    public void clearCookie(HttpServletResponse response) {
        Cookie cookie = new Cookie(this.home, null);
        cookie.setMaxAge(0);
        cookie.setPath("/");
        response.addCookie(cookie);
    }

    private Boolean isExpire(Long value) {
        Calendar c = Calendar.getInstance();
        try {
            Long interval = c.getTimeInMillis() - value;
            Integer days = (int)(interval / 1000L);
            if (days > this.cookieMaxAge) {
                return true;
            }
        }
        catch (Exception e) {
            log.error((Object)"got error when determine cookie isExpire", (Throwable)e);
            return true;
        }
        return false;
    }

    public String getHome() {
        return this.home;
    }

    public void setHome(String home) {
        this.home = home;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public Integer getCookieMaxAge() {
        return this.cookieMaxAge;
    }

    public void setCookieMaxAge(Integer cookieMaxAge) {
        this.cookieMaxAge = cookieMaxAge;
    }
}

