/*
 * Decompiled with CFR 0.152.
 */
package io.openvidu.java.client;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.openvidu.java.client.MediaMode;
import io.openvidu.java.client.Recording;
import io.openvidu.java.client.RecordingLayout;
import io.openvidu.java.client.RecordingMode;

public class SessionProperties {
    private MediaMode mediaMode;
    private RecordingMode recordingMode;
    private Recording.OutputMode defaultOutputMode;
    private RecordingLayout defaultRecordingLayout;
    private String defaultCustomLayout;
    private String customSessionId;
    private String mediaNode;

    protected SessionProperties() {
        this.mediaMode = MediaMode.ROUTED;
        this.recordingMode = RecordingMode.MANUAL;
        this.defaultOutputMode = Recording.OutputMode.COMPOSED;
        this.defaultRecordingLayout = RecordingLayout.BEST_FIT;
        this.defaultCustomLayout = "";
        this.customSessionId = "";
        this.mediaNode = "";
    }

    private SessionProperties(MediaMode mediaMode, RecordingMode recordingMode, Recording.OutputMode outputMode, RecordingLayout layout, String defaultCustomLayout, String customSessionId, String mediaNode) {
        this.mediaMode = mediaMode;
        this.recordingMode = recordingMode;
        this.defaultOutputMode = outputMode;
        this.defaultRecordingLayout = layout;
        this.defaultCustomLayout = defaultCustomLayout;
        this.customSessionId = customSessionId;
        this.mediaNode = mediaNode;
    }

    public MediaMode mediaMode() {
        return this.mediaMode;
    }

    public RecordingMode recordingMode() {
        return this.recordingMode;
    }

    public Recording.OutputMode defaultOutputMode() {
        return this.defaultOutputMode;
    }

    public RecordingLayout defaultRecordingLayout() {
        return this.defaultRecordingLayout;
    }

    public String defaultCustomLayout() {
        return this.defaultCustomLayout;
    }

    public String customSessionId() {
        return this.customSessionId;
    }

    public String mediaNode() {
        return this.mediaNode;
    }

    protected JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("mediaMode", this.mediaMode().name());
        json.addProperty("recordingMode", this.recordingMode().name());
        json.addProperty("defaultOutputMode", this.defaultOutputMode().name());
        json.addProperty("defaultRecordingLayout", this.defaultRecordingLayout().name());
        json.addProperty("defaultCustomLayout", this.defaultCustomLayout());
        json.addProperty("customSessionId", this.customSessionId());
        if (this.mediaNode() != null) {
            JsonObject mediaNodeJson = new JsonObject();
            mediaNodeJson.addProperty("id", this.mediaNode());
            json.add("mediaNode", (JsonElement)mediaNodeJson);
        }
        return json;
    }

    public static class Builder {
        private MediaMode mediaMode = MediaMode.ROUTED;
        private RecordingMode recordingMode = RecordingMode.MANUAL;
        private Recording.OutputMode defaultOutputMode = Recording.OutputMode.COMPOSED;
        private RecordingLayout defaultRecordingLayout = RecordingLayout.BEST_FIT;
        private String defaultCustomLayout = "";
        private String customSessionId = "";
        private String mediaNode;

        public SessionProperties build() {
            return new SessionProperties(this.mediaMode, this.recordingMode, this.defaultOutputMode, this.defaultRecordingLayout, this.defaultCustomLayout, this.customSessionId, this.mediaNode);
        }

        public Builder mediaMode(MediaMode mediaMode) {
            this.mediaMode = mediaMode;
            return this;
        }

        public Builder recordingMode(RecordingMode recordingMode) {
            this.recordingMode = recordingMode;
            return this;
        }

        public Builder defaultOutputMode(Recording.OutputMode outputMode) {
            this.defaultOutputMode = outputMode;
            return this;
        }

        public Builder defaultRecordingLayout(RecordingLayout layout) {
            this.defaultRecordingLayout = layout;
            return this;
        }

        public Builder defaultCustomLayout(String path) {
            this.defaultCustomLayout = path;
            return this;
        }

        public Builder customSessionId(String customSessionId) {
            this.customSessionId = customSessionId;
            return this;
        }

        public Builder mediaNode(String mediaNodeId) {
            this.mediaNode = mediaNodeId;
            return this;
        }
    }
}

