/*
 * Decompiled with CFR 0.152.
 */
package io.openvidu.java.client;

import io.openvidu.java.client.Recording;
import io.openvidu.java.client.RecordingLayout;

public class RecordingProperties {
    private String name;
    private Recording.OutputMode outputMode;
    private RecordingLayout recordingLayout;
    private String customLayout;
    private String token;
    private String resolution;
    private boolean hasAudio;
    private boolean hasVideo;
    private long shmSize;

    protected RecordingProperties(String name, Recording.OutputMode outputMode, RecordingLayout layout, String customLayout, String resolution, boolean hasAudio, boolean hasVideo, long shmSize, String token) {
        this.name = name;
        this.outputMode = outputMode;
        this.recordingLayout = layout;
        this.customLayout = customLayout;
        this.resolution = resolution;
        this.hasAudio = hasAudio;
        this.hasVideo = hasVideo;
        this.shmSize = shmSize;
        this.token = token;
    }

    public String name() {
        return this.name;
    }

    public Recording.OutputMode outputMode() {
        return this.outputMode;
    }

    public RecordingLayout recordingLayout() {
        return this.recordingLayout;
    }

    public String customLayout() {
        return this.customLayout;
    }

    public String resolution() {
        return this.resolution;
    }

    public boolean hasAudio() {
        return this.hasAudio;
    }

    public boolean hasVideo() {
        return this.hasVideo;
    }

    public long shmSize() {
        return this.shmSize;
    }

    public String token() {
        return this.token;
    }

    public static class Builder {
        private String name = "";
        private Recording.OutputMode outputMode = Recording.OutputMode.COMPOSED;
        private RecordingLayout recordingLayout;
        private String customLayout;
        private String token = "";
        private String resolution;
        private boolean hasAudio = true;
        private boolean hasVideo = true;
        private long shmSize = 0x20000000L;

        public RecordingProperties build() {
            if (Recording.OutputMode.COMPOSED.equals((Object)this.outputMode) || Recording.OutputMode.COMPOSED_QUICK_START.equals((Object)this.outputMode)) {
                this.recordingLayout = this.recordingLayout != null ? this.recordingLayout : RecordingLayout.BEST_FIT;
                String string = this.resolution = this.resolution != null ? this.resolution : "1920x1080";
                if (RecordingLayout.CUSTOM.equals((Object)this.recordingLayout)) {
                    this.customLayout = this.customLayout != null ? this.customLayout : "";
                }
            }
            return new RecordingProperties(this.name, this.outputMode, this.recordingLayout, this.customLayout, this.resolution, this.hasAudio, this.hasVideo, this.shmSize, this.token);
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder outputMode(Recording.OutputMode outputMode) {
            this.outputMode = outputMode;
            return this;
        }

        public Builder recordingLayout(RecordingLayout layout) {
            this.recordingLayout = layout;
            return this;
        }

        public Builder customLayout(String path) {
            this.customLayout = path;
            return this;
        }

        public Builder resolution(String resolution) {
            this.resolution = resolution;
            return this;
        }

        public Builder hasAudio(boolean hasAudio) {
            this.hasAudio = hasAudio;
            return this;
        }

        public Builder hasVideo(boolean hasVideo) {
            this.hasVideo = hasVideo;
            return this;
        }

        public Builder shmSize(long shmSize) {
            this.shmSize = shmSize;
            return this;
        }

        public Builder token(String token) {
            this.token = token;
            return this;
        }
    }
}

