/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.vctl.sca.client;

import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.apache.tuscany.sca.assembly.Component;
import org.apache.tuscany.sca.assembly.ComponentService;
import org.apache.tuscany.sca.assembly.Composite;
import org.apache.tuscany.sca.node.Contribution;
import org.apache.tuscany.sca.node.ContributionLocationHelper;
import org.apache.tuscany.sca.node.Node;
import org.apache.tuscany.sca.node.NodeFactory;
import org.apache.tuscany.sca.node.extensibility.NodeExtension;
import org.springframework.beans.factory.FactoryBean;

public class SCAServiceFactory
implements FactoryBean<Object> {
    private Logger logger = Logger.getLogger(SCAServiceFactory.class);
    private static Node clientNode = null;
    private String serviceName;
    private Class serviceInterface;

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public Class getServiceInterface() {
        return this.serviceInterface;
    }

    public void setServiceInterface(Class serviceInterface) {
        this.serviceInterface = serviceInterface;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void init() throws Exception {
        if (clientNode != null) return;
        Class<SCAServiceFactory> clazz = SCAServiceFactory.class;
        synchronized (SCAServiceFactory.class) {
            if (clientNode != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"serviceFactory afterPropertiesSet");
            }
            String contribution = ContributionLocationHelper.getContributionLocation((String)"client.composite");
            clientNode = NodeFactory.newInstance().createNode("client.composite", new Contribution[]{new Contribution("lenovo", contribution)});
            clientNode.start();
            this.logger.info((Object)"clientNode is running.... ok");
            if (!this.logger.isDebugEnabled()) return;
            if (clientNode instanceof NodeExtension) {
                Composite composite = ((NodeExtension)clientNode).getDomainComposite();
                if (composite != null) {
                    List components = composite.getComponents();
                    if (!CollectionUtils.isNotEmpty((Collection)components)) return;
                    for (Component component : components) {
                        List componentServices = component.getServices();
                        for (ComponentService componentService : componentServices) {
                            String serviceName = componentService.getName();
                            this.logger.info((Object)("sca service name:" + serviceName));
                        }
                    }
                } else {
                    this.logger.warn((Object)"client composite is null");
                }
            } else {
                this.logger.warn((Object)"clientNode is not NodeExtension ");
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public void destroy() {
        clientNode.stop();
        this.logger.info((Object)"clientNode stoped.... ok");
    }

    public Object getObject() throws Exception {
        if (clientNode == null) {
            throw new RuntimeException("clientNode must init, please call init method before call this method");
        }
        if (StringUtils.isEmpty((CharSequence)this.getServiceName())) {
            throw new RuntimeException("ServiceName must set value");
        }
        if (this.getServiceInterface() == null) {
            throw new RuntimeException("ServiceInterface must set value");
        }
        return clientNode.getService(this.getServiceInterface(), this.getServiceName());
    }

    public Class<?> getObjectType() {
        return this.getServiceInterface();
    }

    public boolean isSingleton() {
        return true;
    }

    public static void main(String[] args) throws Exception {
        System.out.println(ContributionLocationHelper.getContributionLocation((String)"client.composite"));
    }
}

