/*
 * Decompiled with CFR 0.152.
 */
package com.gemantic.dal.route;

import com.gemantic.dal.config.helper.DaoHelper;
import com.gemantic.dal.config.model.dao.DbStrategyItem;
import com.gemantic.dal.dao.exception.StrategyException;
import com.gemantic.dal.datasource.ContextHolder;
import com.gemantic.dal.route.strategy.IStrategy;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class RoutingService {
    private static Logger logger = Logger.getLogger(RoutingService.class);
    private static RoutingService routingService;
    private static Map<String, IStrategy> objectStrategy;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RoutingService getInstance() {
        if (routingService != null) return routingService;
        Class<RoutingService> clazz = RoutingService.class;
        synchronized (RoutingService.class) {
            routingService = new RoutingService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return routingService;
        }
    }

    private RoutingService() {
    }

    public void setRoutingStrategyForObject(Class clazz, Object account, int rw) throws StrategyException {
        DbStrategyItem dbStrategyItem;
        IStrategy strategy = objectStrategy.get(clazz.getClass().getName());
        if (strategy == null && (dbStrategyItem = DaoHelper.getDbStrategyItemByClass(clazz)) != null) {
            try {
                String className = dbStrategyItem.getClasz();
                if (StringUtils.isNotEmpty((String)className)) {
                    strategy = (IStrategy)Class.forName(dbStrategyItem.getClasz()).newInstance();
                    objectStrategy.put(clazz.getName(), strategy);
                } else {
                    logger.error((Object)(StringUtils.defaultIfEmpty((String)dbStrategyItem.getName(), (String)"") + " stratey clazz property must have value, please set in dao.xml"));
                }
            }
            catch (Exception e) {
                if (logger.isDebugEnabled()) {
                    e.printStackTrace(System.err);
                }
                logger.error((Object)("don't instance " + StringUtils.defaultIfEmpty((String)dbStrategyItem.getClasz(), (String)"")));
            }
        }
        if (strategy != null) {
            ContextHolder.setDataSource(String.valueOf(strategy.ObjectShardingStrategy(clazz, account, rw)));
        }
    }

    public List<String> getReadDsFromEachGroupForObject(Class clazz) throws StrategyException {
        DbStrategyItem dbStrategyItem;
        IStrategy strategy = objectStrategy.get(clazz.getClass().getName());
        if (strategy == null && (dbStrategyItem = DaoHelper.getDbStrategyItemByClass(clazz)) != null) {
            try {
                String className = dbStrategyItem.getClasz();
                if (StringUtils.isNotEmpty((String)className)) {
                    strategy = (IStrategy)Class.forName(dbStrategyItem.getClasz()).newInstance();
                    objectStrategy.put(clazz.getName(), strategy);
                } else {
                    logger.error((Object)(StringUtils.defaultIfEmpty((String)dbStrategyItem.getName(), (String)"") + " stratey clazz property must have value, please set in dao.xml"));
                }
            }
            catch (Exception e) {
                if (logger.isDebugEnabled()) {
                    e.printStackTrace(System.err);
                }
                logger.error((Object)("don't instance " + StringUtils.defaultIfEmpty((String)dbStrategyItem.getClasz(), (String)"")));
            }
        }
        if (strategy != null) {
            return strategy.getOneDSFromEachGroupOfObject(clazz, 1);
        }
        return null;
    }

    public void setRoutingStrategyForList(String listName, Object account, int rw) throws StrategyException {
        DbStrategyItem dbStrategyItem;
        IStrategy strategy = objectStrategy.get(listName);
        if (strategy == null && (dbStrategyItem = DaoHelper.getDbStrategyItemByListName(listName)) != null) {
            try {
                String className = dbStrategyItem.getClasz();
                if (StringUtils.isNotEmpty((String)className)) {
                    strategy = (IStrategy)Class.forName(className).newInstance();
                    objectStrategy.put(listName, strategy);
                } else {
                    logger.error((Object)(StringUtils.defaultIfEmpty((String)dbStrategyItem.getName(), (String)"") + " stratey clazz property must have value, please set in dao.xml"));
                }
            }
            catch (Exception e) {
                if (logger.isDebugEnabled()) {
                    e.printStackTrace(System.err);
                }
                logger.error((Object)("don't instance " + StringUtils.defaultIfEmpty((String)dbStrategyItem.getClasz(), (String)"")));
            }
        }
        if (strategy != null) {
            ContextHolder.setDataSource(String.valueOf(strategy.ListShardingStrategy(listName, account, rw)));
        }
    }

    public void setRoutingStrategyForMap(String mapName, Object account, int rw) throws StrategyException {
        DbStrategyItem dbStrategyItem;
        IStrategy strategy = objectStrategy.get(mapName);
        if (strategy == null && (dbStrategyItem = DaoHelper.getDbStrategyItemByMapName(mapName)) != null) {
            try {
                String className = dbStrategyItem.getClasz();
                if (StringUtils.isNotEmpty((String)className)) {
                    strategy = (IStrategy)Class.forName(className).newInstance();
                    objectStrategy.put(mapName, strategy);
                } else {
                    logger.error((Object)(StringUtils.defaultIfEmpty((String)dbStrategyItem.getName(), (String)"") + " stratey clazz property must have value, please set in dao.xml"));
                }
            }
            catch (Exception e) {
                if (logger.isDebugEnabled()) {
                    e.printStackTrace(System.err);
                }
                logger.error((Object)("don't instance " + StringUtils.defaultIfEmpty((String)dbStrategyItem.getClasz(), (String)"")));
            }
        }
        if (strategy != null) {
            ContextHolder.setDataSource(String.valueOf(strategy.MapShardingStrategy(mapName, account, rw)));
        }
    }

    public boolean isReadWrite(Class clazz, Object account) {
        DbStrategyItem dbStrategyItem;
        IStrategy strategy = objectStrategy.get(clazz.getClass().getName());
        if (strategy == null && (dbStrategyItem = DaoHelper.getDbStrategyItemByClass(clazz)) != null) {
            try {
                String className = dbStrategyItem.getClasz();
                if (StringUtils.isNotEmpty((String)className)) {
                    strategy = (IStrategy)Class.forName(dbStrategyItem.getClasz()).newInstance();
                    objectStrategy.put(clazz.getName(), strategy);
                } else {
                    logger.error((Object)(StringUtils.defaultIfEmpty((String)dbStrategyItem.getName(), (String)"") + " stratey clazz property must have value, please set in dao.xml"));
                }
            }
            catch (Exception e) {
                if (logger.isDebugEnabled()) {
                    e.printStackTrace(System.err);
                }
                logger.error((Object)("don't instance " + StringUtils.defaultIfEmpty((String)dbStrategyItem.getClasz(), (String)"")));
            }
        }
        if (strategy != null) {
            try {
                return strategy.isReadWrite(clazz, account);
            }
            catch (StrategyException e) {
                e.printStackTrace(System.err);
            }
        }
        return false;
    }

    public boolean nextRoutingStrategyForList(String listName, int rw) throws StrategyException {
        DbStrategyItem dbStrategyItem;
        IStrategy strategy = objectStrategy.get(listName);
        if (strategy == null && (dbStrategyItem = DaoHelper.getDbStrategyItemByListName(listName)) != null) {
            try {
                String className = dbStrategyItem.getClasz();
                if (StringUtils.isNotEmpty((String)className)) {
                    strategy = (IStrategy)Class.forName(className).newInstance();
                    objectStrategy.put(listName, strategy);
                } else {
                    logger.error((Object)(StringUtils.defaultIfEmpty((String)dbStrategyItem.getName(), (String)"") + " stratey clazz property must have value, please set in dao.xml"));
                }
            }
            catch (Exception e) {
                if (logger.isDebugEnabled()) {
                    e.printStackTrace(System.err);
                }
                logger.error((Object)("don't instance " + StringUtils.defaultIfEmpty((String)dbStrategyItem.getClasz(), (String)"")));
            }
        }
        if (strategy != null) {
            Object ds = strategy.NextListShardingStrategy(listName, rw);
            if (ds == null) {
                return false;
            }
            ContextHolder.setDataSource(String.valueOf(ds));
            return true;
        }
        return false;
    }

    public static void main(String[] args) {
        try {
            while (RoutingService.getInstance().nextRoutingStrategyForList("Photo_List_UserId_Id", 1)) {
                System.out.println("S");
            }
        }
        catch (StrategyException e) {
            e.printStackTrace();
        }
    }

    static {
        objectStrategy = new ConcurrentHashMap<String, IStrategy>();
    }
}

