/*
 * Decompiled with CFR 0.152.
 */
package com.gemantic.dal.dao.util;

import com.gemantic.dal.config.helper.DaoHelper;
import com.gemantic.dal.config.model.dao.ListItem;
import com.gemantic.dal.config.model.dao.MapItem;
import com.gemantic.dal.dao.helper.LogHelper;
import com.gemantic.dal.dao.helper.LsCacheInfoHelper;
import com.gemantic.dal.dao.model.ScalarInfo;
import com.gemantic.dal.dao.model.SqlInfo;
import com.gemantic.dal.dao.util.ObjectUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.type.Type;
import org.hibernate.type.TypeFactory;

public class SqlUtil {
    private static Log log = LogFactory.getLog(SqlUtil.class);
    public static final int IN_CNT = 10;
    public static final int UNION_CNT = 30;

    public static SqlInfo getMappingSqlInfo(String mappingName, Object[] params, boolean bExtend) {
        SqlInfo sqlInfo = null;
        MapItem mapItem = DaoHelper.getMapItemByMapName(mappingName);
        String sql = mapItem.getSqlitem();
        if (!bExtend) {
            String column = DaoHelper.getMapItemValueColumnName(mappingName);
            Type type = TypeFactory.basic((String)DaoHelper.getMapItemValueClass(mappingName).getName());
            ScalarInfo scalarInfo = new ScalarInfo(column, type);
            ArrayList<ScalarInfo> scaList = new ArrayList<ScalarInfo>();
            scaList.add(scalarInfo);
            sqlInfo = new SqlInfo(sql, params, scaList);
        } else {
            sqlInfo = new SqlInfo(sql, params, null);
        }
        return sqlInfo;
    }

    public static SqlInfo getListSql(String listName, Object[] params, boolean bReverse) {
        if (bReverse) {
            return SqlUtil.getReverseListSql(listName, params);
        }
        return SqlUtil.getAscListSql(listName, params);
    }

    public static SqlInfo getListSql(LsCacheInfoHelper lsHelper, boolean bReverse) {
        if (null == lsHelper || null == lsHelper.getRegion()) {
            LogHelper.listParamsNull(log, lsHelper);
            return null;
        }
        return SqlUtil.getListSql(lsHelper.getRegion(), lsHelper.getParams(), bReverse);
    }

    private static SqlInfo getAscListSql(String listName, Object[] params) {
        Integer listType = ObjectUtil.getListType(listName);
        SqlInfo sqlInfo = null;
        String sql = null;
        ListItem listItem = DaoHelper.getListItemByListName(listName);
        switch (listType) {
            case 1: {
                sql = listItem.getSqlitem();
                String iDColumn = listItem.getColumnName();
                Type type = TypeFactory.basic((String)DaoHelper.getListItemValueClass(listName).getName());
                ScalarInfo scalarInfo = new ScalarInfo(iDColumn, type);
                ArrayList<ScalarInfo> scaList = new ArrayList<ScalarInfo>();
                scaList.add(scalarInfo);
                sqlInfo = new SqlInfo(sql, params, scaList);
                break;
            }
            case 3: {
                sql = listItem.getSqlCross();
                String idColumn = listItem.getColumnName();
                Type idTtype = TypeFactory.basic((String)DaoHelper.getListItemValueClass(listName).getName());
                ScalarInfo idScalarInfo = new ScalarInfo(idColumn, idTtype);
                String accountColumn = listItem.getStrategyColumn();
                ScalarInfo accountScalarInfo = new ScalarInfo(accountColumn, null);
                String createTimeColumn = listItem.getCrossOrderByColumn();
                ScalarInfo createTimeScalarInfo = new ScalarInfo(createTimeColumn, null);
                ArrayList<ScalarInfo> crossScaList = new ArrayList<ScalarInfo>();
                crossScaList.add(idScalarInfo);
                crossScaList.add(accountScalarInfo);
                crossScaList.add(createTimeScalarInfo);
                sqlInfo = new SqlInfo(sql, params, crossScaList);
                break;
            }
        }
        return sqlInfo;
    }

    private static SqlInfo getReverseListSql(String listName, Object[] params) {
        Integer listType = ObjectUtil.getListType(listName);
        SqlInfo sqlInfo = null;
        String sql = null;
        ListItem listItem = DaoHelper.getListItemByListName(listName);
        switch (listType) {
            case 1: {
                sql = listItem.getReverseSql();
                String iDColumn = listItem.getColumnName();
                Type type = TypeFactory.basic((String)DaoHelper.getListItemValueClass(listName).getName());
                ScalarInfo scalarInfo = new ScalarInfo(iDColumn, type);
                ArrayList<ScalarInfo> scaList = new ArrayList<ScalarInfo>();
                scaList.add(scalarInfo);
                sqlInfo = new SqlInfo(sql, params, scaList);
                break;
            }
            case 3: {
                sql = listItem.getReverseSqlCross();
                String idColumn = listItem.getColumnName();
                Type idTtype = TypeFactory.basic((String)DaoHelper.getListItemValueClass(listName).getName());
                ScalarInfo idScalarInfo = new ScalarInfo(idColumn, idTtype);
                String accountColumn = listItem.getStrategyColumn();
                ScalarInfo accountScalarInfo = new ScalarInfo(accountColumn, null);
                String createTimeColumn = listItem.getCrossOrderByColumn();
                ScalarInfo createTimeScalarInfo = new ScalarInfo(createTimeColumn, null);
                ArrayList<ScalarInfo> crossScaList = new ArrayList<ScalarInfo>();
                crossScaList.add(idScalarInfo);
                crossScaList.add(accountScalarInfo);
                crossScaList.add(createTimeScalarInfo);
                sqlInfo = new SqlInfo(sql, params, crossScaList);
                break;
            }
        }
        return sqlInfo;
    }

    public static SqlInfo getListCountSql(String listName, Object[] params) {
        Integer listType = ObjectUtil.getListType(listName);
        SqlInfo sqlInfo = null;
        String sql = null;
        ListItem listItem = DaoHelper.getListItemByListName(listName);
        switch (listType) {
            case 1: {
                sql = listItem.getSqlcountitem();
                sqlInfo = new SqlInfo(sql, params, null);
                break;
            }
            case 3: {
                sql = listItem.getSqlCrossCount();
                sqlInfo = new SqlInfo(sql, params, null);
                break;
            }
        }
        return sqlInfo;
    }

    public static SqlInfo getListCountSql(LsCacheInfoHelper lsHelper) {
        return SqlUtil.getListCountSql(lsHelper.getRegion(), lsHelper.getParams());
    }

    public static SqlInfo getCrossDBSectionSql(String listName, Object[] params1, Object[] params2) {
        SqlInfo sqlInfo = null;
        ListItem listItem = DaoHelper.getListItemByListName(listName);
        if (null == listItem.getType() || 3 != listItem.getType()) {
            return null;
        }
        String sql = listItem.getSqlCrossSecion();
        ArrayList<Object> paramList = new ArrayList<Object>();
        for (Object obj : params1) {
            paramList.add(obj);
        }
        for (Object obj : params2) {
            paramList.add(obj);
        }
        sqlInfo = new SqlInfo(sql, paramList.toArray(), null);
        return sqlInfo;
    }

    public static List<SqlInfo> getMapAggreSqlInfos(String mapName, List<Object[]> paramsList) {
        MapItem mapItem = DaoHelper.getMapItemByMapName(mapName);
        return SqlUtil.getUnionSql(paramsList, mapItem.getSqlitem(), null);
    }

    public static List<SqlInfo> getInSql(List<Object[]> paramsList, String baseSql, List<Type> returnTypes) {
        ArrayList<SqlInfo> sqlInfoList = new ArrayList<SqlInfo>();
        int leftCnts = paramsList.size() % 10;
        int fullCnts = paramsList.size() / 10;
        int index = baseSql.indexOf("=");
        String subSql = baseSql.substring(0, index);
        for (int i = 0; i < fullCnts; ++i) {
            String sql = SqlUtil.getInAggrSql(subSql, 10);
            int start = i * 10;
            int end = (i + 1) * 10;
            Object[] realParams = SqlUtil.getAggrParams(paramsList.subList(start, end));
            if (null == realParams) continue;
            SqlInfo sqlInfo = new SqlInfo(sql, realParams, null);
            sqlInfoList.add(sqlInfo);
        }
        if (leftCnts > 0) {
            String sql = SqlUtil.getInAggrSql(subSql, leftCnts);
            Object[] realParams = SqlUtil.getAggrParams(paramsList = paramsList.subList(fullCnts * 10, paramsList.size()));
            if (null != realParams) {
                SqlInfo sqlInfo = new SqlInfo(sql, realParams, null);
                sqlInfoList.add(sqlInfo);
            }
        }
        return sqlInfoList;
    }

    private static String getInAggrSql(String sql, int count) {
        StringBuffer allSql = new StringBuffer();
        if (count == 10) {
            allSql.append(sql).append(" in (?,?,?,?,?,?,?,?,?,?)");
        } else {
            allSql.append(sql).append(" in (");
            for (int i = 0; i < count; ++i) {
                if (i > 0) {
                    allSql.append(",?");
                    continue;
                }
                allSql.append("?");
            }
            allSql.append(" ) ");
        }
        return allSql.toString();
    }

    public static List<SqlInfo> getUnionSql(List<Object[]> paramsList, String baseSql, List<Type> returnTypes) {
        ArrayList<SqlInfo> sqlInfoList = new ArrayList<SqlInfo>();
        int unionCnt = 30;
        int leftCnts = paramsList.size() % 30;
        int fullCnts = paramsList.size() / 30;
        for (int i = 0; i < fullCnts; ++i) {
            String sql = SqlUtil.getUnionAggrSql(baseSql, 30);
            int start = i * 30;
            int end = (i + 1) * 30;
            Object[] realParams = SqlUtil.getAggrParams(paramsList.subList(start, end));
            if (null == realParams) continue;
            SqlInfo sqlInfo = new SqlInfo(sql, realParams, null);
            sqlInfoList.add(sqlInfo);
        }
        if (leftCnts > 0) {
            String sql = SqlUtil.getUnionAggrSql(baseSql, leftCnts);
            Object[] realParams = SqlUtil.getAggrParams(paramsList = paramsList.subList(fullCnts * 30, paramsList.size()));
            if (null != realParams) {
                SqlInfo sqlInfo = new SqlInfo(sql, realParams, null);
                sqlInfoList.add(sqlInfo);
            }
        }
        return sqlInfoList;
    }

    private static String getUnionAggrSql(String sql, int count) {
        StringBuffer allSql = new StringBuffer();
        for (int i = 0; i < count; ++i) {
            if (i < count - 1) {
                allSql.append(sql).append(" union all ");
                continue;
            }
            allSql.append(sql);
        }
        return allSql.toString();
    }

    public static List<SqlInfo> getEntityUnionSql(List idList, String baseSql) {
        List<SqlInfo> sqlInfoList = null;
        if (idList.size() > 0) {
            ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
            for (Object id : idList) {
                if (null == id) continue;
                paramsList.add(new Object[]{id});
            }
            if (paramsList.size() > 0) {
                return SqlUtil.getUnionSql(paramsList, baseSql, null);
            }
        }
        return sqlInfoList;
    }

    public static Object[] getAggrParams(List<Object[]> paramsList) {
        ArrayList<Object> aggrList = new ArrayList<Object>();
        for (Object[] params : paramsList) {
            for (Object param : params) {
                if (null == param) {
                    return null;
                }
                aggrList.add(param);
            }
        }
        return aggrList.toArray();
    }

    public static void main(String[] args) {
        ArrayList<Object[]> newList = new ArrayList<Object[]>();
        for (int i = 21; i > 0; --i) {
            newList.add(new Object[]{1});
        }
        List<SqlInfo> sqlInfoList = SqlUtil.getUnionSql(newList, "select * from tables where id =?", null);
        for (SqlInfo sqlIfo : sqlInfoList) {
            System.out.println(" =========Sql ========\r\n");
            System.out.println(sqlIfo.getSql());
        }
    }
}

