/*
 * Decompiled with CFR 0.152.
 */
package com.gemantic.dal.dao.util;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.collections.map.LRUMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DalLRUMap
implements Map,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(DalLRUMap.class);
    private ReadWriteLock rw = new ReentrantReadWriteLock();
    private LRUMap map;

    public DalLRUMap() {
        this.map = new LRUMap();
    }

    public DalLRUMap(int maxSize) {
        this.map = new LRUMap(maxSize);
    }

    public DalLRUMap(int maxSize, boolean scanUntilRemovable) {
        this.map = new LRUMap(maxSize, scanUntilRemovable);
    }

    public DalLRUMap(int maxSize, float loadFactor) {
        this.map = new LRUMap(maxSize, loadFactor);
    }

    public DalLRUMap(int maxSize, float loadFactor, boolean scanUntilRemovable) {
        this.map = new LRUMap(maxSize, loadFactor, scanUntilRemovable);
    }

    public DalLRUMap(Map map) {
        map = new LRUMap(map);
    }

    public DalLRUMap(Map map, boolean scanUntilRemovable) {
        map = new LRUMap(map, scanUntilRemovable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        int size = -1;
        Lock lock = null;
        try {
            lock = this.rw.readLock();
            lock.lock();
            size = this.map.size();
        }
        finally {
            if (lock != null) {
                lock.unlock();
            }
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        boolean empty = true;
        Lock lock = null;
        try {
            lock = this.rw.readLock();
            lock.lock();
            empty = this.map.isEmpty();
        }
        finally {
            if (lock != null) {
                lock.unlock();
            }
        }
        return empty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(Object key) {
        boolean contains = false;
        Lock lock = null;
        try {
            lock = this.rw.readLock();
            lock.lock();
            contains = this.map.containsKey(key);
        }
        finally {
            if (lock != null) {
                lock.unlock();
            }
        }
        return contains;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsValue(Object value) {
        boolean contains = false;
        Lock lock = null;
        try {
            lock = this.rw.readLock();
            lock.lock();
            contains = this.map.containsValue(value);
        }
        finally {
            if (lock != null) {
                lock.unlock();
            }
        }
        return contains;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(Object key) {
        Lock lock = null;
        Object value = null;
        try {
            lock = this.rw.readLock();
            lock.lock();
            value = this.map.get(key);
        }
        finally {
            if (lock != null) {
                lock.unlock();
            }
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object put(Object key, Object value) {
        Lock lock = null;
        Object object = null;
        try {
            lock = this.rw.writeLock();
            lock.lock();
            object = this.map.put(key, value);
        }
        finally {
            if (lock != null) {
                lock.unlock();
            }
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(Object key) {
        Lock lock = null;
        Object object = null;
        try {
            lock = this.rw.writeLock();
            lock.lock();
            object = this.map.remove(key);
        }
        finally {
            if (lock != null) {
                lock.unlock();
            }
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putAll(Map t) {
        Lock lock = null;
        try {
            lock = this.rw.writeLock();
            lock.lock();
            this.map.putAll(t);
        }
        finally {
            if (lock != null) {
                lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Lock lock = null;
        try {
            lock = this.rw.writeLock();
            lock.lock();
            this.map.clear();
        }
        finally {
            if (lock != null) {
                lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set keySet() {
        Set set = null;
        Lock lock = null;
        try {
            lock = this.rw.readLock();
            lock.lock();
            set = this.map.keySet();
        }
        finally {
            if (lock != null) {
                lock.unlock();
            }
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection values() {
        Collection values = null;
        Lock lock = null;
        try {
            lock = this.rw.readLock();
            lock.lock();
            values = this.map.values();
        }
        finally {
            if (lock != null) {
                lock.unlock();
            }
        }
        return values;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set entrySet() {
        Set set = null;
        Lock lock = null;
        try {
            lock = this.rw.readLock();
            lock.lock();
            set = this.map.entrySet();
        }
        finally {
            if (lock != null) {
                lock.unlock();
            }
        }
        return set;
    }

    @Override
    public boolean equals(Object o) {
        return this.map.equals(o);
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }
}

