/*
 * Decompiled with CFR 0.152.
 */
package com.gemantic.dal.dao.util;

import com.gemantic.dal.config.helper.DaoHelper;
import com.gemantic.dal.config.model.dao.MapItem;
import com.gemantic.dal.dao.exception.DaoException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import org.hibernate.SessionFactory;

public class DalAssert {
    public static void assertObjectIllegal(Object userId, Object obj) throws DaoException {
        if (null != userId && null != obj) {
            Method method = DaoHelper.getStrategyPropertyMethod(obj.getClass().getName());
            if (null == method) {
                throw new DaoException(200, "Error: method doesn't found");
            }
            Object requiredId = null;
            try {
                requiredId = method.invoke(obj, new Object[0]);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            if (null != requiredId && !requiredId.equals(userId)) {
                throw new DaoException(100, "Error: The account_id doesn't match the object strategy propertyDetail: userId --" + userId + " obj's userId --" + requiredId + "\r\n");
            }
        }
    }

    public static void assertListIllegal(Object userId, List list) throws DaoException {
        if (null != userId && null != list && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                DalAssert.assertObjectIllegal(userId, list.get(i));
            }
        }
    }

    public static void assertClassTypeNotNull(Class cls) throws DaoException {
        if (null == cls) {
            throw new DaoException(300);
        }
    }

    public static void assertObjectNotNull(Object obj) throws DaoException {
        if (null == obj) {
            throw new DaoException(301);
        }
    }

    public static void assertObjectNotNull(List obs) throws DaoException {
        if (null == obs) {
            throw new DaoException(301);
        }
        for (Object obj : obs) {
            if (null != obs) continue;
            throw new DaoException(301);
        }
    }

    public static void assertObjectNotNull(Object obj, String description) throws DaoException {
        if (null == obj) {
            throw new DaoException(303, description);
        }
    }

    public static void assertSessionFactoryNotNull(SessionFactory sessionFactory) throws DaoException {
        if (null == sessionFactory) {
            throw new DaoException(302);
        }
    }

    public static void assertDaoMapException(MapItem mapItem) throws DaoException {
        if (null == mapItem) {
            throw new DaoException(304);
        }
        if (null == mapItem.getSqlitem()) {
            throw new DaoException(305);
        }
    }

    public static void assertTwoListEquals(List list1, List list2) throws DaoException {
        if (list1.size() != list2.size()) {
            throw new DaoException(402);
        }
    }
}

