/*
 * Decompiled with CFR 0.152.
 */
package com.gemantic.dal.dao.util;

import com.gemantic.dal.cache.Cache;
import com.gemantic.dal.cache.exception.CacheException;
import com.gemantic.dal.dao.helper.ListInfoHelper;
import com.gemantic.dal.dao.helper.LogHelper;
import com.gemantic.dal.dao.helper.LsCacheInfoHelper;
import com.gemantic.dal.dao.model.ListInfo;
import com.gemantic.memcached.CacheFactoryImpl;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CacheHelper {
    private static Log log = LogFactory.getLog(CacheHelper.class);

    public static Cache getListCache(String regionName) {
        Cache cache = CacheFactoryImpl.getInstance().getCache(regionName, Boolean.TRUE.booleanValue());
        if (null == cache) {
            LogHelper.cacheDontConfigured(log, regionName);
        }
        return cache;
    }

    public static Cache getClassCache(Class clazz) {
        if (null == clazz) {
            return null;
        }
        return CacheHelper.getListCache(clazz.getName());
    }

    public static Cache getObjectCache(Object object) {
        if (null == object) {
            return null;
        }
        return CacheHelper.getListCache(object.getClass().toString());
    }

    public static void put(String region, String key, Object value) throws CacheException {
        Cache cache = CacheHelper.getListCache(region);
        if (null != cache) {
            cache.put(key, value);
        }
    }

    public static void save(Class objCls, Serializable id, Object obj) throws CacheException {
        Cache cache = CacheHelper.getClassCache(objCls);
        if (null != cache) {
            cache.save(id.toString(), obj);
        }
    }

    public static Object get(String region, String key) throws CacheException {
        Object obj = null;
        Cache cache = CacheHelper.getListCache(region);
        if (null != cache && null != key) {
            obj = cache.get(key);
        }
        return obj;
    }

    public static Object get(LsCacheInfoHelper lsHelper) throws CacheException {
        return CacheHelper.get(lsHelper.getRegion(), lsHelper.getKey());
    }

    public static Object[] gets(String region, List keyLs) throws CacheException {
        Cache cache = CacheHelper.getListCache(region);
        if (null != cache && null != keyLs && keyLs.size() > 0) {
            return cache.get(keyLs.toArray(new String[keyLs.size()]));
        }
        return null;
    }

    public static void delete(String region, String key) throws CacheException {
        Cache cache = CacheHelper.getListCache(region);
        if (null != cache && null != key) {
            cache.delete(key);
        }
    }

    public static void remove(String region, String key) throws CacheException {
        Cache cache = CacheHelper.getListCache(region);
        if (null != cache) {
            cache.remove(key);
        }
    }

    public static void update(String region, String key, Object value) throws CacheException {
        Cache cache = CacheHelper.getListCache(region);
        if (null != cache) {
            cache.update(key, value);
        }
    }

    public static boolean isDelete(String region, String key) throws CacheException {
        boolean res = true;
        Cache cache = CacheHelper.getListCache(region);
        if (null != cache) {
            res = cache.isDelete(key);
        }
        return res;
    }

    public static void removeListInfo(LsCacheInfoHelper lsHelper) throws CacheException {
        ListInfo listInfo;
        Cache cache = CacheHelper.getListCache(lsHelper.getRegion());
        if (null != cache && null != (listInfo = CacheHelper.getListInfo(lsHelper))) {
            cache.remove(lsHelper.getListCountKey());
            cache.remove(lsHelper.getListVisitInfoKey());
            Map<Long, Long> visitedSections = listInfo.getSections();
            if (null != visitedSections && visitedSections.size() > 0) {
                Iterator<Long> iter = visitedSections.keySet().iterator();
                while (iter.hasNext()) {
                    cache.remove(lsHelper.getIdListKey(new Long("" + iter.next())));
                }
            }
        }
    }

    public static void removeListInfos(LsCacheInfoHelper[] lsHelpers) throws CacheException {
        if (null != lsHelpers) {
            for (LsCacheInfoHelper lsHelper : lsHelpers) {
                CacheHelper.removeListInfo(lsHelper);
            }
        }
    }

    public static void removeListVisitedInfo(LsCacheInfoHelper lsHelper) throws CacheException {
        Cache cache = CacheHelper.getListCache(lsHelper.getRegion());
        if (null != cache) {
            cache.remove(lsHelper.getListVisitInfoKey());
        }
    }

    public static ListInfo getListInfo(LsCacheInfoHelper lsHelper) throws CacheException {
        String key;
        long count;
        Cache cache = CacheHelper.getListCache(lsHelper.getRegion());
        if (null != cache && (count = cache.incr(key = lsHelper.getListCountKey(), 0L)) >= 0L) {
            ListInfo listInfo = new ListInfo(count);
            Map sections = (Map)cache.get(lsHelper.getListVisitInfoKey());
            if (null != sections) {
                listInfo.setSections(sections);
            }
            return listInfo;
        }
        return null;
    }

    public static void putListInfo(LsCacheInfoHelper lsHelper, Long listCnt) throws CacheException {
        Cache cache = CacheHelper.getListCache(lsHelper.getRegion());
        if (null != cache) {
            cache.put(lsHelper.getListCountKey(), (Object)String.valueOf(0));
            cache.incr(lsHelper.getListCountKey(), listCnt.longValue());
            cache.remove(lsHelper.getListVisitInfoKey());
        }
    }

    public static void putListInfo(LsCacheInfoHelper lsHelper, ListInfo listInfo) throws CacheException {
        Cache cache = CacheHelper.getListCache(lsHelper.getRegion());
        if (null != cache) {
            cache.put(lsHelper.getListCountKey(), (Object)new Long(0L));
            cache.incr(lsHelper.getListCountKey(), listInfo.getSize());
            cache.put(lsHelper.getListVisitInfoKey(), listInfo.getSections());
        }
    }

    public static void increaseListSize(LsCacheInfoHelper lsHelper) throws CacheException {
        Cache cache = CacheHelper.getListCache(lsHelper.getRegion());
        if (null != cache) {
            String key = lsHelper.getListCountKey();
            long oldCount = cache.incr(key, 0L);
            long count = cache.incr(lsHelper.getListCountKey(), 1L);
            if (count < 0L) {
                log.warn((Object)("Failed to increment list'size with key: " + lsHelper.getKey() + " ,region :" + lsHelper.getRegion()));
            }
        }
    }

    public static void increaseListSize(LsCacheInfoHelper lsHelper, ListInfoHelper infoHelper) throws CacheException {
        Cache cache = CacheHelper.getListCache(lsHelper.getRegion());
        if (null != cache) {
            CacheHelper.increaseListSize(lsHelper);
            infoHelper.addId();
            cache.put(lsHelper.getListVisitInfoKey(), infoHelper.getVisitedSections());
        }
    }
}

